/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerInvoker;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultChannelProgressivePromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.FailedChannelFuture;
import io.netty.channel.SucceededChannelFuture;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ResourceLeakHint;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.OneTimeTask;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;

abstract class AbstractChannelHandlerContext
implements ChannelHandlerContext,
ResourceLeakHint {
    volatile AbstractChannelHandlerContext next;
    volatile AbstractChannelHandlerContext prev;
    private final boolean inbound;
    private final boolean outbound;
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private boolean handlerRemoved;
    private boolean handlerAdded;
    final ChannelHandlerInvoker invoker;
    private ChannelFuture succeededFuture;
    volatile Runnable invokeChannelReadCompleteTask;
    volatile Runnable invokeReadTask;
    volatile Runnable invokeChannelWritableStateChangedTask;
    volatile Runnable invokeFlushTask;

    AbstractChannelHandlerContext(DefaultChannelPipeline pipeline, ChannelHandlerInvoker invoker, String name, boolean inbound, boolean outbound) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.pipeline = pipeline;
        this.name = name;
        this.invoker = invoker;
        this.inbound = inbound;
        this.outbound = outbound;
    }

    @Override
    public Channel channel() {
        return this.pipeline.channel();
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        return this.invoker().executor();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.channel().attr(key);
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> key) {
        return this.channel().hasAttr(key);
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelRegistered();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelUnregistered();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelActive();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelInactive();
        return this;
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
        AbstractChannelHandlerContext next = this.next;
        next.invokeExceptionCaught(cause);
        return this;
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object event) {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeUserEventTriggered(event);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object msg) {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelRead(this.pipeline.touch(msg, next));
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelReadComplete();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelWritabilityChanged();
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        return this.bind(localAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connect(remoteAddress, localAddress, this.newPromise());
    }

    @Override
    public ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public ChannelFuture deregister() {
        return this.deregister(this.newPromise());
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeBind(localAddress, promise);
        return promise;
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.connect(remoteAddress, null, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeConnect(remoteAddress, localAddress, promise);
        return promise;
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise promise) {
        if (!this.channel().metadata().hasDisconnect()) {
            return this.close(promise);
        }
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeDisconnect(promise);
        return promise;
    }

    @Override
    public ChannelFuture close(ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeClose(promise);
        return promise;
    }

    @Override
    public ChannelFuture deregister(ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeDeregister(promise);
        return promise;
    }

    @Override
    public ChannelHandlerContext read() {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeRead();
        return this;
    }

    @Override
    public ChannelFuture write(Object msg) {
        return this.write(msg, this.newPromise());
    }

    @Override
    public ChannelFuture write(Object msg, ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeWrite(this.pipeline.touch(msg, next), promise);
        return promise;
    }

    @Override
    public ChannelHandlerContext flush() {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeFlush();
        return this;
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeWriteAndFlush(this.pipeline.touch(msg, next), promise);
        return promise;
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg) {
        return this.writeAndFlush(msg, this.newPromise());
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this.channel(), this.executor());
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        ChannelFuture succeededFuture = this.succeededFuture;
        if (succeededFuture == null) {
            this.succeededFuture = succeededFuture = new SucceededChannelFuture(this.channel(), this.executor());
        }
        return succeededFuture;
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable cause) {
        return new FailedChannelFuture(this.channel(), this.executor(), cause);
    }

    private AbstractChannelHandlerContext findContextInbound() {
        AbstractChannelHandlerContext ctx = this;
        do {
            ctx = ctx.next;
        } while (!ctx.inbound);
        return ctx;
    }

    private AbstractChannelHandlerContext findContextOutbound() {
        AbstractChannelHandlerContext ctx = this;
        do {
            ctx = ctx.prev;
        } while (!ctx.outbound);
        return ctx;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }

    void setRemoved() {
        this.handlerRemoved = true;
    }

    @Override
    public boolean isRemoved() {
        return this.handlerRemoved;
    }

    final void invokeChannelRegistered() {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeChannelRegistered(this);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeChannelRegistered(AbstractChannelHandlerContext.this);
                }
            });
        }
    }

    final void invokeChannelUnregistered() {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeChannelUnregistered(this);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeChannelUnregistered(AbstractChannelHandlerContext.this);
                }
            });
        }
    }

    final void invokeChannelActive() {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeChannelActive(this);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeChannelActive(AbstractChannelHandlerContext.this);
                }
            });
        }
    }

    final void invokeChannelInactive() {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeChannelInactive(this);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeChannelInactive(AbstractChannelHandlerContext.this);
                }
            });
        }
    }

    final void invokeExceptionCaught(final Throwable cause) {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeExceptionCaught(this, cause);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeExceptionCaught(AbstractChannelHandlerContext.this, cause);
                }
            });
        }
    }

    final void invokeUserEventTriggered(final Object event) {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeUserEventTriggered(this, event);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeUserEventTriggered(AbstractChannelHandlerContext.this, event);
                }
            });
        }
    }

    final void invokeChannelRead(final Object msg) {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeChannelRead(this, msg);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeChannelRead(AbstractChannelHandlerContext.this, msg);
                }
            });
        }
    }

    final void invokeChannelReadComplete() {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeChannelReadComplete(this);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeChannelReadComplete(AbstractChannelHandlerContext.this);
                }
            });
        }
    }

    final void invokeChannelWritabilityChanged() {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeChannelWritabilityChanged(this);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeChannelWritabilityChanged(AbstractChannelHandlerContext.this);
                }
            });
        }
    }

    final void invokeBind(final SocketAddress localAddress, final ChannelPromise promise) {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeBind(this, localAddress, promise);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeBind(AbstractChannelHandlerContext.this, localAddress, promise);
                }
            });
        }
    }

    final void invokeConnect(final SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeConnect(this, remoteAddress, localAddress, promise);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeConnect(AbstractChannelHandlerContext.this, remoteAddress, localAddress, promise);
                }
            });
        }
    }

    final void invokeDisconnect(final ChannelPromise promise) {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeDisconnect(this, promise);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeDisconnect(AbstractChannelHandlerContext.this, promise);
                }
            });
        }
    }

    final void invokeClose(final ChannelPromise promise) {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeClose(this, promise);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeClose(AbstractChannelHandlerContext.this, promise);
                }
            });
        }
    }

    final void invokeDeregister(final ChannelPromise promise) {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeDeregister(this, promise);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeDeregister(AbstractChannelHandlerContext.this, promise);
                }
            });
        }
    }

    final void invokeRead() {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeRead(this);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeRead(AbstractChannelHandlerContext.this);
                }
            });
        }
    }

    final void invokeWrite(final Object msg, final ChannelPromise promise) {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeWrite(this, msg, promise);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeWrite(AbstractChannelHandlerContext.this, msg, promise);
                }
            });
        }
    }

    final void invokeFlush() {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeFlush(this);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeFlush(AbstractChannelHandlerContext.this);
                }
            });
        }
    }

    final void invokeWriteAndFlush(final Object msg, final ChannelPromise promise) {
        final ChannelHandlerInvoker invoker = this.invoker();
        if (this.handlerAdded) {
            invoker.invokeWrite(this, msg, promise);
            invoker.invokeFlush(this);
        } else {
            invoker.executor().execute(new OneTimeTask(){

                @Override
                public void run() {
                    assert (AbstractChannelHandlerContext.this.handlerAdded);
                    invoker.invokeWrite(AbstractChannelHandlerContext.this, msg, promise);
                    invoker.invokeFlush(AbstractChannelHandlerContext.this);
                }
            });
        }
    }

    @Override
    public ChannelHandlerInvoker invoker() {
        return this.invoker == null ? this.channel().unsafe().invoker() : this.invoker;
    }

    final void setHandlerAddedCalled() {
        this.handlerAdded = true;
    }

    @Override
    public String toHintString() {
        return '\'' + this.name + "' will handle the message from this point.";
    }

    public String toString() {
        return StringUtil.simpleClassName(ChannelHandlerContext.class) + '(' + this.name + ", " + this.channel() + ')';
    }
}

