/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.socksx.SocksMessage;
import io.netty.handler.codec.socksx.SocksProtocolVersion;
import io.netty.handler.codec.socksx.v4.Socks4Request;
import io.netty.handler.codec.socksx.v4.Socks4Response;

@ChannelHandler.Sharable
public final class Socks4MessageEncoder
extends MessageToByteEncoder<SocksMessage> {
    public static final Socks4MessageEncoder INSTANCE = new Socks4MessageEncoder();

    private Socks4MessageEncoder() {
    }

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && ((SocksMessage)msg).protocolVersion() == SocksProtocolVersion.SOCKS4a;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, SocksMessage msg, ByteBuf out) throws Exception {
        if (msg instanceof Socks4Response) {
            ((Socks4Response)msg).encodeAsByteBuf(out);
        } else if (msg instanceof Socks4Request) {
            ((Socks4Request)msg).encodeAsByteBuf(out);
        } else {
            throw new Error();
        }
    }
}

