/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttQoS;

final class MqttCodecUtil {
    private static final char[] TOPIC_WILDCARDS = new char[]{'#', '+'};
    private static final int MAX_CLIENT_ID_LENGTH = 23;

    static boolean isValidPublishTopicName(String topicName) {
        for (char c : TOPIC_WILDCARDS) {
            if (topicName.indexOf(c) < 0) continue;
            return false;
        }
        return true;
    }

    static boolean isValidMessageId(int messageId) {
        return messageId != 0;
    }

    static boolean isValidClientId(String clientId) {
        return clientId != null && clientId.length() <= 23;
    }

    static MqttFixedHeader validateFixedHeader(MqttFixedHeader mqttFixedHeader) {
        switch (mqttFixedHeader.messageType()) {
            case PUBREL: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                if (mqttFixedHeader.qosLevel() == MqttQoS.AT_LEAST_ONCE) break;
                throw new DecoderException(mqttFixedHeader.messageType().name() + " message must have QoS 1");
            }
        }
        return mqttFixedHeader;
    }

    static MqttFixedHeader resetUnusedFields(MqttFixedHeader mqttFixedHeader) {
        switch (mqttFixedHeader.messageType()) {
            case CONNECT: 
            case CONNACK: 
            case PUBACK: 
            case PUBREC: 
            case PUBCOMP: 
            case SUBACK: 
            case UNSUBACK: 
            case PINGREQ: 
            case PINGRESP: 
            case DISCONNECT: {
                if (mqttFixedHeader.isDup() || mqttFixedHeader.qosLevel() != MqttQoS.AT_MOST_ONCE || mqttFixedHeader.isRetain()) {
                    return new MqttFixedHeader(mqttFixedHeader.messageType(), false, MqttQoS.AT_MOST_ONCE, false, mqttFixedHeader.remainingLength());
                }
                return mqttFixedHeader;
            }
            case PUBREL: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                if (mqttFixedHeader.isRetain()) {
                    return new MqttFixedHeader(mqttFixedHeader.messageType(), mqttFixedHeader.isDup(), mqttFixedHeader.qosLevel(), false, mqttFixedHeader.remainingLength());
                }
                return mqttFixedHeader;
            }
        }
        return mqttFixedHeader;
    }

    private MqttCodecUtil() {
    }
}

