/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.stomp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.AsciiString;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.stomp.DefaultLastStompContentSubframe;
import io.netty.handler.codec.stomp.DefaultStompContentSubframe;
import io.netty.handler.codec.stomp.DefaultStompHeadersSubframe;
import io.netty.handler.codec.stomp.LastStompContentSubframe;
import io.netty.handler.codec.stomp.StompCommand;
import io.netty.handler.codec.stomp.StompHeaders;
import io.netty.util.internal.AppendableCharSequence;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Locale;

public class StompSubframeDecoder
extends ReplayingDecoder<State> {
    private static final int DEFAULT_CHUNK_SIZE = 8132;
    private static final int DEFAULT_MAX_LINE_LENGTH = 1024;
    private final int maxLineLength;
    private final int maxChunkSize;
    private int alreadyReadChunkSize;
    private LastStompContentSubframe lastContent;
    private long contentLength;

    public StompSubframeDecoder() {
        this(1024, 8132);
    }

    public StompSubframeDecoder(int maxLineLength, int maxChunkSize) {
        super(State.SKIP_CONTROL_CHARACTERS);
        if (maxLineLength <= 0) {
            throw new IllegalArgumentException("maxLineLength must be a positive integer: " + maxLineLength);
        }
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("maxChunkSize must be a positive integer: " + maxChunkSize);
        }
        this.maxChunkSize = maxChunkSize;
        this.maxLineLength = maxLineLength;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case SKIP_CONTROL_CHARACTERS: {
                StompSubframeDecoder.skipControlCharacters(in);
                this.checkpoint(State.READ_HEADERS);
            }
            case READ_HEADERS: {
                StompCommand command = StompCommand.UNKNOWN;
                DecoderResultProvider frame = null;
                try {
                    command = this.readCommand(in);
                    frame = new DefaultStompHeadersSubframe(command);
                    this.checkpoint(this.readHeaders(in, frame.headers()));
                    out.add(frame);
                    break;
                }
                catch (Exception e) {
                    if (frame == null) {
                        frame = new DefaultStompHeadersSubframe(command);
                    }
                    frame.setDecoderResult(DecoderResult.failure(e));
                    out.add(frame);
                    this.checkpoint(State.BAD_FRAME);
                    return;
                }
            }
            case BAD_FRAME: {
                in.skipBytes(this.actualReadableBytes());
                return;
            }
        }
        try {
            switch ((State)((Object)this.state())) {
                case READ_CONTENT: {
                    int remainingLength;
                    int toRead = in.readableBytes();
                    if (toRead == 0) {
                        return;
                    }
                    if (toRead > this.maxChunkSize) {
                        toRead = this.maxChunkSize;
                    }
                    if (toRead > (remainingLength = (int)(this.contentLength - (long)this.alreadyReadChunkSize))) {
                        toRead = remainingLength;
                    }
                    ByteBuf chunkBuffer = ByteBufUtil.readBytes(ctx.alloc(), in, toRead);
                    if ((long)(this.alreadyReadChunkSize += toRead) >= this.contentLength) {
                        this.lastContent = new DefaultLastStompContentSubframe(chunkBuffer);
                        this.checkpoint(State.FINALIZE_FRAME_READ);
                    } else {
                        DefaultStompContentSubframe chunk = new DefaultStompContentSubframe(chunkBuffer);
                        out.add(chunk);
                    }
                    if ((long)this.alreadyReadChunkSize < this.contentLength) {
                        return;
                    }
                }
                case FINALIZE_FRAME_READ: {
                    StompSubframeDecoder.skipNullCharacter(in);
                    if (this.lastContent == null) {
                        this.lastContent = LastStompContentSubframe.EMPTY_LAST_CONTENT;
                    }
                    out.add(this.lastContent);
                    this.resetDecoder();
                }
            }
        }
        catch (Exception e) {
            DefaultLastStompContentSubframe errorContent = new DefaultLastStompContentSubframe(Unpooled.EMPTY_BUFFER);
            errorContent.setDecoderResult(DecoderResult.failure(e));
            out.add(errorContent);
            this.checkpoint(State.BAD_FRAME);
        }
    }

    private StompCommand readCommand(ByteBuf in) {
        String commandStr = StompSubframeDecoder.readLine(in, this.maxLineLength);
        StompCommand command = null;
        try {
            command = StompCommand.valueOf(commandStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (command == null) {
            commandStr = commandStr.toUpperCase(Locale.US);
            try {
                command = StompCommand.valueOf(commandStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (command == null) {
            throw new DecoderException("failed to read command from channel");
        }
        return command;
    }

    private State readHeaders(ByteBuf buffer, StompHeaders headers) {
        String line;
        while (!(line = StompSubframeDecoder.readLine(buffer, this.maxLineLength)).isEmpty()) {
            String[] split = StringUtil.split(line, ':');
            if (split.length != 2) continue;
            headers.add((CharSequence)split[0], (Object)split[1]);
        }
        long contentLength = -1L;
        if (headers.contains(StompHeaders.CONTENT_LENGTH)) {
            contentLength = StompSubframeDecoder.getContentLength(headers, 0L);
        } else {
            int globalIndex = ByteBufUtil.indexOf(buffer, buffer.readerIndex(), buffer.writerIndex(), (byte)0);
            if (globalIndex != -1) {
                contentLength = globalIndex - buffer.readerIndex();
            }
        }
        if (contentLength > 0L) {
            this.contentLength = contentLength;
            return State.READ_CONTENT;
        }
        return State.FINALIZE_FRAME_READ;
    }

    private static long getContentLength(StompHeaders headers, long defaultValue) {
        String contentLength = headers.get(StompHeaders.CONTENT_LENGTH);
        if (contentLength != null) {
            try {
                if (contentLength instanceof AsciiString) {
                    return ((AsciiString)((Object)contentLength)).parseLong();
                }
                return Long.parseLong(contentLength.toString());
            }
            catch (NumberFormatException ignored) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static void skipNullCharacter(ByteBuf buffer) {
        byte b = buffer.readByte();
        if (b != 0) {
            throw new IllegalStateException("unexpected byte in buffer " + b + " while expecting NULL byte");
        }
    }

    private static void skipControlCharacters(ByteBuf buffer) {
        byte b;
        while ((b = buffer.readByte()) == 13 || b == 10) {
        }
        buffer.readerIndex(buffer.readerIndex() - 1);
    }

    private static String readLine(ByteBuf buffer, int maxLineLength) {
        AppendableCharSequence buf = new AppendableCharSequence(128);
        int lineLength = 0;
        while (true) {
            byte nextByte;
            if ((nextByte = buffer.readByte()) == 13) {
                nextByte = buffer.readByte();
                if (nextByte != 10) continue;
                return buf.toString();
            }
            if (nextByte == 10) {
                return buf.toString();
            }
            if (lineLength >= maxLineLength) {
                throw new TooLongFrameException("An STOMP line is larger than " + maxLineLength + " bytes.");
            }
            ++lineLength;
            buf.append((char)nextByte);
        }
    }

    private void resetDecoder() {
        this.checkpoint(State.SKIP_CONTROL_CHARACTERS);
        this.contentLength = 0L;
        this.alreadyReadChunkSize = 0;
        this.lastContent = null;
    }

    static enum State {
        SKIP_CONTROL_CHARACTERS,
        READ_HEADERS,
        READ_CONTENT,
        FINALIZE_FRAME_READ,
        BAD_FRAME,
        INVALID_CHUNK;

    }
}

