/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.util.Recycler;
import java.util.Arrays;

final class EpollChannelOutboundBuffer
extends ChannelOutboundBuffer {
    private AddressEntry[] addresses = new AddressEntry[32];
    private int addressCount;
    private long addressSize;
    private static final Recycler<EpollChannelOutboundBuffer> RECYCLER = new Recycler<EpollChannelOutboundBuffer>(){

        @Override
        protected EpollChannelOutboundBuffer newObject(Recycler.Handle<EpollChannelOutboundBuffer> handle) {
            return new EpollChannelOutboundBuffer(handle);
        }
    };

    static EpollChannelOutboundBuffer newInstance(EpollSocketChannel channel) {
        EpollChannelOutboundBuffer buffer = RECYCLER.get();
        buffer.channel = channel;
        return buffer;
    }

    private EpollChannelOutboundBuffer(Recycler.Handle<? extends ChannelOutboundBuffer> handle) {
        super(handle);
    }

    @Override
    protected Object beforeAdd(Object msg) {
        ByteBuf buf;
        if (msg instanceof ByteBuf && !(buf = (ByteBuf)msg).hasMemoryAddress()) {
            return this.copyToDirectByteBuf(buf);
        }
        return msg;
    }

    AddressEntry[] memoryAddresses() {
        Object m;
        long addressSize = 0L;
        int addressCount = 0;
        ChannelOutboundBuffer.Entry[] buffer = this.entries();
        int mask = buffer.length - 1;
        AddressEntry[] addresses = this.addresses;
        int unflushed = this.unflushed();
        int flushed = this.flushed();
        while (flushed != unflushed && (m = buffer[flushed].msg()) != null) {
            if (!(m instanceof ByteBuf)) {
                this.addressCount = 0;
                this.addressSize = 0L;
                return null;
            }
            AddressEntry entry = (AddressEntry)buffer[flushed];
            if (!entry.isCancelled()) {
                ByteBuf buf = (ByteBuf)m;
                int readerIndex = buf.readerIndex();
                int readableBytes = buf.writerIndex() - readerIndex;
                if (readableBytes > 0) {
                    addressSize += (long)readableBytes;
                    int neededSpace = addressCount + 1;
                    if (neededSpace > addresses.length) {
                        addresses = EpollChannelOutboundBuffer.expandAddressesArray(addresses, neededSpace, addressCount);
                        this.addresses = addresses;
                    }
                    entry.memoryAddress = buf.memoryAddress();
                    entry.readerIndex = buf.readerIndex();
                    entry.writerIndex = buf.writerIndex();
                    addresses[addressCount++] = entry;
                }
            }
            flushed = flushed + 1 & mask;
        }
        this.addressCount = addressCount;
        this.addressSize = addressSize;
        return addresses;
    }

    private static AddressEntry[] expandAddressesArray(AddressEntry[] array, int neededSpace, int size) {
        int newCapacity = array.length;
        do {
            if ((newCapacity <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (neededSpace > newCapacity);
        AddressEntry[] newArray = new AddressEntry[newCapacity];
        System.arraycopy(array, 0, newArray, 0, size);
        return newArray;
    }

    int addressCount() {
        return this.addressCount;
    }

    long addressSize() {
        return this.addressSize;
    }

    @Override
    public void recycle() {
        if (this.addresses.length > 32) {
            this.addresses = new AddressEntry[32];
        } else {
            Arrays.fill(this.addresses, null);
        }
        super.recycle();
    }

    @Override
    protected AddressEntry newEntry() {
        return new AddressEntry();
    }

    static final class AddressEntry
    extends ChannelOutboundBuffer.Entry {
        long memoryAddress;
        int readerIndex;
        int writerIndex;

        AddressEntry() {
        }

        @Override
        public void clear() {
            this.memoryAddress = -1L;
            this.readerIndex = 0;
            this.writerIndex = 0;
            super.clear();
        }

        @Override
        public int cancel() {
            this.memoryAddress = -1L;
            this.readerIndex = 0;
            this.writerIndex = 0;
            return super.cancel();
        }
    }
}

