/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.buffer.Buf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandler;
import io.netty.channel.ChannelInboundMessageHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelStateHandlerAdapter;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.channel.embedded.EmbeddedEventLoop;
import io.netty.channel.embedded.EmbeddedSocketAddress;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;

public abstract class AbstractEmbeddedChannel<O>
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractEmbeddedChannel.class);
    private final EmbeddedEventLoop loop = new EmbeddedEventLoop();
    private final ChannelConfig config = new DefaultChannelConfig(this);
    private final SocketAddress localAddress = new EmbeddedSocketAddress();
    private final SocketAddress remoteAddress = new EmbeddedSocketAddress();
    private final MessageBuf<Object> lastInboundMessageBuffer = Unpooled.messageBuffer().retain(2);
    private final ByteBuf lastInboundByteBuffer = Unpooled.buffer().retain(2);
    protected final Object lastOutboundBuffer;
    private Throwable lastException;
    private int state;

    AbstractEmbeddedChannel(Object lastOutboundBuffer, ChannelHandler ... handlers) {
        super(null, null);
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        this.lastOutboundBuffer = lastOutboundBuffer;
        int nHandlers = 0;
        boolean hasBuffer = false;
        ChannelPipeline p = this.pipeline();
        for (ChannelHandler h : handlers) {
            if (h == null) break;
            ++nHandlers;
            ChannelHandlerContext ctx = p.addLast(h).context(h);
            if (!ctx.hasInboundByteBuffer() && !ctx.hasOutboundByteBuffer() && !ctx.hasInboundMessageBuffer() && !ctx.hasOutboundMessageBuffer()) continue;
            hasBuffer = true;
        }
        if (nHandlers == 0) {
            throw new IllegalArgumentException("handlers is empty.");
        }
        if (!hasBuffer) {
            throw new IllegalArgumentException("handlers does not provide any buffers.");
        }
        p.addLast(new LastInboundMessageHandler(), new LastInboundByteHandler());
        this.loop.register(this);
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state < 2;
    }

    @Override
    public boolean isActive() {
        return this.state == 1;
    }

    public MessageBuf<Object> lastInboundMessageBuffer() {
        return this.lastInboundMessageBuffer;
    }

    public ByteBuf lastInboundByteBuffer() {
        return this.lastInboundByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readInbound() {
        if (this.lastInboundByteBuffer.isReadable()) {
            try {
                ByteBuf byteBuf = this.lastInboundByteBuffer.readBytes(this.lastInboundByteBuffer.readableBytes());
                return byteBuf;
            }
            finally {
                this.lastInboundByteBuffer.clear();
            }
        }
        return this.lastInboundMessageBuffer.poll();
    }

    public void runPendingTasks() {
        try {
            this.loop.runTasks();
        }
        catch (Exception e) {
            this.recordException(e);
        }
    }

    private void recordException(Throwable cause) {
        if (this.lastException == null) {
            this.lastException = cause;
        } else {
            logger.warn("More than one exception was raised. Will report only the first one and log others.", cause);
        }
    }

    public void checkException() {
        Throwable t = this.lastException;
        if (t == null) {
            return;
        }
        this.lastException = null;
        PlatformDependent.throwException(t);
    }

    protected final void ensureOpen() {
        if (!this.isOpen()) {
            this.recordException(new ClosedChannelException());
            this.checkException();
        }
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof EmbeddedEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.isActive() ? this.localAddress : null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.isActive() ? this.remoteAddress : null;
    }

    @Override
    protected Runnable doRegister() throws Exception {
        this.state = 1;
        return null;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        this.state = 2;
    }

    @Override
    protected Runnable doDeregister() throws Exception {
        return null;
    }

    @Override
    protected void doBeginRead() throws Exception {
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultUnsafe();
    }

    @Override
    protected boolean isFlushPending() {
        return false;
    }

    public abstract O readOutbound();

    public abstract Buf inboundBuffer();

    public abstract Buf lastOutboundBuffer();

    public boolean finish() {
        this.close();
        this.runPendingTasks();
        this.checkException();
        return this.lastInboundByteBuffer().isReadable() || !this.lastInboundMessageBuffer().isEmpty() || this.hasReadableOutboundBuffer();
    }

    public boolean writeInbound(O data) {
        this.ensureOpen();
        this.writeInbound0(data);
        this.pipeline().fireInboundBufferUpdated();
        this.runPendingTasks();
        this.checkException();
        return this.lastInboundByteBuffer().isReadable() || !this.lastInboundMessageBuffer().isEmpty();
    }

    public boolean writeOutbound(Object data) {
        this.ensureOpen();
        ChannelFuture future = this.write(data);
        assert (future.isDone());
        if (future.cause() != null) {
            this.recordException(future.cause());
        }
        this.runPendingTasks();
        this.checkException();
        return this.hasReadableOutboundBuffer();
    }

    protected abstract boolean hasReadableOutboundBuffer();

    protected abstract void writeInbound0(O var1);

    private final class LastInboundByteHandler
    extends ChannelStateHandlerAdapter
    implements ChannelInboundByteHandler {
        private LastInboundByteHandler() {
        }

        @Override
        public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
            return AbstractEmbeddedChannel.this.lastInboundByteBuffer;
        }

        @Override
        public void discardInboundReadBytes(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        }
    }

    private final class LastInboundMessageHandler
    extends ChannelStateHandlerAdapter
    implements ChannelInboundMessageHandler<Object> {
        private LastInboundMessageHandler() {
        }

        @Override
        public MessageBuf<Object> newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
            return AbstractEmbeddedChannel.this.lastInboundMessageBuffer;
        }

        @Override
        public void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            AbstractEmbeddedChannel.this.recordException(cause);
        }
    }

    private class DefaultUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DefaultUnsafe() {
            super(AbstractEmbeddedChannel.this);
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            promise.setSuccess();
        }
    }
}

