/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.oio.OioEventLoop;
import java.net.ConnectException;
import java.net.SocketAddress;

public abstract class AbstractOioChannel
extends AbstractChannel {
    protected static final int SO_TIMEOUT = 1000;
    private boolean readInProgress;
    private final Runnable readTask = new Runnable(){

        @Override
        public void run() {
            AbstractOioChannel.this.readInProgress = false;
            AbstractOioChannel.this.doRead();
        }
    };

    protected AbstractOioChannel(Channel parent, Integer id) {
        super(parent, id);
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultOioUnsafe();
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof OioEventLoop;
    }

    @Override
    protected boolean isFlushPending() {
        return false;
    }

    protected abstract void doConnect(SocketAddress var1, SocketAddress var2) throws Exception;

    @Override
    protected void doBeginRead() throws Exception {
        if (this.readInProgress) {
            return;
        }
        this.readInProgress = true;
        this.eventLoop().execute(this.readTask);
    }

    protected abstract void doRead();

    private final class DefaultOioUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DefaultOioUnsafe() {
            super(AbstractOioChannel.this);
        }

        @Override
        public void connect(final SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
            if (AbstractOioChannel.this.eventLoop().inEventLoop()) {
                if (!this.ensureOpen(promise)) {
                    return;
                }
                try {
                    boolean wasActive = AbstractOioChannel.this.isActive();
                    AbstractOioChannel.this.doConnect(remoteAddress, localAddress);
                    promise.setSuccess();
                    if (!wasActive && AbstractOioChannel.this.isActive()) {
                        AbstractOioChannel.this.pipeline().fireChannelActive();
                    }
                }
                catch (Throwable t2) {
                    ConnectException t2;
                    if (t2 instanceof ConnectException) {
                        ConnectException newT = new ConnectException(t2.getMessage() + ": " + remoteAddress);
                        newT.setStackTrace(t2.getStackTrace());
                        t2 = newT;
                    }
                    promise.setFailure(t2);
                    this.closeIfClosed();
                }
            } else {
                AbstractOioChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultOioUnsafe.this.connect(remoteAddress, localAddress, promise);
                    }
                });
            }
        }
    }
}

