/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.internal.InternalLogger;
import io.netty.util.internal.InternalLoggerFactory;
import java.util.regex.Pattern;

public class WebSocketServerHandshaker00
extends WebSocketServerHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker00.class);
    private static final Pattern BEGINNING_DIGIT = Pattern.compile("[^0-9]");
    private static final Pattern BEGINNING_SPACE = Pattern.compile("[^ ]");

    public WebSocketServerHandshaker00(String webSocketURL, String subprotocols, int maxFramePayloadLength) {
        super(WebSocketVersion.V00, webSocketURL, subprotocols, maxFramePayloadLength);
    }

    @Override
    public ChannelFuture handshake(Channel channel, FullHttpRequest req, HttpHeaders headers, ChannelPromise promise) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Channel %s WS Version 00 server handshake", channel.id()));
        }
        if (!"Upgrade".equalsIgnoreCase(req.headers().get("Connection")) || !"WebSocket".equalsIgnoreCase(req.headers().get("Upgrade"))) {
            throw new WebSocketHandshakeException("not a WebSocket handshake request: missing upgrade");
        }
        boolean isHixie76 = req.headers().contains("Sec-WebSocket-Key1") && req.headers().contains("Sec-WebSocket-Key2");
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, isHixie76 ? "WebSocket Protocol Handshake" : "Web Socket Protocol Handshake"));
        if (headers != null) {
            res.headers().add(headers);
        }
        res.headers().add("Upgrade", "WebSocket");
        res.headers().add("Connection", "Upgrade");
        if (isHixie76) {
            res.headers().add("Sec-WebSocket-Origin", req.headers().get("Origin"));
            res.headers().add("Sec-WebSocket-Location", this.uri());
            String subprotocols = req.headers().get("Sec-WebSocket-Protocol");
            if (subprotocols != null) {
                String selectedSubprotocol = this.selectSubprotocol(subprotocols);
                if (selectedSubprotocol == null) {
                    throw new WebSocketHandshakeException("Requested subprotocol(s) not supported: " + subprotocols);
                }
                res.headers().add("Sec-WebSocket-Protocol", selectedSubprotocol);
                this.setSelectedSubprotocol(selectedSubprotocol);
            }
            String key1 = req.headers().get("Sec-WebSocket-Key1");
            String key2 = req.headers().get("Sec-WebSocket-Key2");
            int a = (int)(Long.parseLong(BEGINNING_DIGIT.matcher(key1).replaceAll("")) / (long)BEGINNING_SPACE.matcher(key1).replaceAll("").length());
            int b = (int)(Long.parseLong(BEGINNING_DIGIT.matcher(key2).replaceAll("")) / (long)BEGINNING_SPACE.matcher(key2).replaceAll("").length());
            long c = req.data().readLong();
            ByteBuf input = Unpooled.buffer(16);
            input.writeInt(a);
            input.writeInt(b);
            input.writeLong(c);
            res.data().writeBytes(WebSocketUtil.md5(input.array()));
        } else {
            res.headers().add("WebSocket-Origin", req.headers().get("Origin"));
            res.headers().add("WebSocket-Location", this.uri());
            String protocol = req.headers().get("WebSocket-Protocol");
            if (protocol != null) {
                res.headers().add("WebSocket-Protocol", this.selectSubprotocol(protocol));
            }
        }
        channel.write(res, promise);
        promise.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                ChannelPipeline p = future.channel().pipeline();
                if (p.get(HttpObjectAggregator.class) != null) {
                    p.remove(HttpObjectAggregator.class);
                }
                p.replaceAndForward(HttpRequestDecoder.class, "wsdecoder", (ChannelHandler)new WebSocket00FrameDecoder(WebSocketServerHandshaker00.this.maxFramePayloadLength()));
                p.replace(HttpResponseEncoder.class, "wsencoder", (ChannelHandler)new WebSocket00FrameEncoder());
            }
        });
        return promise;
    }

    @Override
    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame, ChannelPromise promise) {
        return channel.write(frame, promise);
    }
}

