/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.BufType;
import io.netty.buffer.IllegalBufferAccessException;
import io.netty.buffer.MessageBuf;
import java.util.AbstractQueue;
import java.util.Collection;

public abstract class AbstractMessageBuf<T>
extends AbstractQueue<T>
implements MessageBuf<T> {
    private final int maxCapacity;
    private int refCnt = 1;

    protected AbstractMessageBuf(int maxCapacity) {
        if (maxCapacity < 0) {
            throw new IllegalArgumentException("maxCapacity: " + maxCapacity + " (expected: >= 0)");
        }
        this.maxCapacity = maxCapacity;
    }

    @Override
    public final BufType type() {
        return BufType.MESSAGE;
    }

    @Override
    public final int refCnt() {
        return this.refCnt;
    }

    @Override
    public final MessageBuf<T> retain() {
        int refCnt = this.refCnt;
        if (refCnt <= 0) {
            throw new IllegalBufferAccessException();
        }
        if (refCnt == Integer.MAX_VALUE) {
            throw new IllegalBufferAccessException("refCnt overflow");
        }
        this.refCnt = refCnt + 1;
        return this;
    }

    @Override
    public final MessageBuf<T> retain(int increment) {
        if (increment <= 0) {
            throw new IllegalArgumentException("increment: " + increment + " (expected: > 0)");
        }
        int refCnt = this.refCnt;
        if (refCnt <= 0) {
            throw new IllegalBufferAccessException();
        }
        if (refCnt > Integer.MAX_VALUE - increment) {
            throw new IllegalBufferAccessException("refCnt overflow");
        }
        this.refCnt = refCnt + increment;
        return this;
    }

    @Override
    public final boolean release() {
        int refCnt = this.refCnt;
        if (refCnt <= 0) {
            throw new IllegalBufferAccessException();
        }
        this.refCnt = refCnt--;
        if (refCnt == 0) {
            this.deallocate();
            return true;
        }
        return false;
    }

    @Override
    public final boolean release(int decrement) {
        if (decrement <= 0) {
            throw new IllegalArgumentException("decrement: " + decrement + " (expected: > 0)");
        }
        int refCnt = this.refCnt;
        if (refCnt < decrement) {
            throw new IllegalBufferAccessException();
        }
        this.refCnt = refCnt -= decrement;
        if (refCnt == 0) {
            this.deallocate();
            return true;
        }
        return false;
    }

    protected abstract void deallocate();

    @Override
    public final int maxCapacity() {
        return this.maxCapacity;
    }

    @Override
    public final boolean isReadable() {
        return !this.isEmpty();
    }

    @Override
    public final boolean isReadable(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size + " (expected: >= 0)");
        }
        return this.size() >= size;
    }

    @Override
    public final boolean isWritable() {
        return this.size() < this.maxCapacity;
    }

    @Override
    public final boolean isWritable(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size + " (expected: >= 0)");
        }
        return this.size() <= this.maxCapacity - size;
    }

    protected final void ensureAccessible() {
        if (this.refCnt <= 0) {
            throw new IllegalBufferAccessException();
        }
    }

    @Override
    public final boolean add(T t) {
        return super.add(t);
    }

    @Override
    public final T remove() {
        return (T)super.remove();
    }

    @Override
    public final T element() {
        return (T)super.element();
    }

    @Override
    public boolean unfoldAndAdd(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Object[]) {
            Object m;
            int i;
            Object[] a = (Object[])o;
            for (i = 0; i < a.length && (m = a[i]) != null; ++i) {
                this.add((T)m);
            }
            return i != 0;
        }
        return this.add((T)o);
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        Object o;
        this.ensureAccessible();
        int cnt = 0;
        while ((o = this.poll()) != null) {
            c.add(o);
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        Object o;
        int cnt;
        this.ensureAccessible();
        for (cnt = 0; cnt < maxElements && (o = this.poll()) != null; ++cnt) {
            c.add(o);
        }
        return cnt;
    }

    @Override
    public String toString() {
        if (this.refCnt <= 0) {
            return this.getClass().getSimpleName() + "(freed)";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(size: ");
        buf.append(this.size());
        if (this.maxCapacity != Integer.MAX_VALUE) {
            buf.append('/');
            buf.append(this.maxCapacity);
        }
        buf.append(')');
        return buf.toString();
    }
}

