/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.tweak.BaseStatementCustomizer;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface TransactionIsolation {
    public TransactionIsolationLevel value() default TransactionIsolationLevel.INVALID_LEVEL;

    public static class MyCustomizer
    implements SqlStatementCustomizer {
        private final TransactionIsolationLevel level;

        public MyCustomizer(TransactionIsolationLevel level) {
            this.level = level;
        }

        @Override
        public void apply(SQLStatement q) throws SQLException {
            final int initial_level = q.getContext().getConnection().getTransactionIsolation();
            q.addStatementCustomizer(new BaseStatementCustomizer(){

                @Override
                public void beforeExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
                    this.setTxnIsolation(ctx, MyCustomizer.this.level.intValue());
                }

                @Override
                public void afterExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
                    this.setTxnIsolation(ctx, initial_level);
                }

                private void setTxnIsolation(StatementContext ctx, int level) throws SQLException {
                    Connection c = ctx.getConnection();
                    if (c.getTransactionIsolation() != level) {
                        c.setTransactionIsolation(level);
                    }
                }
            });
        }
    }

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            return new MyCustomizer(((TransactionIsolation)annotation).value());
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            return new MyCustomizer(((TransactionIsolation)annotation).value());
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            assert (arg instanceof TransactionIsolationLevel);
            return new MyCustomizer((TransactionIsolationLevel)((Object)arg));
        }
    }
}

