/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.protobuf;

import com.google.protobuf.CodedOutputStream;
import java.io.OutputStream;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.ByteBufOutputStream;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.handler.codec.MessageToByteEncoder;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends MessageToByteEncoder<ByteBuf> {
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int bodyLen = msg.readableBytes();
        int headerLen = CodedOutputStream.computeRawVarint32Size((int)bodyLen);
        out.ensureWritable(headerLen + bodyLen);
        CodedOutputStream headerOut = CodedOutputStream.newInstance((OutputStream)new ByteBufOutputStream(out), (int)headerLen);
        headerOut.writeRawVarint32(bodyLen);
        headerOut.flush();
        out.writeBytes(msg, msg.readerIndex(), bodyLen);
    }
}

