/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.storage.hdfs;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.data.SearchableVersionedDataFinder;
import org.apache.hive.druid.io.druid.java.util.common.RetryUtils;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPuller;

public class HdfsFileTimestampVersionFinder
extends HdfsDataSegmentPuller
implements SearchableVersionedDataFinder<URI> {
    @Inject
    public HdfsFileTimestampVersionFinder(Configuration config) {
        super(config);
    }

    private URI mostRecentInDir(Path dir, final Pattern pattern) throws IOException {
        PathFilter filter = new PathFilter(){

            public boolean accept(Path path) {
                return pattern == null || pattern.matcher(path.getName()).matches();
            }
        };
        long modifiedTime = Long.MIN_VALUE;
        URI mostRecentURI = null;
        FileSystem fs = dir.getFileSystem(this.config);
        for (FileStatus status : fs.listStatus(dir, filter)) {
            long thisModifiedTime;
            if (!status.isFile() || (thisModifiedTime = status.getModificationTime()) < modifiedTime) continue;
            modifiedTime = thisModifiedTime;
            mostRecentURI = status.getPath().toUri();
        }
        return mostRecentURI;
    }

    @Override
    public URI getLatestVersion(URI uri, final @Nullable Pattern pattern) {
        final Path path = new Path(uri);
        try {
            return RetryUtils.retry(new Callable<URI>(){

                @Override
                public URI call() throws Exception {
                    FileSystem fs = path.getFileSystem(HdfsFileTimestampVersionFinder.this.config);
                    if (!fs.exists(path)) {
                        return null;
                    }
                    return HdfsFileTimestampVersionFinder.this.mostRecentInDir(fs.isDirectory(path) ? path : path.getParent(), pattern);
                }
            }, this.shouldRetryPredicate(), 3);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public Class<URI> getDataDescriptorClass() {
        return URI.class;
    }
}

