/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.router;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.FluentIterable;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.client.selector.Server;
import org.apache.hive.druid.io.druid.curator.discovery.ServerDiscoverySelector;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerHostSelector;

public class QueryHostFinder {
    private static EmittingLogger log = new EmittingLogger(QueryHostFinder.class);
    private final TieredBrokerHostSelector hostSelector;
    private final ConcurrentHashMap<String, Server> serverBackup = new ConcurrentHashMap();

    @Inject
    public QueryHostFinder(TieredBrokerHostSelector hostSelector) {
        this.hostSelector = hostSelector;
    }

    public <T> Server findServer(Query<T> query) {
        Pair<String, ServerDiscoverySelector> selected = this.hostSelector.select(query);
        return this.findServerInner(selected);
    }

    public Server findDefaultServer() {
        Pair<String, ServerDiscoverySelector> selected = this.hostSelector.getDefaultLookup();
        return this.findServerInner(selected);
    }

    public Collection<String> getAllHosts() {
        return FluentIterable.from(this.hostSelector.getAllBrokers().values()).transformAndConcat(new Function<ServerDiscoverySelector, Iterable<Server>>(){

            @Override
            public Iterable<Server> apply(ServerDiscoverySelector input) {
                return input.getAll();
            }
        }).transform(new Function<Server, String>(){

            @Override
            public String apply(Server input) {
                return input.getHost();
            }
        }).toList();
    }

    public <T> String getHost(Query<T> query) {
        Server server = this.findServer(query);
        if (server == null) {
            log.makeAlert("Catastrophic failure! No servers found at all! Failing request!", new Object[0]).emit();
            throw new ISE("No server found for query[%s]", query);
        }
        String host = server.getHost();
        log.debug("Selected [%s]", host);
        return host;
    }

    public String getDefaultHost() {
        Server server = this.findDefaultServer();
        if (server == null) {
            log.makeAlert("Catastrophic failure! No servers found at all! Failing request!", new Object[0]).emit();
            throw new ISE("No default server found!", new Object[0]);
        }
        return server.getHost();
    }

    private Server findServerInner(Pair<String, ServerDiscoverySelector> selected) {
        Server server;
        if (selected == null) {
            log.error("Danger, Will Robinson! Unable to find any brokers!", new Object[0]);
        }
        String serviceName = selected == null ? this.hostSelector.getDefaultServiceName() : (String)selected.lhs;
        ServerDiscoverySelector selector = selected == null ? null : (ServerDiscoverySelector)selected.rhs;
        Server server2 = server = selector == null ? null : selector.pick();
        if (server == null) {
            log.error("WTF?! No server found for serviceName[%s]. Using backup", serviceName);
            server = this.serverBackup.get(serviceName);
            if (server == null) {
                log.error("WTF?! No backup found for serviceName[%s]. Using default[%s]", serviceName, this.hostSelector.getDefaultServiceName());
                server = this.serverBackup.get(this.hostSelector.getDefaultServiceName());
            }
        }
        if (server != null) {
            this.serverBackup.put(serviceName, server);
        }
        return server;
    }
}

