/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.log;

import java.io.IOException;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.emitter.core.Event;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEventBuilder;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.server.QueryStats;
import org.apache.hive.druid.io.druid.server.RequestLogLine;
import org.apache.hive.druid.io.druid.server.log.RequestLogger;
import org.joda.time.DateTime;

public class EmittingRequestLogger
implements RequestLogger {
    final ServiceEmitter emitter;
    final String feed;

    public EmittingRequestLogger(ServiceEmitter emitter, String feed) {
        this.emitter = emitter;
        this.feed = feed;
    }

    @Override
    public void log(RequestLogLine requestLogLine) throws IOException {
        this.emitter.emit(new RequestLogEventBuilder(this.feed, requestLogLine));
    }

    private static class RequestLogEventBuilder
    extends ServiceEventBuilder<Event> {
        private final String feed;
        private final RequestLogLine requestLogLine;

        public RequestLogEventBuilder(String feed, RequestLogLine requestLogLine) {
            this.feed = feed;
            this.requestLogLine = requestLogLine;
        }

        @Override
        public Event build(ImmutableMap<String, String> serviceDimensions) {
            return new RequestLogEvent(serviceDimensions, this.feed, this.requestLogLine);
        }
    }

    private static class RequestLogEvent
    implements Event {
        final ImmutableMap<String, String> serviceDimensions;
        final String feed;
        final RequestLogLine request;

        RequestLogEvent(ImmutableMap<String, String> serviceDimensions, String feed, RequestLogLine request) {
            this.serviceDimensions = serviceDimensions;
            this.request = request;
            this.feed = feed;
        }

        @Override
        @JsonValue(value=false)
        public Map<String, Object> toMap() {
            return ImmutableMap.of();
        }

        @Override
        @JsonProperty(value="feed")
        public String getFeed() {
            return this.feed;
        }

        @Override
        @JsonProperty(value="timestamp")
        public DateTime getCreatedTime() {
            return this.request.getTimestamp();
        }

        @JsonProperty(value="service")
        public String getService() {
            return this.serviceDimensions.get("service");
        }

        @JsonProperty(value="host")
        public String getHost() {
            return this.serviceDimensions.get("host");
        }

        @JsonProperty(value="query")
        public Query getQuery() {
            return this.request.getQuery();
        }

        @JsonProperty(value="remoteAddr")
        public String getRemoteAddr() {
            return this.request.getRemoteAddr();
        }

        @JsonProperty(value="queryStats")
        public QueryStats getQueryStats() {
            return this.request.getQueryStats();
        }

        @Override
        public boolean isSafeToBuffer() {
            return true;
        }
    }
}

