/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.initialization;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.util.Providers;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.emitter.core.Emitter;
import org.apache.hive.druid.com.metamx.emitter.core.HttpPostEmitter;
import org.apache.hive.druid.com.metamx.http.client.HttpClientConfig;
import org.apache.hive.druid.com.metamx.http.client.HttpClientInit;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.http.LifecycleUtils;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.server.initialization.HttpEmitterConfig;

public class HttpEmitterModule
implements Module {
    public void configure(Binder binder) {
        SSLContext context;
        JsonConfigProvider.bind(binder, "druid.emitter.http", HttpEmitterConfig.class);
        try {
            context = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.propagate(e);
        }
        binder.bind(SSLContext.class).toProvider(Providers.of((Object)context)).in(LazySingleton.class);
    }

    @Provides
    @ManageLifecycle
    @Named(value="http")
    public Emitter getEmitter(Supplier<HttpEmitterConfig> config, @Nullable SSLContext sslContext, Lifecycle lifecycle, ObjectMapper jsonMapper) {
        HttpClientConfig.Builder builder = HttpClientConfig.builder().withNumConnections(1).withReadTimeout(config.get().getReadTimeout().toStandardDuration());
        if (sslContext != null) {
            builder.withSslContext(sslContext);
        }
        return new HttpPostEmitter(config.get(), HttpClientInit.createClient(builder.build(), LifecycleUtils.asMmxLifecycle(lifecycle)), jsonMapper);
    }
}

