/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.client.DruidDataSource;
import org.apache.hive.druid.io.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentManager;
import org.apache.hive.druid.io.druid.server.http.security.DatasourceResourceFilter;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.Action;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthorizationInfo;
import org.apache.hive.druid.io.druid.server.security.Resource;
import org.apache.hive.druid.io.druid.server.security.ResourceType;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.Interval;

@Path(value="/druid/coordinator/v1/metadata")
public class MetadataResource {
    private final MetadataSegmentManager metadataSegmentManager;
    private final IndexerMetadataStorageCoordinator metadataStorageCoordinator;
    private final AuthConfig authConfig;

    @Inject
    public MetadataResource(MetadataSegmentManager metadataSegmentManager, IndexerMetadataStorageCoordinator metadataStorageCoordinator, AuthConfig authConfig) {
        this.metadataSegmentManager = metadataSegmentManager;
        this.metadataStorageCoordinator = metadataStorageCoordinator;
        this.authConfig = authConfig;
    }

    @GET
    @Path(value="/datasources")
    @Produces(value={"application/json"})
    public Response getDatabaseDataSources(@QueryParam(value="full") String full, @QueryParam(value="includeDisabled") String includeDisabled, @Context HttpServletRequest req) {
        AbstractCollection dataSourceNamesPostAuth;
        TreeSet<String> dataSourceNamesPreAuth = includeDisabled != null ? Sets.newTreeSet(this.metadataSegmentManager.getAllDatasourceNames()) : Sets.newTreeSet(Iterables.transform(this.metadataSegmentManager.getInventory(), new Function<DruidDataSource, String>(){

            @Override
            public String apply(DruidDataSource input) {
                return input.getName();
            }
        }));
        if (this.authConfig.isEnabled()) {
            final HashMap resourceAccessMap = new HashMap();
            final AuthorizationInfo authorizationInfo = (AuthorizationInfo)req.getAttribute("Druid-Auth-Token");
            dataSourceNamesPostAuth = ImmutableSet.copyOf(Sets.filter(dataSourceNamesPreAuth, new Predicate<String>(){

                @Override
                public boolean apply(String input) {
                    Resource resource = new Resource(input, ResourceType.DATASOURCE);
                    Action action = Action.READ;
                    Pair<Resource, Action> key = new Pair<Resource, Action>(resource, action);
                    if (resourceAccessMap.containsKey(key)) {
                        return ((Access)resourceAccessMap.get(key)).isAllowed();
                    }
                    Access access = authorizationInfo.isAuthorized((Resource)key.lhs, (Action)((Object)key.rhs));
                    resourceAccessMap.put(key, access);
                    return access.isAllowed();
                }
            }));
        } else {
            dataSourceNamesPostAuth = dataSourceNamesPreAuth;
        }
        if (full != null && includeDisabled == null) {
            return Response.ok().entity(Collections2.filter(this.metadataSegmentManager.getInventory(), new Predicate<DruidDataSource>(){

                @Override
                public boolean apply(DruidDataSource input) {
                    return dataSourceNamesPostAuth.contains(input.getName());
                }
            })).build();
        }
        return Response.ok().entity(dataSourceNamesPostAuth).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatabaseSegmentDataSource(@PathParam(value="dataSourceName") String dataSourceName) {
        DruidDataSource dataSource = this.metadataSegmentManager.getInventoryValue(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)dataSource).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatabaseSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.metadataSegmentManager.getInventoryValue(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity(Iterables.transform(dataSource.getSegments(), new Function<DataSegment, String>(){

            @Override
            public String apply(DataSegment segment) {
                return segment.getIdentifier();
            }
        })).build();
    }

    @POST
    @Path(value="/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatabaseSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full, List<Interval> intervals) {
        List<DataSegment> segments;
        try {
            segments = this.metadataStorageCoordinator.getUsedSegmentsForIntervals(dataSourceName, intervals);
        }
        catch (IOException ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(segments).build();
        }
        return builder.entity(Iterables.transform(segments, new Function<DataSegment, String>(){

            @Override
            public String apply(DataSegment segment) {
                return segment.getIdentifier();
            }
        })).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatabaseSegmentDataSourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        DruidDataSource dataSource = this.metadataSegmentManager.getInventoryValue(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        for (DataSegment segment : dataSource.getSegments()) {
            if (!segment.getIdentifier().equalsIgnoreCase(segmentId)) continue;
            return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

