/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.HashBasedTable;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.hive.druid.com.google.common.collect.Table;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class SegmentReplicantLookup {
    private final Table<String, String, Integer> segmentsInCluster;
    private final Table<String, String, Integer> loadingSegments;

    public static SegmentReplicantLookup make(DruidCluster cluster) {
        HashBasedTable<String, String, Integer> segmentsInCluster = HashBasedTable.create();
        HashBasedTable<String, String, Integer> loadingSegments = HashBasedTable.create();
        for (MinMaxPriorityQueue<ServerHolder> serversByType : cluster.getSortedHistoricalsByTier()) {
            for (ServerHolder serverHolder : serversByType) {
                Integer numReplicants;
                ImmutableDruidServer server = serverHolder.getServer();
                for (DataSegment segment : server.getSegments().values()) {
                    numReplicants = (Integer)segmentsInCluster.get(segment.getIdentifier(), server.getTier());
                    if (numReplicants == null) {
                        numReplicants = 0;
                    }
                    numReplicants = numReplicants + 1;
                    segmentsInCluster.put(segment.getIdentifier(), server.getTier(), numReplicants);
                }
                for (DataSegment segment : serverHolder.getPeon().getSegmentsToLoad()) {
                    numReplicants = (Integer)loadingSegments.get(segment.getIdentifier(), server.getTier());
                    if (numReplicants == null) {
                        numReplicants = 0;
                    }
                    numReplicants = numReplicants + 1;
                    loadingSegments.put(segment.getIdentifier(), server.getTier(), numReplicants);
                }
            }
        }
        return new SegmentReplicantLookup(segmentsInCluster, loadingSegments);
    }

    private SegmentReplicantLookup(Table<String, String, Integer> segmentsInCluster, Table<String, String, Integer> loadingSegments) {
        this.segmentsInCluster = segmentsInCluster;
        this.loadingSegments = loadingSegments;
    }

    public Map<String, Integer> getClusterTiers(String segmentId) {
        Map<String, Integer> retVal = this.segmentsInCluster.row(segmentId);
        return retVal == null ? Maps.newHashMap() : retVal;
    }

    public Map<String, Integer> getLoadingTiers(String segmentId) {
        Map<String, Integer> retVal = this.loadingSegments.row(segmentId);
        return retVal == null ? Maps.newHashMap() : retVal;
    }

    public int getLoadedReplicants(String segmentId) {
        Map<String, Integer> allTiers = this.segmentsInCluster.row(segmentId);
        int retVal = 0;
        for (Integer replicants : allTiers.values()) {
            retVal += replicants.intValue();
        }
        return retVal;
    }

    public int getLoadedReplicants(String segmentId, String tier) {
        Integer retVal = this.segmentsInCluster.get(segmentId, tier);
        return retVal == null ? 0 : retVal;
    }

    public int getLoadingReplicants(String segmentId, String tier) {
        Integer retVal = this.loadingSegments.get(segmentId, tier);
        return retVal == null ? 0 : retVal;
    }

    public int getLoadingReplicants(String segmentId) {
        Map<String, Integer> allTiers = this.loadingSegments.row(segmentId);
        int retVal = 0;
        for (Integer replicants : allTiers.values()) {
            retVal += replicants.intValue();
        }
        return retVal;
    }

    public int getTotalReplicants(String segmentId) {
        return this.getLoadedReplicants(segmentId) + this.getLoadingReplicants(segmentId);
    }

    public int getTotalReplicants(String segmentId, String tier) {
        return this.getLoadedReplicants(segmentId, tier) + this.getLoadingReplicants(segmentId, tier);
    }
}

