/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;

public class DruidCluster {
    private final Set<ServerHolder> realtimes;
    private final Map<String, MinMaxPriorityQueue<ServerHolder>> historicals;

    public DruidCluster() {
        this.realtimes = new HashSet<ServerHolder>();
        this.historicals = new HashMap<String, MinMaxPriorityQueue<ServerHolder>>();
    }

    @VisibleForTesting
    public DruidCluster(@Nullable Set<ServerHolder> realtimes, Map<String, MinMaxPriorityQueue<ServerHolder>> historicals) {
        this.realtimes = realtimes == null ? new HashSet<ServerHolder>() : new HashSet<ServerHolder>(realtimes);
        this.historicals = historicals;
    }

    public void add(ServerHolder serverHolder) {
        switch (serverHolder.getServer().getType()) {
            case HISTORICAL: {
                this.addHistorical(serverHolder);
                break;
            }
            case REALTIME: {
                this.addRealtime(serverHolder);
                break;
            }
            case BRIDGE: {
                this.addHistorical(serverHolder);
                break;
            }
            case INDEXER_EXECUTOR: {
                throw new IAE("unsupported server type[%s]", new Object[]{serverHolder.getServer().getType()});
            }
            default: {
                throw new IAE("unknown server type[%s]", new Object[]{serverHolder.getServer().getType()});
            }
        }
    }

    private void addRealtime(ServerHolder serverHolder) {
        this.realtimes.add(serverHolder);
    }

    private void addHistorical(ServerHolder serverHolder) {
        ImmutableDruidServer server = serverHolder.getServer();
        MinMaxPriorityQueue tierServers = this.historicals.computeIfAbsent(server.getTier(), k -> MinMaxPriorityQueue.orderedBy(Ordering.natural().reverse()).create());
        tierServers.add(serverHolder);
    }

    public Set<ServerHolder> getRealtimes() {
        return this.realtimes;
    }

    public Map<String, MinMaxPriorityQueue<ServerHolder>> getHistoricals() {
        return this.historicals;
    }

    public Iterable<String> getTierNames() {
        return this.historicals.keySet();
    }

    public MinMaxPriorityQueue<ServerHolder> getHistoricalsByTier(String tier) {
        return this.historicals.get(tier);
    }

    public Collection<ServerHolder> getAllServers() {
        int historicalSize = this.historicals.values().stream().mapToInt(Collection::size).sum();
        int realtimeSize = this.realtimes.size();
        ArrayList<ServerHolder> allServers = new ArrayList<ServerHolder>(historicalSize + realtimeSize);
        this.historicals.values().forEach(allServers::addAll);
        allServers.addAll(this.realtimes);
        return allServers;
    }

    public Iterable<MinMaxPriorityQueue<ServerHolder>> getSortedHistoricalsByTier() {
        return this.historicals.values();
    }

    public boolean isEmpty() {
        return this.historicals.isEmpty() && this.realtimes.isEmpty();
    }

    public boolean hasHistoricals() {
        return !this.historicals.isEmpty();
    }

    public boolean hasRealtimes() {
        return !this.realtimes.isEmpty();
    }

    public boolean hasTier(String tier) {
        MinMaxPriorityQueue<ServerHolder> servers = this.historicals.get(tier);
        return servers == null || servers.isEmpty();
    }
}

