/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordination;

import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;

public class DruidServerMetadata {
    private final String name;
    private final String host;
    private final long maxSize;
    private final String tier;
    private final ServerType type;
    private final int priority;

    @JsonCreator
    public DruidServerMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="host") String host, @JsonProperty(value="maxSize") long maxSize, @JsonProperty(value="type") ServerType type, @JsonProperty(value="tier") String tier, @JsonProperty(value="priority") int priority) {
        this.name = name;
        this.host = host;
        this.maxSize = maxSize;
        this.tier = tier;
        this.type = type;
        this.priority = priority;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public long getMaxSize() {
        return this.maxSize;
    }

    @JsonProperty
    public String getTier() {
        return this.tier;
    }

    @JsonProperty
    public ServerType getType() {
        return this.type;
    }

    @JsonProperty
    public int getPriority() {
        return this.priority;
    }

    public boolean segmentReplicatable() {
        return this.type.isSegmentReplicationTarget();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidServerMetadata metadata = (DruidServerMetadata)o;
        if (this.maxSize != metadata.maxSize) {
            return false;
        }
        if (this.priority != metadata.priority) {
            return false;
        }
        if (this.host != null ? !this.host.equals(metadata.host) : metadata.host != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(metadata.name) : metadata.name != null) {
            return false;
        }
        if (this.tier != null ? !this.tier.equals(metadata.tier) : metadata.tier != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals((Object)metadata.type) : metadata.type != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + (int)(this.maxSize ^ this.maxSize >>> 32);
        result = 31 * result + (this.tier != null ? this.tier.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + this.priority;
        return result;
    }

    public String toString() {
        return "DruidServerMetadata{name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", maxSize=" + this.maxSize + ", tier='" + this.tier + '\'' + ", type='" + (Object)((Object)this.type) + '\'' + ", priority='" + this.priority + '\'' + '}';
    }
}

