/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.audit;

import com.google.inject.Inject;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.io.druid.audit.AuditEntry;
import org.apache.hive.druid.io.druid.audit.AuditManager;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.server.audit.SQLAuditManagerConfig;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

@ManageLifecycle
public class SQLAuditManager
implements AuditManager {
    private final IDBI dbi;
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final ServiceEmitter emitter;
    private final ObjectMapper jsonMapper;
    private final SQLAuditManagerConfig config;

    @Inject
    public SQLAuditManager(SQLMetadataConnector connector, Supplier<MetadataStorageTablesConfig> dbTables, ServiceEmitter emitter, @Json ObjectMapper jsonMapper, SQLAuditManagerConfig config) {
        this.dbi = connector.getDBI();
        this.dbTables = dbTables;
        this.emitter = emitter;
        this.jsonMapper = jsonMapper;
        this.config = config;
    }

    public String getAuditTable() {
        return this.dbTables.get().getAuditTable();
    }

    @Override
    public void doAudit(final AuditEntry auditEntry) {
        this.dbi.withHandle(new HandleCallback<Void>(){

            @Override
            public Void withHandle(Handle handle) throws Exception {
                SQLAuditManager.this.doAudit(auditEntry, handle);
                return null;
            }
        });
    }

    @Override
    public void doAudit(AuditEntry auditEntry, Handle handle) throws IOException {
        this.emitter.emit(new ServiceMetricEvent.Builder().setDimension("key", auditEntry.getKey()).setDimension("type", auditEntry.getType()).setDimension("author", auditEntry.getAuditInfo().getAuthor()).build("config/audit", 1));
        ((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format("INSERT INTO %s ( audit_key, type, author, comment, created_date, payload) VALUES (:audit_key, :type, :author, :comment, :created_date, :payload)", this.getAuditTable())).bind("audit_key", auditEntry.getKey())).bind("type", auditEntry.getType())).bind("author", auditEntry.getAuditInfo().getAuthor())).bind("comment", auditEntry.getAuditInfo().getComment())).bind("created_date", auditEntry.getAuditTime().toString())).bind("payload", this.jsonMapper.writeValueAsBytes(auditEntry))).execute();
    }

    @Override
    public List<AuditEntry> fetchAuditHistory(final String key, final String type, Interval interval) {
        final Interval theInterval = this.getIntervalOrDefault(interval);
        return this.dbi.withHandle(new HandleCallback<List<AuditEntry>>(){

            @Override
            public List<AuditEntry> withHandle(Handle handle) throws Exception {
                return ((Query)((Query)((Query)((Query)handle.createQuery(StringUtils.format("SELECT payload FROM %s WHERE audit_key = :audit_key and type = :type and created_date between :start_date and :end_date ORDER BY created_date", SQLAuditManager.this.getAuditTable())).bind("audit_key", key)).bind("type", type)).bind("start_date", theInterval.getStart().toString())).bind("end_date", theInterval.getEnd().toString())).map(new ResultSetMapper<AuditEntry>(){

                    @Override
                    public AuditEntry map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return SQLAuditManager.this.jsonMapper.readValue(r.getBytes("payload"), AuditEntry.class);
                        }
                        catch (IOException e) {
                            throw new SQLException(e);
                        }
                    }
                }).list();
            }
        });
    }

    private Interval getIntervalOrDefault(Interval interval) {
        Interval theInterval;
        if (interval == null) {
            DateTime now = new DateTime();
            theInterval = new Interval((ReadableInstant)now.minus(this.config.getAuditHistoryMillis()), (ReadableInstant)now);
        } else {
            theInterval = interval;
        }
        return theInterval;
    }

    private int getLimit(int limit) throws IllegalArgumentException {
        if (limit < 1) {
            throw new IllegalArgumentException("Limit must be greater than zero!");
        }
        return limit;
    }

    @Override
    public List<AuditEntry> fetchAuditHistory(final String type, Interval interval) {
        final Interval theInterval = this.getIntervalOrDefault(interval);
        return this.dbi.withHandle(new HandleCallback<List<AuditEntry>>(){

            @Override
            public List<AuditEntry> withHandle(Handle handle) throws Exception {
                return ((Query)((Query)((Query)handle.createQuery(StringUtils.format("SELECT payload FROM %s WHERE type = :type and created_date between :start_date and :end_date ORDER BY created_date", SQLAuditManager.this.getAuditTable())).bind("type", type)).bind("start_date", theInterval.getStart().toString())).bind("end_date", theInterval.getEnd().toString())).map(new ResultSetMapper<AuditEntry>(){

                    @Override
                    public AuditEntry map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return SQLAuditManager.this.jsonMapper.readValue(r.getBytes("payload"), AuditEntry.class);
                        }
                        catch (IOException e) {
                            throw new SQLException(e);
                        }
                    }
                }).list();
            }
        });
    }

    @Override
    public List<AuditEntry> fetchAuditHistory(String key, String type, int limit) throws IllegalArgumentException {
        return this.fetchAuditHistoryLastEntries(key, type, limit);
    }

    @Override
    public List<AuditEntry> fetchAuditHistory(String type, int limit) throws IllegalArgumentException {
        return this.fetchAuditHistoryLastEntries(null, type, limit);
    }

    private List<AuditEntry> fetchAuditHistoryLastEntries(final String key, final String type, int limit) throws IllegalArgumentException {
        final int theLimit = this.getLimit(limit);
        String queryString = StringUtils.format("SELECT payload FROM %s WHERE type = :type", this.getAuditTable());
        if (key != null) {
            queryString = queryString + " and audit_key = :audit_key";
        }
        final String theQueryString = queryString = queryString + " ORDER BY created_date DESC";
        return this.dbi.withHandle(new HandleCallback<List<AuditEntry>>(){

            @Override
            public List<AuditEntry> withHandle(Handle handle) throws Exception {
                Query<Map<String, Object>> query = handle.createQuery(theQueryString);
                if (key != null) {
                    query.bind("audit_key", key);
                }
                return ((Query)query.bind("type", type)).setMaxRows(theLimit).map(new ResultSetMapper<AuditEntry>(){

                    @Override
                    public AuditEntry map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return SQLAuditManager.this.jsonMapper.readValue(r.getBytes("payload"), AuditEntry.class);
                        }
                        catch (IOException e) {
                            throw new SQLException(e);
                        }
                    }
                }).list();
            }
        });
    }
}

