/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.client.DirectDruidClient;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.SequenceWrapper;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.DruidMetrics;
import org.apache.hive.druid.io.druid.query.GenericQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.QueryMetrics;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.io.druid.server.QueryStats;
import org.apache.hive.druid.io.druid.server.RequestLogLine;
import org.apache.hive.druid.io.druid.server.initialization.ServerConfig;
import org.apache.hive.druid.io.druid.server.log.RequestLogger;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.Action;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthorizationInfo;
import org.apache.hive.druid.io.druid.server.security.Resource;
import org.apache.hive.druid.io.druid.server.security.ResourceType;
import org.joda.time.DateTime;

public class QueryLifecycle {
    private static final Logger log = new Logger(QueryLifecycle.class);
    private final QueryToolChestWarehouse warehouse;
    private final QuerySegmentWalker texasRanger;
    private final GenericQueryMetricsFactory queryMetricsFactory;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;
    private final ServerConfig serverConfig;
    private final AuthConfig authConfig;
    private final long startMs;
    private final long startNs;
    private State state = State.NEW;
    private QueryToolChest toolChest;
    private QueryPlus queryPlus;

    public QueryLifecycle(QueryToolChestWarehouse warehouse, QuerySegmentWalker texasRanger, GenericQueryMetricsFactory queryMetricsFactory, ServiceEmitter emitter, RequestLogger requestLogger, ServerConfig serverConfig, AuthConfig authConfig, long startMs, long startNs) {
        this.warehouse = warehouse;
        this.texasRanger = texasRanger;
        this.queryMetricsFactory = queryMetricsFactory;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.serverConfig = serverConfig;
        this.authConfig = authConfig;
        this.startMs = startMs;
        this.startNs = startNs;
    }

    public <T> Sequence<T> runSimple(Query<T> query, @Nullable AuthorizationInfo authorizationInfo, final @Nullable String remoteAddress) {
        Sequence results;
        this.initialize(query);
        try {
            Access access = this.authorize(authorizationInfo);
            if (!access.isAllowed()) {
                throw new ISE("Unauthorized", new Object[0]);
            }
            QueryResponse queryResponse = this.execute();
            results = queryResponse.getResults();
        }
        catch (Throwable e) {
            this.emitLogsAndMetrics(e, remoteAddress, -1L);
            throw e;
        }
        return Sequences.wrap(results, new SequenceWrapper(){

            @Override
            public void after(boolean isDone, Throwable thrown) throws Exception {
                QueryLifecycle.this.emitLogsAndMetrics(thrown, remoteAddress, -1L);
            }
        });
    }

    public void initialize(Query baseQuery) {
        this.transition(State.NEW, State.INITIALIZED);
        String queryId = baseQuery.getId();
        if (queryId == null) {
            queryId = UUID.randomUUID().toString();
        }
        this.queryPlus = QueryPlus.wrap(DirectDruidClient.withDefaultTimeoutAndMaxScatterGatherBytes(baseQuery.withId(queryId), this.serverConfig));
        this.toolChest = this.warehouse.getToolChest(baseQuery);
    }

    public Access authorize(@Nullable AuthorizationInfo authorizationInfo) {
        this.transition(State.INITIALIZED, State.AUTHORIZING);
        if (this.authConfig.isEnabled()) {
            if (authorizationInfo != null) {
                for (String dataSource : this.queryPlus.getQuery().getDataSource().getNames()) {
                    Access authResult = authorizationInfo.isAuthorized(new Resource(dataSource, ResourceType.DATASOURCE), Action.READ);
                    if (authResult.isAllowed()) continue;
                    this.transition(State.AUTHORIZING, State.DONE);
                    return authResult;
                }
                this.transition(State.AUTHORIZING, State.AUTHORIZED);
                return new Access(true);
            }
            throw new ISE("WTF?! Security is enabled but no authorization info found in the request", new Object[0]);
        }
        this.transition(State.AUTHORIZING, State.AUTHORIZED);
        return new Access(true);
    }

    public QueryResponse execute() {
        this.transition(State.AUTHORIZED, State.EXECUTING);
        Map<String, Object> responseContext = DirectDruidClient.makeResponseContextForQuery(this.queryPlus.getQuery(), System.currentTimeMillis());
        Sequence res = this.queryPlus.run(this.texasRanger, responseContext);
        return new QueryResponse(res == null ? Sequences.empty() : res, responseContext);
    }

    public void emitLogsAndMetrics(@Nullable Throwable e, @Nullable String remoteAddress, long bytesWritten) {
        if (this.queryPlus == null) {
            return;
        }
        if (this.state == State.DONE) {
            log.warn("Tried to emit logs and metrics twice for query[%s]!", this.queryPlus.getQuery().getId());
        }
        this.state = State.DONE;
        Query query = this.queryPlus != null ? this.queryPlus.getQuery() : null;
        boolean success = e == null;
        try {
            long queryTimeNs = System.nanoTime() - this.startNs;
            QueryMetrics<?> queryMetrics = DruidMetrics.makeRequestMetrics(this.queryMetricsFactory, this.toolChest, this.queryPlus.getQuery(), Strings.nullToEmpty(remoteAddress));
            queryMetrics.success(success);
            queryMetrics.reportQueryTime(queryTimeNs);
            if (bytesWritten >= 0L) {
                queryMetrics.reportQueryBytes(bytesWritten);
            }
            queryMetrics.emit(this.emitter);
            LinkedHashMap<String, Object> statsMap = new LinkedHashMap<String, Object>();
            statsMap.put("query/time", TimeUnit.NANOSECONDS.toMillis(queryTimeNs));
            statsMap.put("query/bytes", bytesWritten);
            statsMap.put("success", success);
            if (e != null) {
                statsMap.put("exception", e.toString());
                if (e instanceof QueryInterruptedException) {
                    log.warn(e, "Exception while processing queryId [%s]", this.queryPlus.getQuery().getId());
                    statsMap.put("interrupted", true);
                    statsMap.put("reason", e.toString());
                }
            }
            this.requestLogger.log(new RequestLogLine(new DateTime(this.startMs), Strings.nullToEmpty(remoteAddress), this.queryPlus.getQuery(), new QueryStats(statsMap)));
        }
        catch (Exception ex) {
            log.error(ex, "Unable to log query [%s]!", query);
        }
    }

    public Query getQuery() {
        return this.queryPlus.getQuery();
    }

    private void transition(State from, State to) {
        if (this.state != from) {
            throw new ISE("Cannot transition from[%s] to[%s].", new Object[]{from, to});
        }
        this.state = to;
    }

    public static class QueryResponse {
        private final Sequence results;
        private final Map<String, Object> responseContext;

        private QueryResponse(Sequence results, Map<String, Object> responseContext) {
            this.results = results;
            this.responseContext = responseContext;
        }

        public Sequence getResults() {
            return this.results;
        }

        public Map<String, Object> getResponseContext() {
            return this.responseContext;
        }
    }

    static enum State {
        NEW,
        INITIALIZED,
        AUTHORIZING,
        AUTHORIZED,
        EXECUTING,
        DONE;

    }
}

