/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server;

import com.google.inject.name.Named;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.net.HostAndPort;
import org.apache.hive.druid.io.druid.common.utils.SocketUtil;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;

public class DruidNode {
    @JsonProperty(value="service")
    @NotNull
    private String serviceName;
    @JsonProperty
    @NotNull
    private String host;
    @JsonProperty
    @Min(value=0L)
    @Max(value=65535L)
    private int port = -1;

    @JsonCreator
    public DruidNode(@JacksonInject @Named(value="serviceName") @JsonProperty(value="service") String serviceName, @JsonProperty(value="host") String host, @JacksonInject @Named(value="servicePort") @JsonProperty(value="port") Integer port) {
        this.init(serviceName, host, port);
    }

    private void init(String serviceName, String host, Integer port) {
        Preconditions.checkNotNull(serviceName);
        this.serviceName = serviceName;
        if (host == null && port == null) {
            host = DruidNode.getDefaultHost();
            port = -1;
        } else {
            HostAndPort hostAndPort;
            if (host != null) {
                hostAndPort = HostAndPort.fromString(host);
                if (port != null && hostAndPort.hasPort() && port.intValue() != hostAndPort.getPort()) {
                    throw new IAE("Conflicting host:port [%s] and port [%d] settings", host, port);
                }
            } else {
                hostAndPort = HostAndPort.fromParts(DruidNode.getDefaultHost(), port);
            }
            host = hostAndPort.getHostText();
            if (hostAndPort.hasPort()) {
                port = hostAndPort.getPort();
            }
            if (port == null) {
                port = SocketUtil.findOpenPort(8080);
            }
        }
        this.port = port;
        this.host = host;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public DruidNode withService(String service) {
        return new DruidNode(service, this.host, this.port);
    }

    public String getHostAndPort() {
        if (this.port < 0) {
            return HostAndPort.fromString(this.host).toString();
        }
        return HostAndPort.fromParts(this.host, this.port).toString();
    }

    public static String getDefaultHost() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new ISE(e, "Unable to determine host name", new Object[0]);
        }
    }

    public String toString() {
        return "DruidNode{serviceName='" + this.serviceName + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidNode node = (DruidNode)o;
        if (this.port != node.port) {
            return false;
        }
        if (!this.serviceName.equals(node.serviceName)) {
            return false;
        }
        return this.host.equals(node.host);
    }

    public int hashCode() {
        int result = this.serviceName.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }
}

