/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSerializer;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.CompressedDoublesIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.serde.ColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.DoubleGenericColumnSupplier;

public class DoubleGenericColumnPartSerde
implements ColumnPartSerde {
    private final ByteOrder byteOrder;
    private ColumnPartSerde.Serializer serialize;

    @JsonCreator
    public static DoubleGenericColumnPartSerde getDoubleGenericColumnPartSerde(@JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new DoubleGenericColumnPartSerde(byteOrder, null);
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public DoubleGenericColumnPartSerde(ByteOrder byteOrder, ColumnPartSerde.Serializer serialize) {
        this.byteOrder = byteOrder;
        this.serialize = serialize;
    }

    @Override
    public ColumnPartSerde.Serializer getSerializer() {
        return this.serialize;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return (buffer, builder, columnConfig) -> {
            CompressedDoublesIndexedSupplier column = CompressedDoublesIndexedSupplier.fromByteBuffer(buffer, this.byteOrder, builder.getFileMapper());
            builder.setType(ValueType.DOUBLE).setHasMultipleValues(false).setGenericColumn(new DoubleGenericColumnSupplier(column, IndexIO.LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap()));
        };
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    public static class SerializerBuilder {
        private ByteOrder byteOrder = null;
        private DoubleColumnSerializer delegate = null;

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withDelegate(DoubleColumnSerializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public DoubleGenericColumnPartSerde build() {
            return new DoubleGenericColumnPartSerde(this.byteOrder, new ColumnPartSerde.Serializer(){

                @Override
                public long numBytes() {
                    return delegate.getSerializedSize();
                }

                @Override
                public void write(WritableByteChannel channel, FileSmoosher fileSmoosher) throws IOException {
                    delegate.writeToChannel(channel, fileSmoosher);
                }
            });
        }
    }
}

