/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;

public class ComplexColumnSerializer
implements GenericColumnSerializer {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ObjectStrategy strategy;
    private GenericIndexedWriter writer;

    public ComplexColumnSerializer(IOPeon ioPeon, String filenameBase, ObjectStrategy strategy) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.strategy = strategy;
    }

    public static ComplexColumnSerializer create(IOPeon ioPeon, String filenameBase, ObjectStrategy strategy) {
        return new ComplexColumnSerializer(ioPeon, filenameBase, strategy);
    }

    @Override
    public void open() throws IOException {
        this.writer = new GenericIndexedWriter(this.ioPeon, StringUtils.format("%s.complex_column", this.filenameBase), this.strategy);
        this.writer.open();
    }

    @Override
    public void serialize(Object obj) throws IOException {
        this.writer.write(obj);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public long getSerializedSize() {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeToChannelVersionOne(channel);
    }

    private void writeToChannelVersionOne(WritableByteChannel channel) throws IOException {
        this.writer.writeToChannel(channel, null);
    }
}

