/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.io.druid.segment.column.ColumnBuilder;
import org.apache.hive.druid.io.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.io.druid.segment.serde.ColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetrics;

public class ComplexColumnPartSerde
implements ColumnPartSerde {
    private final String typeName;
    private final ComplexMetricSerde serde;
    private final ColumnPartSerde.Serializer serializer;

    private ComplexColumnPartSerde(String typeName, ColumnPartSerde.Serializer serializer) {
        this.typeName = typeName;
        this.serde = ComplexMetrics.getSerdeForType(typeName);
        this.serializer = serializer;
    }

    @JsonCreator
    public static ComplexColumnPartSerde createDeserializer(@JsonProperty(value="typeName") String complexType) {
        return new ComplexColumnPartSerde(complexType, null);
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @JsonProperty
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public ColumnPartSerde.Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                if (ComplexColumnPartSerde.this.serde != null) {
                    ComplexColumnPartSerde.this.serde.deserializeColumn(buffer, builder);
                }
            }
        };
    }

    public static class SerializerBuilder {
        private String typeName = null;
        private GenericColumnSerializer delegate = null;

        public SerializerBuilder withTypeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public SerializerBuilder withDelegate(GenericColumnSerializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public ComplexColumnPartSerde build() {
            return new ComplexColumnPartSerde(this.typeName, new ColumnPartSerde.Serializer(){

                @Override
                public long numBytes() {
                    return delegate.getSerializedSize();
                }

                @Override
                public void write(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
                    delegate.writeToChannel(channel, smoosher);
                }
            });
        }
    }
}

