/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.indexing.granularity;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.GranularitySpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class UniformGranularitySpec
implements GranularitySpec {
    private static final Granularity DEFAULT_SEGMENT_GRANULARITY = Granularities.DAY;
    private static final Granularity DEFAULT_QUERY_GRANULARITY = Granularities.NONE;
    private final Granularity segmentGranularity;
    private final Granularity queryGranularity;
    private final Boolean rollup;
    private final List<Interval> inputIntervals;
    private final ArbitraryGranularitySpec wrappedSpec;

    @JsonCreator
    public UniformGranularitySpec(@JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @JsonProperty(value="queryGranularity") Granularity queryGranularity, @JsonProperty(value="rollup") Boolean rollup, @JsonProperty(value="intervals") List<Interval> inputIntervals) {
        this.queryGranularity = queryGranularity == null ? DEFAULT_QUERY_GRANULARITY : queryGranularity;
        this.rollup = rollup == null ? Boolean.TRUE : rollup;
        Granularity granularity = this.segmentGranularity = segmentGranularity == null ? DEFAULT_SEGMENT_GRANULARITY : segmentGranularity;
        if (inputIntervals != null) {
            ArrayList<Interval> granularIntervals = Lists.newArrayList();
            for (Interval inputInterval : inputIntervals) {
                Iterables.addAll(granularIntervals, this.segmentGranularity.getIterable(inputInterval));
            }
            this.inputIntervals = ImmutableList.copyOf(inputIntervals);
            this.wrappedSpec = new ArbitraryGranularitySpec(queryGranularity, rollup, granularIntervals);
        } else {
            this.inputIntervals = null;
            this.wrappedSpec = null;
        }
    }

    public UniformGranularitySpec(Granularity segmentGranularity, Granularity queryGranularity, List<Interval> inputIntervals) {
        this(segmentGranularity, queryGranularity, true, inputIntervals);
    }

    @Override
    public Optional<SortedSet<Interval>> bucketIntervals() {
        if (this.wrappedSpec == null) {
            return Optional.absent();
        }
        return this.wrappedSpec.bucketIntervals();
    }

    @Override
    public List<Interval> inputIntervals() {
        return this.inputIntervals == null ? ImmutableList.of() : ImmutableList.copyOf(this.inputIntervals);
    }

    @Override
    public Optional<Interval> bucketInterval(DateTime dt) {
        return this.wrappedSpec.bucketInterval(dt);
    }

    @Override
    @JsonProperty(value="segmentGranularity")
    public Granularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @Override
    @JsonProperty(value="rollup")
    public boolean isRollup() {
        return this.rollup;
    }

    @Override
    @JsonProperty(value="queryGranularity")
    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    @JsonProperty(value="intervals")
    public Optional<List<Interval>> getIntervals() {
        return Optional.fromNullable(this.inputIntervals);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniformGranularitySpec that = (UniformGranularitySpec)o;
        if (this.segmentGranularity != that.segmentGranularity) {
            return false;
        }
        if (!this.queryGranularity.equals(that.queryGranularity)) {
            return false;
        }
        if (!this.rollup.equals(that.rollup)) {
            return false;
        }
        if (this.inputIntervals != null ? !this.inputIntervals.equals(that.inputIntervals) : that.inputIntervals != null) {
            return false;
        }
        return !(this.wrappedSpec == null ? that.wrappedSpec != null : !this.wrappedSpec.equals(that.wrappedSpec));
    }

    public int hashCode() {
        int result = this.segmentGranularity.hashCode();
        result = 31 * result + this.queryGranularity.hashCode();
        result = 31 * result + this.rollup.hashCode();
        result = 31 * result + (this.inputIntervals != null ? this.inputIntervals.hashCode() : 0);
        result = 31 * result + (this.wrappedSpec != null ? this.wrappedSpec.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "UniformGranularitySpec{segmentGranularity=" + this.segmentGranularity + ", queryGranularity=" + this.queryGranularity + ", rollup=" + this.rollup + ", inputIntervals=" + this.inputIntervals + ", wrappedSpec=" + this.wrappedSpec + '}';
    }

    @Override
    public GranularitySpec withIntervals(List<Interval> inputIntervals) {
        return new UniformGranularitySpec(this.segmentGranularity, this.queryGranularity, this.rollup, inputIntervals);
    }
}

