/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.incremental;

import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelectorUtils;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.DoubleWrappingDimensionSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatWrappingDimensionSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongWrappingDimensionSelector;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.io.druid.segment.SingleScanTimeDimSelector;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.apache.hive.druid.io.druid.segment.ZeroDoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.ZeroFloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.ZeroLongColumnSelector;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.TimeAndDimsHolder;

class IncrementalIndexColumnSelectorFactory
implements ColumnSelectorFactory {
    private final IncrementalIndex<?> index;
    private final VirtualColumns virtualColumns;
    private final boolean descending;
    private final TimeAndDimsHolder timeAndDimsHolder;

    IncrementalIndexColumnSelectorFactory(IncrementalIndex<?> index, VirtualColumns virtualColumns, boolean descending, TimeAndDimsHolder timeAndDimsHolder) {
        this.index = index;
        this.virtualColumns = virtualColumns;
        this.descending = descending;
        this.timeAndDimsHolder = timeAndDimsHolder;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this);
        }
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        String dimension = dimensionSpec.getDimension();
        ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        if (dimension.equals("__time")) {
            return new SingleScanTimeDimSelector(this.makeLongColumnSelector(dimension), extractionFn, this.descending);
        }
        IncrementalIndex.DimensionDesc dimensionDesc = this.index.getDimension(dimensionSpec.getDimension());
        if (dimensionDesc == null) {
            ColumnCapabilities capabilities = this.getColumnCapabilities(dimension);
            if (capabilities == null) {
                return DimensionSelectorUtils.constantSelector(null, extractionFn);
            }
            if (capabilities.getType() == ValueType.LONG) {
                return new LongWrappingDimensionSelector(this.makeLongColumnSelector(dimension), extractionFn);
            }
            if (capabilities.getType() == ValueType.FLOAT) {
                return new FloatWrappingDimensionSelector(this.makeFloatColumnSelector(dimension), extractionFn);
            }
            if (capabilities.getType() == ValueType.DOUBLE) {
                return new DoubleWrappingDimensionSelector(this.makeDoubleColumnSelector(dimension), extractionFn);
            }
            return DimensionSelectorUtils.constantSelector(null, extractionFn);
        }
        DimensionIndexer indexer = dimensionDesc.getIndexer();
        return indexer.makeDimensionSelector(dimensionSpec, this.timeAndDimsHolder, dimensionDesc);
    }

    @Override
    public FloatColumnSelector makeFloatColumnSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeFloatColumnSelector(columnName, this);
        }
        Integer dimIndex = this.index.getDimensionIndex(columnName);
        if (dimIndex != null) {
            IncrementalIndex.DimensionDesc dimensionDesc = this.index.getDimension(columnName);
            DimensionIndexer indexer = dimensionDesc.getIndexer();
            return indexer.makeFloatColumnSelector(this.timeAndDimsHolder, dimensionDesc);
        }
        Integer metricIndexInt = this.index.getMetricIndex(columnName);
        if (metricIndexInt == null) {
            return ZeroFloatColumnSelector.instance();
        }
        final int metricIndex = metricIndexInt;
        return new FloatColumnSelector(){

            @Override
            public float getFloat() {
                return IncrementalIndexColumnSelectorFactory.this.index.getMetricFloatValue(IncrementalIndexColumnSelectorFactory.this.timeAndDimsHolder.getValue(), metricIndex);
            }

            @Override
            public boolean isNull() {
                return IncrementalIndexColumnSelectorFactory.this.index.isNull(IncrementalIndexColumnSelectorFactory.this.timeAndDimsHolder.getValue(), metricIndex);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("index", IncrementalIndexColumnSelectorFactory.this.index);
            }
        };
    }

    @Override
    public DoubleColumnSelector makeDoubleColumnSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeDoubleColumnSelector(columnName, this);
        }
        Integer dimIndex = this.index.getDimensionIndex(columnName);
        if (dimIndex != null) {
            IncrementalIndex.DimensionDesc dimensionDesc = this.index.getDimension(columnName);
            DimensionIndexer indexer = dimensionDesc.getIndexer();
            return indexer.makeDoubleColumnSelector(this.timeAndDimsHolder, dimensionDesc);
        }
        Integer metricIndexInt = this.index.getMetricIndex(columnName);
        if (metricIndexInt == null) {
            return ZeroDoubleColumnSelector.instance();
        }
        final int metricIndex = metricIndexInt;
        return new DoubleColumnSelector(){

            @Override
            public double getDouble() {
                return IncrementalIndexColumnSelectorFactory.this.index.getMetricDoubleValue(IncrementalIndexColumnSelectorFactory.this.timeAndDimsHolder.getValue(), metricIndex);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("index", IncrementalIndexColumnSelectorFactory.this.index);
            }

            @Override
            public boolean isNull() {
                return IncrementalIndexColumnSelectorFactory.this.index.isNull(IncrementalIndexColumnSelectorFactory.this.timeAndDimsHolder.getValue(), metricIndex);
            }
        };
    }

    @Override
    public LongColumnSelector makeLongColumnSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeLongColumnSelector(columnName, this);
        }
        if (columnName.equals("__time")) {
            class TimeLongColumnSelector
            implements LongColumnSelector {
                TimeLongColumnSelector() {
                }

                @Override
                public long getLong() {
                    return IncrementalIndexColumnSelectorFactory.this.timeAndDimsHolder.getKey().getTimestamp();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }

                @Override
                public boolean isNull() {
                    return false;
                }
            }
            return new TimeLongColumnSelector();
        }
        Integer dimIndex = this.index.getDimensionIndex(columnName);
        if (dimIndex != null) {
            IncrementalIndex.DimensionDesc dimensionDesc = this.index.getDimension(columnName);
            DimensionIndexer indexer = dimensionDesc.getIndexer();
            return indexer.makeLongColumnSelector(this.timeAndDimsHolder, dimensionDesc);
        }
        Integer metricIndexInt = this.index.getMetricIndex(columnName);
        if (metricIndexInt == null) {
            return ZeroLongColumnSelector.instance();
        }
        final int metricIndex = metricIndexInt;
        return new LongColumnSelector(){

            @Override
            public long getLong() {
                return IncrementalIndexColumnSelectorFactory.this.index.getMetricLongValue(IncrementalIndexColumnSelectorFactory.this.timeAndDimsHolder.getValue(), metricIndex);
            }

            @Override
            public boolean isNull() {
                return IncrementalIndexColumnSelectorFactory.this.index.isNull(IncrementalIndexColumnSelectorFactory.this.timeAndDimsHolder.getValue(), metricIndex);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("index", IncrementalIndexColumnSelectorFactory.this.index);
            }
        };
    }

    @Override
    public ObjectColumnSelector makeObjectColumnSelector(String column) {
        if (this.virtualColumns.exists(column)) {
            return this.virtualColumns.makeObjectColumnSelector(column, this);
        }
        if (column.equals("__time")) {
            return new ObjectColumnSelector<Long>(){

                @Override
                public Class<Long> classOfObject() {
                    return Long.class;
                }

                @Override
                public Long get() {
                    return IncrementalIndexColumnSelectorFactory.this.timeAndDimsHolder.getKey().getTimestamp();
                }
            };
        }
        Integer metricIndexInt = this.index.getMetricIndex(column);
        if (metricIndexInt != null) {
            final int metricIndex = metricIndexInt;
            final Class classOfObject = this.index.getMetricClass(column);
            return new ObjectColumnSelector(){

                public Class classOfObject() {
                    return classOfObject;
                }

                public Object get() {
                    return IncrementalIndexColumnSelectorFactory.this.index.getMetricObjectValue(IncrementalIndexColumnSelectorFactory.this.timeAndDimsHolder.getValue(), metricIndex);
                }
            };
        }
        IncrementalIndex.DimensionDesc dimensionDesc = this.index.getDimension(column);
        if (dimensionDesc == null) {
            return null;
        }
        final int dimensionIndex = dimensionDesc.getIndex();
        final DimensionIndexer indexer = dimensionDesc.getIndexer();
        return new ObjectColumnSelector<Object>(){

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public Object get() {
                IncrementalIndex.TimeAndDims key = IncrementalIndexColumnSelectorFactory.this.timeAndDimsHolder.getKey();
                if (key == null) {
                    return null;
                }
                Object[] dims = key.getDims();
                if (dimensionIndex >= dims.length) {
                    return null;
                }
                return indexer.convertUnsortedEncodedKeyComponentToActualArrayOrList(dims[dimensionIndex], false);
            }
        };
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(columnName);
        }
        return this.index.getCapabilities(columnName);
    }
}

