/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.CountingOutputStream;
import org.apache.hive.druid.com.google.common.io.InputSupplier;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;

public class GenericIndexedWriter<T>
implements Closeable {
    private static int PAGE_SIZE = 4096;
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ObjectStrategy<T> strategy;
    private final int fileSizeLimit;
    private final byte[] fileNameByteArray;
    private boolean objectsSorted = true;
    private T prevObject = null;
    private CountingOutputStream headerOut = null;
    private CountingOutputStream valuesOut = null;
    private CountingOutputStream headerOutLong = null;
    private long numWritten = 0L;
    private boolean requireMultipleFiles = false;
    private ByteBuffer buf;
    private final ByteBuffer sizeHelperBuffer = ByteBuffer.allocate(4);

    public GenericIndexedWriter(IOPeon ioPeon, String filenameBase, ObjectStrategy<T> strategy) {
        this(ioPeon, filenameBase, strategy, Integer.MAX_VALUE & ~PAGE_SIZE);
    }

    public GenericIndexedWriter(IOPeon ioPeon, String filenameBase, ObjectStrategy<T> strategy, int fileSizeLimit) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.strategy = strategy;
        this.fileSizeLimit = fileSizeLimit;
        this.fileNameByteArray = StringUtils.toUtf8(filenameBase);
        this.buf = ByteBuffer.allocate(4);
    }

    public static String generateValueFileName(String fileNameBase, int fileNum) {
        return StringUtils.format("%s_value_%d", fileNameBase, fileNum);
    }

    public static String generateHeaderFileName(String fileNameBase) {
        return StringUtils.format("%s_header", fileNameBase);
    }

    private static void writeBytesIntoSmooshedChannel(long numBytesToPutInFile, byte[] buffer, SmooshedWriter smooshChannel, InputStream is) throws IOException {
        ByteBuffer holderBuffer = ByteBuffer.wrap(buffer);
        while (numBytesToPutInFile > 0L) {
            int bytesRead = is.read(buffer, 0, Math.min(buffer.length, Ints.saturatedCast(numBytesToPutInFile)));
            if (bytesRead != -1) {
                smooshChannel.write((ByteBuffer)holderBuffer.clear().limit(bytesRead));
                numBytesToPutInFile -= (long)bytesRead;
                continue;
            }
            throw new ISE("Could not write [%d] bytes into smooshChannel.", numBytesToPutInFile);
        }
    }

    public void open() throws IOException {
        this.headerOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.makeFilename("header")));
        this.valuesOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.makeFilename("values")));
    }

    public void write(T objectToWrite) throws IOException {
        byte[] bytesToWrite;
        if (this.objectsSorted && this.prevObject != null && this.strategy.compare(this.prevObject, objectToWrite) >= 0) {
            this.objectsSorted = false;
        }
        int size = (bytesToWrite = this.strategy.toBytes(objectToWrite)) == null ? -1 : bytesToWrite.length;
        ++this.numWritten;
        SerializerUtils.writeBigEndianIntToOutputStream(this.valuesOut, size, this.sizeHelperBuffer);
        if (bytesToWrite != null) {
            this.valuesOut.write(bytesToWrite);
        }
        if (!this.requireMultipleFiles) {
            SerializerUtils.writeBigEndianIntToOutputStream(this.headerOut, Ints.checkedCast(this.valuesOut.getCount()), this.buf);
        } else {
            SerializerUtils.writeNativeOrderedLongToOutputStream(this.headerOutLong, this.valuesOut.getCount(), this.buf);
        }
        if (!this.requireMultipleFiles && this.getSerializedSize() > (long)this.fileSizeLimit) {
            this.requireMultipleFiles = true;
            this.initializeHeaderOutLong();
            this.buf = ByteBuffer.allocate(8).order(ByteOrder.nativeOrder());
        }
        this.prevObject = objectToWrite;
    }

    private String makeFilename(String suffix) {
        return StringUtils.format("%s.%s", this.filenameBase, suffix);
    }

    @Override
    public void close() throws IOException {
        this.valuesOut.close();
        if (this.requireMultipleFiles) {
            this.closeMultiFiles();
        } else {
            this.closeSingleFile();
        }
    }

    private void closeSingleFile() throws IOException {
        this.headerOut.close();
        long numBytesWritten = this.headerOut.getCount() + this.valuesOut.getCount();
        Preconditions.checkState(this.headerOut.getCount() == this.numWritten * 4L, "numWritten[%s] number of rows should have [%s] bytes written to headerOut, had[%s]", this.numWritten, this.numWritten * 4L, this.headerOut.getCount());
        Preconditions.checkState(numBytesWritten < (long)this.fileSizeLimit, "Wrote[%s] bytes to base file %s, which is too many.", numBytesWritten, this.filenameBase);
        try (OutputStream metaOut = this.ioPeon.makeOutputStream(this.makeFilename("meta"));){
            metaOut.write(1);
            metaOut.write(this.objectsSorted ? 1 : 0);
            metaOut.write(Ints.toByteArray(Ints.checkedCast(numBytesWritten + 4L)));
            metaOut.write(Ints.toByteArray(Ints.checkedCast(this.numWritten)));
        }
    }

    private void closeMultiFiles() throws IOException {
        this.headerOutLong.close();
        Preconditions.checkState(this.headerOutLong.getCount() == this.numWritten * 8L, "numWritten[%s] number of rows should have [%s] bytes written to headerOutLong, had[%s]", this.numWritten, this.numWritten * 8L, this.headerOutLong.getCount());
        Preconditions.checkState(this.headerOutLong.getCount() < (long)(Integer.MAX_VALUE & ~PAGE_SIZE), "Wrote[%s] bytes in header file of base file %s, which is too many.", this.headerOutLong.getCount(), this.filenameBase);
    }

    private int bagSizePower() throws IOException {
        long avgObjectSize = (this.valuesOut.getCount() + this.numWritten - 1L) / this.numWritten;
        File f = this.ioPeon.getFile(this.makeFilename("headerLong"));
        Preconditions.checkNotNull(f, "header file missing.");
        try (RandomAccessFile headerFile = new RandomAccessFile(f, "r");){
            for (int i = 31; i >= 0; --i) {
                if ((1L << i) * avgObjectSize > (long)this.fileSizeLimit || !this.actuallyFits(i, headerFile)) continue;
                int n = i;
                return n;
            }
        }
        throw new ISE("no value split found with fileSizeLimit [%d], avgObjectSize [%d] while serializing [%s]", this.fileSizeLimit, avgObjectSize, this.filenameBase);
    }

    private boolean actuallyFits(int powerTwo, RandomAccessFile headerFile) throws IOException {
        long lastValueOffset = 0L;
        long currentValueOffset = 0L;
        long valueBytesWritten = this.valuesOut.getCount();
        long headerIndex = 0L;
        long bagSize = 1L << powerTwo;
        while (lastValueOffset < valueBytesWritten) {
            if (headerIndex >= this.numWritten) {
                return true;
            }
            if (headerIndex + bagSize <= this.numWritten) {
                headerFile.seek((headerIndex + bagSize - 1L) * 8L);
                currentValueOffset = Long.reverseBytes(headerFile.readLong());
            } else if (this.numWritten < headerIndex + bagSize) {
                headerFile.seek((this.numWritten - 1L) * 8L);
                currentValueOffset = Long.reverseBytes(headerFile.readLong());
            }
            if (currentValueOffset - lastValueOffset <= (long)this.fileSizeLimit) {
                lastValueOffset = currentValueOffset;
                headerIndex += bagSize;
                continue;
            }
            return false;
        }
        return true;
    }

    public long getSerializedSize() {
        if (!this.requireMultipleFiles) {
            return 10L + this.headerOut.getCount() + this.valuesOut.getCount();
        }
        return 14 + this.fileNameByteArray.length;
    }

    @Deprecated
    public InputSupplier<InputStream> combineStreams() {
        if (this.requireMultipleFiles) {
            throw new ISE("Can not combine streams for version 2.", new Object[0]);
        }
        return ByteStreams.join(Iterables.transform(Arrays.asList("meta", "header", "values"), new Function<String, InputSupplier<InputStream>>(){

            @Override
            public InputSupplier<InputStream> apply(final String input) {
                return new InputSupplier<InputStream>(){

                    @Override
                    public InputStream getInput() throws IOException {
                        return GenericIndexedWriter.this.ioPeon.makeInputStream(GenericIndexedWriter.this.makeFilename(input));
                    }
                };
            }
        }));
    }

    private void writeToChannelVersionOne(WritableByteChannel channel) throws IOException {
        try (ReadableByteChannel from = Channels.newChannel(this.combineStreams().getInput());){
            ByteStreams.copy(from, channel);
        }
    }

    private void writeToChannelVersionTwo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        if (smoosher == null) {
            throw new IAE("version 2 GenericIndexedWriter requires FileSmoosher.", new Object[0]);
        }
        int bagSizePower = this.bagSizePower();
        OutputStream metaOut = Channels.newOutputStream(channel);
        metaOut.write(2);
        metaOut.write(this.objectsSorted ? 1 : 0);
        metaOut.write(Ints.toByteArray(bagSizePower));
        metaOut.write(Ints.toByteArray(Ints.checkedCast(this.numWritten)));
        metaOut.write(Ints.toByteArray(this.fileNameByteArray.length));
        metaOut.write(this.fileNameByteArray);
        try (RandomAccessFile headerFile = new RandomAccessFile(this.ioPeon.getFile(this.makeFilename("headerLong")), "r");){
            Preconditions.checkNotNull(headerFile, "header file missing.");
            long previousValuePosition = 0L;
            int bagSize = 1 << bagSizePower;
            int numberOfFilesRequired = GenericIndexed.getNumberOfFilesRequired(bagSize, this.numWritten);
            byte[] buffer = new byte[65536];
            try (FileInputStream is = new FileInputStream(this.ioPeon.getFile(this.makeFilename("values")));){
                int counter = -1;
                for (int i = 0; i < numberOfFilesRequired; ++i) {
                    if (i != numberOfFilesRequired - 1) {
                        headerFile.seek((bagSize + counter) * 8);
                        counter += bagSize;
                    } else {
                        headerFile.seek((this.numWritten - 1L) * 8L);
                    }
                    long valuePosition = Long.reverseBytes(headerFile.readLong());
                    long numBytesToPutInFile = valuePosition - previousValuePosition;
                    try (SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(GenericIndexedWriter.generateValueFileName(this.filenameBase, i), numBytesToPutInFile);){
                        GenericIndexedWriter.writeBytesIntoSmooshedChannel(numBytesToPutInFile, buffer, smooshChannel, is);
                        previousValuePosition = valuePosition;
                        continue;
                    }
                }
            }
            this.writeHeaderLong(smoosher, headerFile, bagSizePower, buffer);
        }
    }

    public void writeToChannel(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        if (!this.requireMultipleFiles) {
            this.writeToChannelVersionOne(channel);
        } else {
            this.writeToChannelVersionTwo(channel, smoosher);
        }
    }

    private void writeHeaderLong(FileSmoosher smoosher, RandomAccessFile headerFile, int bagSizePower, byte[] buffer) throws IOException {
        ByteBuffer helperBuffer = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
        try (CountingOutputStream finalHeaderOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.makeFilename("header_final")));){
            int numberOfElementsPerValueFile = 1 << bagSizePower;
            long currentNumBytes = 0L;
            long relativeRefBytes = 0L;
            headerFile.seek(0L);
            int pos = 0;
            while ((long)pos < this.numWritten) {
                if ((pos & numberOfElementsPerValueFile - 1) == 0) {
                    relativeRefBytes = currentNumBytes;
                }
                currentNumBytes = Long.reverseBytes(headerFile.readLong());
                long relativeNumBytes = currentNumBytes - relativeRefBytes;
                SerializerUtils.writeNativeOrderedIntToOutputStream(finalHeaderOut, Ints.checkedCast(relativeNumBytes), helperBuffer);
                ++pos;
            }
            long numBytesToPutInFile = finalHeaderOut.getCount();
            finalHeaderOut.close();
            try (FileInputStream is = new FileInputStream(this.ioPeon.getFile(this.makeFilename("header_final")));
                 SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(GenericIndexedWriter.generateHeaderFileName(this.filenameBase), numBytesToPutInFile);){
                GenericIndexedWriter.writeBytesIntoSmooshedChannel(numBytesToPutInFile, buffer, smooshChannel, is);
            }
        }
    }

    private void initializeHeaderOutLong() throws IOException {
        this.headerOut.close();
        this.headerOutLong = new CountingOutputStream(this.ioPeon.makeOutputStream(this.makeFilename("headerLong")));
        try (RandomAccessFile headerFile = new RandomAccessFile(this.ioPeon.getFile(this.makeFilename("header")), "r");){
            ByteBuffer buf = ByteBuffer.allocate(8).order(ByteOrder.nativeOrder());
            int i = 0;
            while ((long)i < this.numWritten) {
                int count = headerFile.readInt();
                SerializerUtils.writeNativeOrderedLongToOutputStream(this.headerOutLong, count, buf);
                ++i;
            }
        }
    }
}

