/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.segment.data.IndexedFloats;

public class EntireLayoutIndexedFloatSupplier
implements Supplier<IndexedFloats> {
    private final int totalSize;
    private FloatBuffer buffer;

    public EntireLayoutIndexedFloatSupplier(int totalSize, ByteBuffer fromBuffer, ByteOrder order) {
        this.totalSize = totalSize;
        this.buffer = fromBuffer.asReadOnlyBuffer().order(order).asFloatBuffer();
    }

    @Override
    public IndexedFloats get() {
        return new EntireLayoutIndexedFloats();
    }

    private class EntireLayoutIndexedFloats
    implements IndexedFloats {
        private EntireLayoutIndexedFloats() {
        }

        @Override
        public int size() {
            return EntireLayoutIndexedFloatSupplier.this.totalSize;
        }

        @Override
        public float get(int index) {
            return EntireLayoutIndexedFloatSupplier.this.buffer.get(EntireLayoutIndexedFloatSupplier.this.buffer.position() + index);
        }

        @Override
        public void fill(int index, float[] toFill) {
            if (EntireLayoutIndexedFloatSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(StringUtils.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, EntireLayoutIndexedFloatSupplier.this.totalSize));
            }
            for (int i = 0; i < toFill.length; ++i) {
                toFill[i] = this.get(index + i);
            }
        }

        public String toString() {
            return "EntireCompressedIndexedFloats_Anonymous{, totalSize=" + EntireLayoutIndexedFloatSupplier.this.totalSize + '}';
        }

        @Override
        public void close() {
        }
    }
}

