/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.FixedSizeCompressedObjectStrategy;

public class CompressedLongBufferObjectStrategy
extends FixedSizeCompressedObjectStrategy<LongBuffer> {
    public static CompressedLongBufferObjectStrategy getBufferForOrder(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        return new CompressedLongBufferObjectStrategy(order, compression, sizePer);
    }

    private CompressedLongBufferObjectStrategy(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        super(order, new CompressedObjectStrategy.BufferConverter<LongBuffer>(){

            @Override
            public LongBuffer convert(ByteBuffer buf) {
                return buf.asLongBuffer();
            }

            @Override
            public int compare(LongBuffer lhs, LongBuffer rhs) {
                return Comparators.naturalNullsFirst().compare(lhs, rhs);
            }

            @Override
            public int sizeOf(int count) {
                return count * 8;
            }

            @Override
            public LongBuffer combine(ByteBuffer into, LongBuffer from) {
                return into.asLongBuffer().put(from);
            }
        }, compression, sizePer);
    }
}

