/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.collections.StupidResourceHolder;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.data.CompressedIntBufferObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.SingleValueIndexedIntsWriter;

public class CompressedIntsIndexedWriter
extends SingleValueIndexedIntsWriter {
    private static final byte VERSION = 2;
    private final int chunkFactor;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private final GenericIndexedWriter<ResourceHolder<IntBuffer>> flattener;
    private IntBuffer endBuffer;
    private int numInserted;

    public static CompressedIntsIndexedWriter create(IOPeon ioPeon, String filenameBase, CompressedObjectStrategy.CompressionStrategy compression) {
        return new CompressedIntsIndexedWriter(ioPeon, filenameBase, 16384, IndexIO.BYTE_ORDER, compression);
    }

    public CompressedIntsIndexedWriter(IOPeon ioPeon, String filenameBase, int chunkFactor, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression) {
        this(chunkFactor, compression, new GenericIndexedWriter<ResourceHolder<IntBuffer>>(ioPeon, filenameBase, CompressedIntBufferObjectStrategy.getBufferForOrder(byteOrder, compression, chunkFactor)));
    }

    public CompressedIntsIndexedWriter(int chunkFactor, CompressedObjectStrategy.CompressionStrategy compression, GenericIndexedWriter<ResourceHolder<IntBuffer>> flattener) {
        this.chunkFactor = chunkFactor;
        this.compression = compression;
        this.endBuffer = IntBuffer.allocate(chunkFactor);
        this.numInserted = 0;
        this.flattener = flattener;
    }

    @Override
    public void open() throws IOException {
        this.flattener.open();
    }

    @Override
    protected void addValue(int val) throws IOException {
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.flattener.write(StupidResourceHolder.create(this.endBuffer));
            this.endBuffer = IntBuffer.allocate(this.chunkFactor);
        }
        this.endBuffer.put(val);
        ++this.numInserted;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.numInserted > 0) {
                this.endBuffer.limit(this.endBuffer.position());
                this.endBuffer.rewind();
                this.flattener.write(StupidResourceHolder.create(this.endBuffer));
            }
            this.endBuffer = null;
        }
        finally {
            this.flattener.close();
        }
    }

    @Override
    public long getSerializedSize() {
        return 10L + this.flattener.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.numInserted)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.chunkFactor)));
        channel.write(ByteBuffer.wrap(new byte[]{this.compression.getId()}));
        this.flattener.writeToChannel(channel, smoosher);
    }
}

