/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.FixedSizeCompressedObjectStrategy;

public class CompressedByteBufferObjectStrategy
extends FixedSizeCompressedObjectStrategy<ByteBuffer> {
    public static CompressedByteBufferObjectStrategy getBufferForOrder(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        return new CompressedByteBufferObjectStrategy(order, compression, sizePer);
    }

    public CompressedByteBufferObjectStrategy(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        super(order, new CompressedObjectStrategy.BufferConverter<ByteBuffer>(){

            @Override
            public ByteBuffer convert(ByteBuffer buf) {
                return buf;
            }

            @Override
            public int compare(ByteBuffer lhs, ByteBuffer rhs) {
                return Comparators.naturalNullsFirst().compare(lhs, rhs);
            }

            @Override
            public int sizeOf(int count) {
                return count;
            }

            @Override
            public ByteBuffer combine(ByteBuffer into, ByteBuffer from) {
                return into.put(from);
            }
        }, compression, sizePer);
    }
}

