/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedDoubles;
import org.apache.hive.druid.io.druid.segment.data.VSizeCompressedObjectStrategy;

public class BlockLayoutIndexedDoubleSupplier
implements Supplier<IndexedDoubles> {
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseDoubleBuffers;
    private final int totalSize;
    private final int sizePer;

    public BlockLayoutIndexedDoubleSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy strategy, SmooshedFileMapper fileMapper) {
        this.baseDoubleBuffers = GenericIndexed.read(fromBuffer, VSizeCompressedObjectStrategy.getBufferForOrder(byteOrder, strategy, sizePer * 8), fileMapper);
        this.totalSize = totalSize;
        this.sizePer = sizePer;
    }

    @Override
    public IndexedDoubles get() {
        return new BlockLayoutIndexedDoubles();
    }

    private class BlockLayoutIndexedDoubles
    implements IndexedDoubles {
        final Indexed<ResourceHolder<ByteBuffer>> resourceHolderIndexed;
        int currIndex;
        ResourceHolder<ByteBuffer> holder;
        ByteBuffer buffer;
        DoubleBuffer doubleBuffer;

        private BlockLayoutIndexedDoubles() {
            this.resourceHolderIndexed = BlockLayoutIndexedDoubleSupplier.this.baseDoubleBuffers.singleThreaded();
            this.currIndex = -1;
        }

        @Override
        public int size() {
            return BlockLayoutIndexedDoubleSupplier.this.totalSize;
        }

        @Override
        public double get(int index) {
            int bufferNum = index / BlockLayoutIndexedDoubleSupplier.this.sizePer;
            int bufferIndex = index % BlockLayoutIndexedDoubleSupplier.this.sizePer;
            if (bufferNum != this.currIndex) {
                this.loadBuffer(bufferNum);
            }
            return this.doubleBuffer.get(this.doubleBuffer.position() + bufferIndex);
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.resourceHolderIndexed.get(bufferNum);
            this.buffer = this.holder.get();
            this.doubleBuffer = this.buffer.asDoubleBuffer();
            this.currIndex = bufferNum;
        }

        @Override
        public void fill(int index, double[] toFill) {
            if (BlockLayoutIndexedDoubleSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(String.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, BlockLayoutIndexedDoubleSupplier.this.totalSize));
            }
            for (int i = 0; i < toFill.length; ++i) {
                toFill[i] = this.get(index + i);
            }
        }

        @Override
        public void close() {
            if (this.holder != null) {
                this.holder.close();
            }
        }

        public String toString() {
            return "BlockCompressedIndexedDoubles_Anonymous{currIndex=" + this.currIndex + ", sizePer=" + BlockLayoutIndexedDoubleSupplier.this.sizePer + ", numChunks=" + this.resourceHolderIndexed.size() + ", totalSize=" + BlockLayoutIndexedDoubleSupplier.this.totalSize + '}';
        }
    }
}

