/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.column;

import java.io.IOException;
import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelectorUtils;
import org.apache.hive.druid.io.druid.segment.IdLookup;
import org.apache.hive.druid.io.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.data.CachingIndexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedMultivalue;
import org.apache.hive.druid.io.druid.segment.data.ReadableOffset;
import org.apache.hive.druid.io.druid.segment.data.SingleIndexedInt;
import org.apache.hive.druid.io.druid.segment.filter.BooleanValueMatcher;
import org.apache.hive.druid.io.druid.segment.historical.HistoricalDimensionSelector;
import org.apache.hive.druid.io.druid.segment.historical.SingleValueHistoricalDimensionSelector;

public class SimpleDictionaryEncodedColumn
implements DictionaryEncodedColumn<String> {
    private final IndexedInts column;
    private final IndexedMultivalue<IndexedInts> multiValueColumn;
    private final CachingIndexed<String> cachedLookups;

    public SimpleDictionaryEncodedColumn(IndexedInts singleValueColumn, IndexedMultivalue<IndexedInts> multiValueColumn, CachingIndexed<String> cachedLookups) {
        this.column = singleValueColumn;
        this.multiValueColumn = multiValueColumn;
        this.cachedLookups = cachedLookups;
    }

    @Override
    public int length() {
        return this.hasMultipleValues() ? this.multiValueColumn.size() : this.column.size();
    }

    @Override
    public boolean hasMultipleValues() {
        return this.column == null;
    }

    @Override
    public int getSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public IndexedInts getMultiValueRow(int rowNum) {
        return this.multiValueColumn.get(rowNum);
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        return this.cachedLookups.get(id);
    }

    @Override
    public int lookupId(String name) {
        return this.cachedLookups.indexOf(name);
    }

    @Override
    public int getCardinality() {
        return this.cachedLookups.size();
    }

    @Override
    public HistoricalDimensionSelector makeDimensionSelector(final ReadableOffset offset, final ExtractionFn extractionFn) {
        if (this.hasMultipleValues()) {
            class MultiValueDimensionSelector
            extends 1QueryableDimensionSelector {
                MultiValueDimensionSelector() {
                    abstract class QueryableDimensionSelector
                    implements HistoricalDimensionSelector,
                    IdLookup {
                        final /* synthetic */ ExtractionFn val$extractionFn;

                        QueryableDimensionSelector() {
                            this.val$extractionFn = extractionFn;
                        }

                        @Override
                        public int getValueCardinality() {
                            return SimpleDictionaryEncodedColumn.this.getCardinality();
                        }

                        @Override
                        public String lookupName(int id) {
                            String value = SimpleDictionaryEncodedColumn.this.lookupName(id);
                            return this.val$extractionFn == null ? value : this.val$extractionFn.apply(value);
                        }

                        @Override
                        public boolean nameLookupPossibleInAdvance() {
                            return true;
                        }

                        @Override
                        @Nullable
                        public IdLookup idLookup() {
                            return this.val$extractionFn == null ? this : null;
                        }

                        @Override
                        public int lookupId(String name) {
                            if (this.val$extractionFn != null) {
                                throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                            }
                            return SimpleDictionaryEncodedColumn.this.lookupId(name);
                        }
                    }
                    super(SimpleDictionaryEncodedColumn.this, extractionFn2);
                }

                @Override
                public IndexedInts getRow() {
                    return SimpleDictionaryEncodedColumn.this.multiValueColumn.get(offset.getOffset());
                }

                @Override
                public IndexedInts getRow(int offset2) {
                    return SimpleDictionaryEncodedColumn.this.multiValueColumn.get(offset2);
                }

                @Override
                public ValueMatcher makeValueMatcher(String value) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
                }

                @Override
                public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("multiValueColumn", SimpleDictionaryEncodedColumn.this.multiValueColumn);
                    inspector.visit("offset", offset);
                    inspector.visit("extractionFn", extractionFn);
                }
            }
            return new MultiValueDimensionSelector();
        }
        class SingleValueQueryableDimensionSelector
        extends 1QueryableDimensionSelector
        implements SingleValueHistoricalDimensionSelector {
            SingleValueQueryableDimensionSelector() {
                super(SimpleDictionaryEncodedColumn.this, extractionFn2);
            }

            @Override
            public IndexedInts getRow() {
                return new SingleIndexedInt(this.getRowValue());
            }

            @Override
            public int getRowValue() {
                return SimpleDictionaryEncodedColumn.this.column.get(offset.getOffset());
            }

            @Override
            public IndexedInts getRow(int offset2) {
                return new SingleIndexedInt(this.getRowValue(offset2));
            }

            @Override
            public int getRowValue(int offset2) {
                return SimpleDictionaryEncodedColumn.this.column.get(offset2);
            }

            @Override
            public ValueMatcher makeValueMatcher(String value) {
                if (extractionFn == null) {
                    final int valueId = this.lookupId(value);
                    if (valueId >= 0) {
                        return new ValueMatcher(){

                            @Override
                            public boolean matches() {
                                return this.getRowValue() == valueId;
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                                inspector.visit("column", SimpleDictionaryEncodedColumn.this);
                            }
                        };
                    }
                    return BooleanValueMatcher.of(false);
                }
                return this.makeValueMatcher(Predicates.equalTo(value));
            }

            @Override
            public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                final BitSet predicateMatchingValueIds = DimensionSelectorUtils.makePredicateMatchingSet(this, predicate);
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        return predicateMatchingValueIds.get(this.getRowValue());
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("column", SimpleDictionaryEncodedColumn.this);
                    }
                };
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", SimpleDictionaryEncodedColumn.this.column);
                inspector.visit("offset", offset);
                inspector.visit("extractionFn", extractionFn);
            }
        }
        return new SingleValueQueryableDimensionSelector();
    }

    @Override
    public void close() throws IOException {
        CloseQuietly.close(this.cachedLookups);
        if (this.column != null) {
            this.column.close();
        }
        if (this.multiValueColumn != null) {
            this.multiValueColumn.close();
        }
    }
}

