/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.IdLookup;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.SingleValueDimensionSelector;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.SingleIndexedInt;

public class SingleScanTimeDimSelector
implements SingleValueDimensionSelector {
    private final ExtractionFn extractionFn;
    private final LongColumnSelector selector;
    private final boolean descending;
    private final List<String> timeValues = new ArrayList<String>();
    private String currentValue = null;
    private long currentTimestamp = Long.MIN_VALUE;
    private int index = -1;

    public SingleScanTimeDimSelector(LongColumnSelector selector, ExtractionFn extractionFn, boolean descending) {
        if (extractionFn == null) {
            throw new UnsupportedOperationException("time dimension must provide an extraction function");
        }
        this.extractionFn = extractionFn;
        this.selector = selector;
        this.descending = descending;
    }

    @Override
    public IndexedInts getRow() {
        return new SingleIndexedInt(this.getDimensionValueIndex());
    }

    @Override
    public int getRowValue() {
        return this.getDimensionValueIndex();
    }

    @Override
    public ValueMatcher makeValueMatcher(final String value) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return Objects.equals(SingleScanTimeDimSelector.this.lookupName(SingleScanTimeDimSelector.this.getDimensionValueIndex()), value);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", SingleScanTimeDimSelector.this);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return predicate.apply(SingleScanTimeDimSelector.this.lookupName(SingleScanTimeDimSelector.this.getDimensionValueIndex()));
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", SingleScanTimeDimSelector.this);
                inspector.visit("predicate", predicate);
            }
        };
    }

    private int getDimensionValueIndex() {
        long timestamp = this.selector.getLong();
        if (this.index < 0) {
            this.currentTimestamp = timestamp;
            this.currentValue = this.extractionFn.apply(timestamp);
            ++this.index;
            this.timeValues.add(this.currentValue);
        } else if (timestamp != this.currentTimestamp) {
            if (this.descending ? timestamp > this.currentTimestamp : timestamp < this.currentTimestamp) {
                throw new IllegalStateException("cannot re-use time dimension selector for multiple scans");
            }
            this.currentTimestamp = timestamp;
            String value = this.extractionFn.apply(timestamp);
            if (!Objects.equals(value, this.currentValue)) {
                this.currentValue = value;
                ++this.index;
                this.timeValues.add(this.currentValue);
            }
        }
        return this.index;
    }

    @Override
    public int getValueCardinality() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String lookupName(int id) {
        if (id == this.index) {
            return this.currentValue;
        }
        return this.timeValues.get(id);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return false;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("extractionFn", this.extractionFn);
        inspector.visit("descending", this.descending);
    }
}

