/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.IdLookup;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.ZeroIndexedInts;
import org.apache.hive.druid.io.druid.segment.filter.BooleanValueMatcher;
import org.apache.hive.druid.io.druid.segment.historical.SingleValueHistoricalDimensionSelector;

public class NullDimensionSelector
implements SingleValueHistoricalDimensionSelector,
IdLookup {
    private static final NullDimensionSelector INSTANCE = new NullDimensionSelector();

    private NullDimensionSelector() {
    }

    public static NullDimensionSelector instance() {
        return INSTANCE;
    }

    @Override
    public IndexedInts getRow() {
        return ZeroIndexedInts.instance();
    }

    @Override
    public int getRowValue() {
        return 0;
    }

    @Override
    public int getRowValue(int offset) {
        return 0;
    }

    @Override
    public IndexedInts getRow(int offset) {
        return this.getRow();
    }

    @Override
    public ValueMatcher makeValueMatcher(String value) {
        return BooleanValueMatcher.of(value == null);
    }

    @Override
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        return BooleanValueMatcher.of(predicate.apply(null));
    }

    @Override
    public int getValueCardinality() {
        return 1;
    }

    @Override
    public String lookupName(int id) {
        assert (id == 0) : "id = " + id;
        return null;
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this;
    }

    @Override
    public int lookupId(String name) {
        return NullHandlingHelper.isNullOrDefault(name) ? 0 : -1;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }
}

