/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.ByteBufferWriter;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.DoubleSupplierSerializer;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;

public class DoubleColumnSerializer
implements GenericColumnSerializer {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ByteOrder byteOrder;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private DoubleSupplierSerializer writer;
    private ByteBufferWriter<ImmutableBitmap> nullValueBitmapWriter;
    private MutableBitmap nullRowsBitmap;
    private int rowCount = 0;

    public static DoubleColumnSerializer create(IOPeon ioPeon, String filenameBase, CompressedObjectStrategy.CompressionStrategy compression, BitmapSerdeFactory bitmapSerdeFactory) {
        return new DoubleColumnSerializer(ioPeon, filenameBase, IndexIO.BYTE_ORDER, compression, bitmapSerdeFactory);
    }

    public DoubleColumnSerializer(IOPeon ioPeon, String filenameBase, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression, BitmapSerdeFactory bitmapSerdeFactory) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.byteOrder = byteOrder;
        this.compression = compression;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressionFactory.getDoubleSerializer(this.ioPeon, StringUtils.format("%s.double_column", this.filenameBase), this.byteOrder, this.compression);
        this.writer.open();
        this.nullValueBitmapWriter = new ByteBufferWriter<ImmutableBitmap>(this.ioPeon, StringUtils.format("%s.nullBitmap", this.filenameBase), this.bitmapSerdeFactory.getObjectStrategy());
        this.nullValueBitmapWriter.open();
        this.nullRowsBitmap = this.bitmapSerdeFactory.getBitmapFactory().makeEmptyMutableBitmap();
    }

    @Override
    public void serialize(@Nullable Object obj) throws IOException {
        if (obj == null) {
            this.nullRowsBitmap.add(this.rowCount);
            this.writer.add(0.0);
        } else {
            this.writer.add(((Number)obj).doubleValue());
        }
        ++this.rowCount;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.nullValueBitmapWriter.write(this.bitmapSerdeFactory.getBitmapFactory().makeImmutableBitmap(this.nullRowsBitmap));
        this.nullValueBitmapWriter.close();
    }

    @Override
    public long getSerializedSize() {
        long bitmapSize = this.nullRowsBitmap.isEmpty() ? 0L : this.nullValueBitmapWriter.getSerializedSize();
        return 4L + this.writer.getSerializedSize() + bitmapSize;
    }

    @Override
    public void writeToChannel(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.writer.getSerializedSize())));
        this.writer.writeToChannel(channel, smoosher);
        if (!this.nullRowsBitmap.isEmpty()) {
            this.nullValueBitmapWriter.writeToChannel(channel, smoosher);
        }
    }
}

