/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeseries;

import java.util.List;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.QueryRunnerHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultBuilder;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.SegmentMissingException;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.filter.Filters;

public class TimeseriesQueryEngine {
    public Sequence<Result<TimeseriesResultValue>> process(final TimeseriesQuery query, StorageAdapter adapter) {
        if (adapter == null) {
            throw new SegmentMissingException("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimensionsFilter()));
        return QueryRunnerHelper.makeCursorBasedQuery(adapter, query.getQuerySegmentSpec().getIntervals(), filter, query.getVirtualColumns(), query.isDescending(), query.getGranularity(), new Function<Cursor, Result<TimeseriesResultValue>>(){
            private final boolean skipEmptyBuckets;
            private final List<AggregatorFactory> aggregatorSpecs;
            {
                this.skipEmptyBuckets = query.isSkipEmptyBuckets();
                this.aggregatorSpecs = query.getAggregatorSpecs();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Result<TimeseriesResultValue> apply(Cursor cursor) {
                Aggregator[] aggregators = new Aggregator[this.aggregatorSpecs.size()];
                String[] aggregatorNames = new String[this.aggregatorSpecs.size()];
                for (int i = 0; i < this.aggregatorSpecs.size(); ++i) {
                    aggregators[i] = this.aggregatorSpecs.get(i).factorize(cursor.getColumnSelectorFactory());
                    aggregatorNames[i] = this.aggregatorSpecs.get(i).getName();
                }
                if (this.skipEmptyBuckets && cursor.isDone()) {
                    return null;
                }
                try {
                    Result<TimeseriesResultValue> retVal;
                    while (!cursor.isDone()) {
                        for (Aggregator aggregator : aggregators) {
                            aggregator.aggregate();
                        }
                        cursor.advance();
                    }
                    TimeseriesResultBuilder bob = new TimeseriesResultBuilder(cursor.getTime());
                    for (int i = 0; i < this.aggregatorSpecs.size(); ++i) {
                        bob.addMetric(aggregatorNames[i], aggregators[i]);
                    }
                    Result<TimeseriesResultValue> result = retVal = bob.build();
                    return result;
                }
                finally {
                    for (Aggregator agg : aggregators) {
                        agg.close();
                    }
                }
            }
        });
    }
}

