/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.select;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.QueryRunnerHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.dimension.ColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.select.EventHolder;
import org.apache.hive.druid.io.druid.query.select.PagingOffset;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.select.SelectQueryConfig;
import org.apache.hive.druid.io.druid.query.select.SelectResultValue;
import org.apache.hive.druid.io.druid.query.select.SelectResultValueBuilder;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.apache.hive.druid.io.druid.timeline.DataSegmentUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class SelectQueryEngine {
    private static final SelectStrategyFactory STRATEGY_FACTORY = new SelectStrategyFactory();
    private final Supplier<SelectQueryConfig> configSupplier;

    @Inject
    public SelectQueryEngine(Supplier<SelectQueryConfig> configSupplier) {
        this.configSupplier = configSupplier;
    }

    public Sequence<Result<SelectResultValue>> process(final SelectQuery query, Segment segment) {
        StorageAdapter adapter = segment.asStorageAdapter();
        if (adapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        String dataSource = Iterables.getOnlyElement(query.getDataSource().getNames());
        final List<DimensionSpec> dims = query.getDimensions() == null || query.getDimensions().isEmpty() ? DefaultDimensionSpec.toSpec(adapter.getAvailableDimensions()) : query.getDimensions();
        final Iterable<String> metrics = query.getMetrics() == null || query.getMetrics().isEmpty() ? adapter.getAvailableMetrics() : query.getMetrics();
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        Preconditions.checkArgument(intervals.size() == 1, "Can only handle a single interval, got[%s]", intervals);
        final String segmentId = DataSegmentUtils.withInterval(dataSource, segment.getIdentifier(), intervals.get(0));
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimensionsFilter()));
        return QueryRunnerHelper.makeCursorBasedQuery(adapter, query.getQuerySegmentSpec().getIntervals(), filter, query.getVirtualColumns(), query.isDescending(), query.getGranularity(), new Function<Cursor, Result<SelectResultValue>>(){

            @Override
            public Result<SelectResultValue> apply(Cursor cursor) {
                SelectResultValueBuilder builder = new SelectResultValueBuilder(cursor.getTime(), query.getPagingSpec(), query.isDescending());
                LongColumnSelector timestampColumnSelector = cursor.getColumnSelectorFactory().makeLongColumnSelector("__time");
                List<ColumnSelectorPlus<SelectColumnSelectorStrategy>> selectorPlusList = Arrays.asList(DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, Lists.newArrayList(dims), cursor.getColumnSelectorFactory()));
                for (Object dimSpec : dims) {
                    builder.addDimension(dimSpec.getOutputName());
                }
                HashMap<String, ObjectColumnSelector> metSelectors = Maps.newHashMap();
                for (String metric : metrics) {
                    ObjectColumnSelector metricSelector = cursor.getColumnSelectorFactory().makeObjectColumnSelector(metric);
                    metSelectors.put(metric, metricSelector);
                    builder.addMetric(metric);
                }
                PagingOffset offset = query.getPagingOffset(segmentId);
                cursor.advanceTo(offset.startDelta());
                int lastOffset = offset.startOffset();
                while (!cursor.isDone() && offset.hasNext()) {
                    Map<String, Object> theEvent = SelectQueryEngine.singleEvent("timestamp", timestampColumnSelector, selectorPlusList, metSelectors);
                    lastOffset = offset.current();
                    builder.addEntry(new EventHolder(segmentId, lastOffset, theEvent));
                    cursor.advance();
                    offset.next();
                }
                builder.finished(segmentId, lastOffset);
                return builder.build();
            }
        });
    }

    public static Map<String, Object> singleEvent(String timestampKey, LongColumnSelector timestampColumnSelector, List<ColumnSelectorPlus<SelectColumnSelectorStrategy>> selectorPlusList, Map<String, ObjectColumnSelector> metSelectors) {
        LinkedHashMap<String, Object> theEvent = Maps.newLinkedHashMap();
        theEvent.put(timestampKey, new DateTime(timestampColumnSelector.getLong()));
        for (ColumnSelectorPlus<SelectColumnSelectorStrategy> columnSelectorPlus : selectorPlusList) {
            columnSelectorPlus.getColumnSelectorStrategy().addRowValuesToSelectResult(columnSelectorPlus.getOutputName(), columnSelectorPlus.getSelector(), theEvent);
        }
        for (Map.Entry entry : metSelectors.entrySet()) {
            String metric = (String)entry.getKey();
            ObjectColumnSelector selector = (ObjectColumnSelector)entry.getValue();
            if (selector == null) {
                theEvent.put(metric, null);
                continue;
            }
            theEvent.put(metric, selector.get());
        }
        return theEvent;
    }

    public static class DoubleSelectColumnSelectorStrategy
    implements SelectColumnSelectorStrategy<DoubleColumnSelector> {
        @Override
        public void addRowValuesToSelectResult(String outputName, DoubleColumnSelector dimSelector, Map<String, Object> resultMap) {
            if (dimSelector == null) {
                resultMap.put(outputName, null);
            } else {
                resultMap.put(outputName, dimSelector.getDouble());
            }
        }
    }

    public static class FloatSelectColumnSelectorStrategy
    implements SelectColumnSelectorStrategy<FloatColumnSelector> {
        @Override
        public void addRowValuesToSelectResult(String outputName, FloatColumnSelector dimSelector, Map<String, Object> resultMap) {
            if (dimSelector == null) {
                resultMap.put(outputName, null);
            } else {
                resultMap.put(outputName, Float.valueOf(dimSelector.getFloat()));
            }
        }
    }

    public static class LongSelectColumnSelectorStrategy
    implements SelectColumnSelectorStrategy<LongColumnSelector> {
        @Override
        public void addRowValuesToSelectResult(String outputName, LongColumnSelector dimSelector, Map<String, Object> resultMap) {
            if (dimSelector == null) {
                resultMap.put(outputName, null);
            } else {
                resultMap.put(outputName, dimSelector.getLong());
            }
        }
    }

    public static class StringSelectColumnSelectorStrategy
    implements SelectColumnSelectorStrategy<DimensionSelector> {
        @Override
        public void addRowValuesToSelectResult(String outputName, DimensionSelector selector, Map<String, Object> resultMap) {
            if (selector == null) {
                resultMap.put(outputName, null);
            } else {
                IndexedInts vals = selector.getRow();
                if (vals.size() == 1) {
                    String dimVal = selector.lookupName(vals.get(0));
                    resultMap.put(outputName, dimVal);
                } else {
                    ArrayList<String> dimVals = new ArrayList<String>(vals.size());
                    for (int i = 0; i < vals.size(); ++i) {
                        dimVals.add(selector.lookupName(vals.get(i)));
                    }
                    resultMap.put(outputName, dimVals);
                }
            }
        }
    }

    public static interface SelectColumnSelectorStrategy<ValueSelectorType extends ColumnValueSelector>
    extends ColumnSelectorStrategy {
        public void addRowValuesToSelectResult(String var1, ValueSelectorType var2, Map<String, Object> var3);
    }

    public static class SelectStrategyFactory
    implements ColumnSelectorStrategyFactory<SelectColumnSelectorStrategy> {
        @Override
        public SelectColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
            ValueType type = capabilities.getType();
            switch (type) {
                case STRING: {
                    return new StringSelectColumnSelectorStrategy();
                }
                case LONG: {
                    return new LongSelectColumnSelectorStrategy();
                }
                case FLOAT: {
                    return new FloatSelectColumnSelectorStrategy();
                }
                case DOUBLE: {
                    return new DoubleSelectColumnSelectorStrategy();
                }
            }
            throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
        }
    }
}

