/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.select;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.select.PagingOffset;
import org.apache.hive.druid.io.druid.query.select.PagingSpec;
import org.apache.hive.druid.io.druid.query.select.SelectResultValue;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;

@JsonTypeName(value="select")
public class SelectQuery
extends BaseQuery<Result<SelectResultValue>> {
    private final DimFilter dimFilter;
    private final Granularity granularity;
    private final List<DimensionSpec> dimensions;
    private final List<String> metrics;
    private final VirtualColumns virtualColumns;
    private final PagingSpec pagingSpec;

    @JsonCreator
    public SelectQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="descending") boolean descending, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") Granularity granularity, @JsonProperty(value="dimensions") List<DimensionSpec> dimensions, @JsonProperty(value="metrics") List<String> metrics, @JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="pagingSpec") PagingSpec pagingSpec, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, descending, context);
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.dimensions = dimensions;
        this.virtualColumns = VirtualColumns.nullToEmpty(virtualColumns);
        this.metrics = metrics;
        this.pagingSpec = pagingSpec;
        Preconditions.checkNotNull(pagingSpec, "must specify a pagingSpec");
        Preconditions.checkArgument(this.checkPagingSpec(pagingSpec, descending), "invalid pagingSpec");
    }

    private boolean checkPagingSpec(PagingSpec pagingSpec, boolean descending) {
        for (Integer value : pagingSpec.getPagingIdentifiers().values()) {
            if (!(descending ^ value < 0)) continue;
            return false;
        }
        return pagingSpec.getThreshold() >= 0;
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return "select";
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public Granularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty
    public List<DimensionSpec> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public PagingSpec getPagingSpec() {
        return this.pagingSpec;
    }

    @JsonProperty
    public List<String> getMetrics() {
        return this.metrics;
    }

    @JsonProperty
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    public PagingOffset getPagingOffset(String identifier) {
        return this.pagingSpec.getOffset(identifier, this.isDescending());
    }

    public SelectQuery withQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
        return Druids.SelectQueryBuilder.copy(this).intervals(querySegmentSpec).build();
    }

    @Override
    public Query<Result<SelectResultValue>> withDataSource(DataSource dataSource) {
        return Druids.SelectQueryBuilder.copy(this).dataSource(dataSource).build();
    }

    public SelectQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        Map<String, Object> newContext = SelectQuery.computeOverriddenContext(this.getContext(), contextOverrides);
        return Druids.SelectQueryBuilder.copy(this).context(newContext).build();
    }

    public SelectQuery withPagingSpec(PagingSpec pagingSpec) {
        return Druids.SelectQueryBuilder.copy(this).pagingSpec(pagingSpec).build();
    }

    public SelectQuery withDimFilter(DimFilter dimFilter) {
        return Druids.SelectQueryBuilder.copy(this).filters(dimFilter).build();
    }

    public String toString() {
        return "SelectQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", descending=" + this.isDescending() + ", dimFilter=" + this.dimFilter + ", granularity=" + this.granularity + ", dimensions=" + this.dimensions + ", metrics=" + this.metrics + ", virtualColumns=" + this.virtualColumns + ", pagingSpec=" + this.pagingSpec + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SelectQuery that = (SelectQuery)o;
        if (!Objects.equals(this.dimFilter, that.dimFilter)) {
            return false;
        }
        if (!Objects.equals(this.granularity, that.granularity)) {
            return false;
        }
        if (!Objects.equals(this.dimensions, that.dimensions)) {
            return false;
        }
        if (!Objects.equals(this.metrics, that.metrics)) {
            return false;
        }
        if (!Objects.equals(this.virtualColumns, that.virtualColumns)) {
            return false;
        }
        return Objects.equals(this.pagingSpec, that.pagingSpec);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dimFilter != null ? this.dimFilter.hashCode() : 0);
        result = 31 * result + (this.granularity != null ? this.granularity.hashCode() : 0);
        result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
        result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
        result = 31 * result + (this.virtualColumns != null ? this.virtualColumns.hashCode() : 0);
        result = 31 * result + (this.pagingSpec != null ? this.pagingSpec.hashCode() : 0);
        return result;
    }
}

