/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.having;

import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.common.guava.SettableSupplier;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.groupby.RowBasedColumnSelectorFactory;
import org.apache.hive.druid.io.druid.query.groupby.having.BaseHavingSpec;
import org.apache.hive.druid.io.druid.segment.column.ValueType;

public class DimFilterHavingSpec
extends BaseHavingSpec {
    private final DimFilter dimFilter;
    private final SettableSupplier<Row> rowSupplier;
    private ValueMatcher valueMatcher;
    private int evalCount;

    @JsonCreator
    public DimFilterHavingSpec(@JsonProperty(value="filter") DimFilter dimFilter) {
        this.dimFilter = Preconditions.checkNotNull(dimFilter, "filter");
        this.rowSupplier = new SettableSupplier();
    }

    @JsonProperty(value="filter")
    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    @Override
    public void setRowSignature(Map<String, ValueType> rowSignature) {
        this.valueMatcher = this.dimFilter.toFilter().makeMatcher(RowBasedColumnSelectorFactory.create(this.rowSupplier, rowSignature));
    }

    @Override
    public boolean eval(Row row) {
        int oldEvalCount = this.evalCount++;
        this.rowSupplier.set(row);
        boolean retVal = this.valueMatcher.matches();
        if (this.evalCount != oldEvalCount + 1) {
            throw new IllegalStateException("concurrent 'eval' calls not permitted!");
        }
        return retVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimFilterHavingSpec that = (DimFilterHavingSpec)o;
        return this.dimFilter.equals(that.dimFilter);
    }

    public int hashCode() {
        return this.dimFilter.hashCode();
    }

    public String toString() {
        return "DimFilterHavingSpec{dimFilter=" + this.dimFilter + '}';
    }
}

