/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.granularity.AllGranularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.ColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.RowBasedColumnSelectorFactory;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.ConcurrentGrouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.SpillingGrouper;
import org.apache.hive.druid.io.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategyV2;
import org.apache.hive.druid.io.druid.query.ordering.StringComparator;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.joda.time.DateTime;

public class RowBasedGrouperHelper {
    private static final InputRawSupplierColumnSelectorStrategyFactory STRATEGY_FACTORY = new InputRawSupplierColumnSelectorStrategyFactory();

    public static Pair<Grouper<RowBasedKey>, Accumulator<AggregateResult, Row>> createGrouperAccumulatorPair(GroupByQuery query, boolean isInputRaw, Map<String, ValueType> rawInputRowSignature, GroupByQueryConfig config, Supplier<ByteBuffer> bufferSupplier, int concurrencyHint, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, AggregatorFactory[] aggregatorFactories) {
        Preconditions.checkArgument(concurrencyHint >= 1 || concurrencyHint == -1, "invalid concurrencyHint");
        List<ValueType> valueTypes = DimensionHandlerUtils.getValueTypesFromDimensionSpecs(query.getDimensions());
        GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        boolean includeTimestamp = GroupByStrategyV2.getUniversalTimestamp(query) == null;
        final ThreadLocal columnSelectorRow = new ThreadLocal();
        ColumnSelectorFactory columnSelectorFactory = query.getVirtualColumns().wrap(RowBasedColumnSelectorFactory.create(columnSelectorRow, rawInputRowSignature));
        boolean willApplyLimitPushDown = query.isApplyLimitPushDown();
        DefaultLimitSpec limitSpec = willApplyLimitPushDown ? (DefaultLimitSpec)query.getLimitSpec() : null;
        boolean sortHasNonGroupingFields = false;
        if (willApplyLimitPushDown) {
            sortHasNonGroupingFields = DefaultLimitSpec.sortingOrderHasNonGroupingFields(limitSpec, query.getDimensions());
        }
        RowBasedKeySerdeFactory keySerdeFactory = new RowBasedKeySerdeFactory(includeTimestamp, query.getContextSortByDimsFirst(), query.getDimensions(), querySpecificConfig.getMaxMergingDictionarySize() / (long)(concurrencyHint == -1 ? 1 : concurrencyHint), valueTypes, aggregatorFactories, limitSpec);
        final Grouper<RowBasedKey> grouper = concurrencyHint == -1 ? new SpillingGrouper<RowBasedKey>(bufferSupplier, keySerdeFactory, columnSelectorFactory, aggregatorFactories, querySpecificConfig.getBufferGrouperMaxSize(), querySpecificConfig.getBufferGrouperMaxLoadFactor(), querySpecificConfig.getBufferGrouperInitialBuckets(), temporaryStorage, spillMapper, true, limitSpec, sortHasNonGroupingFields) : new ConcurrentGrouper<RowBasedKey>(bufferSupplier, keySerdeFactory, columnSelectorFactory, aggregatorFactories, querySpecificConfig.getBufferGrouperMaxSize(), querySpecificConfig.getBufferGrouperMaxLoadFactor(), querySpecificConfig.getBufferGrouperInitialBuckets(), temporaryStorage, spillMapper, concurrencyHint, limitSpec, sortHasNonGroupingFields);
        final int keySize = includeTimestamp ? query.getDimensions().size() + 1 : query.getDimensions().size();
        final ValueExtractFunction valueExtractFn = RowBasedGrouperHelper.makeValueExtractFunction(query, isInputRaw, includeTimestamp, columnSelectorFactory, valueTypes);
        Accumulator<AggregateResult, Row> accumulator = new Accumulator<AggregateResult, Row>(){

            @Override
            public AggregateResult accumulate(AggregateResult priorResult, Row row) {
                BaseQuery.checkInterrupted();
                if (priorResult != null && !priorResult.isOk()) {
                    return priorResult;
                }
                if (!grouper.isInitialized()) {
                    grouper.init();
                }
                columnSelectorRow.set(row);
                Object[] key = new Comparable[keySize];
                valueExtractFn.apply(row, (Comparable[])key);
                AggregateResult aggregateResult = grouper.aggregate(new RowBasedKey(key));
                columnSelectorRow.set(null);
                return aggregateResult;
            }
        };
        return new Pair<Grouper<RowBasedKey>, Accumulator<AggregateResult, Row>>(grouper, accumulator);
    }

    private static TimestampExtractFunction makeTimestampExtractFunction(final GroupByQuery query, boolean isInputRaw) {
        if (isInputRaw) {
            if (query.getGranularity() instanceof AllGranularity) {
                return new TimestampExtractFunction(){

                    @Override
                    public long apply(Row row) {
                        return query.getIntervals().get(0).getStartMillis();
                    }
                };
            }
            return new TimestampExtractFunction(){

                @Override
                public long apply(Row row) {
                    return query.getGranularity().bucketStart(row.getTimestamp()).getMillis();
                }
            };
        }
        return new TimestampExtractFunction(){

            @Override
            public long apply(Row row) {
                return row.getTimestampFromEpoch();
            }
        };
    }

    private static ValueExtractFunction makeValueExtractFunction(final GroupByQuery query, boolean isInputRaw, boolean includeTimestamp, ColumnSelectorFactory columnSelectorFactory, List<ValueType> valueTypes) {
        final TimestampExtractFunction timestampExtractFn = includeTimestamp ? RowBasedGrouperHelper.makeTimestampExtractFunction(query, isInputRaw) : null;
        final Function[] valueConvertFns = RowBasedGrouperHelper.makeValueConvertFunctions(valueTypes);
        if (isInputRaw) {
            final Supplier[] inputRawSuppliers = RowBasedGrouperHelper.getValueSuppliersForDimensions(columnSelectorFactory, query.getDimensions());
            if (includeTimestamp) {
                return new ValueExtractFunction(){

                    @Override
                    public Comparable[] apply(Row row, Comparable[] key) {
                        key[0] = Long.valueOf(timestampExtractFn.apply(row));
                        for (int i = 1; i < key.length; ++i) {
                            Comparable val = (Comparable)inputRawSuppliers[i - 1].get();
                            key[i] = (Comparable)valueConvertFns[i - 1].apply(val);
                        }
                        return key;
                    }
                };
            }
            return new ValueExtractFunction(){

                @Override
                public Comparable[] apply(Row row, Comparable[] key) {
                    for (int i = 0; i < key.length; ++i) {
                        Comparable val = (Comparable)inputRawSuppliers[i].get();
                        key[i] = (Comparable)valueConvertFns[i].apply(val);
                    }
                    return key;
                }
            };
        }
        if (includeTimestamp) {
            return new ValueExtractFunction(){

                @Override
                public Comparable[] apply(Row row, Comparable[] key) {
                    key[0] = Long.valueOf(timestampExtractFn.apply(row));
                    for (int i = 1; i < key.length; ++i) {
                        Comparable val = (Comparable)row.getRaw(query.getDimensions().get(i - 1).getOutputName());
                        key[i] = (Comparable)valueConvertFns[i - 1].apply(val);
                    }
                    return key;
                }
            };
        }
        return new ValueExtractFunction(){

            @Override
            public Comparable[] apply(Row row, Comparable[] key) {
                for (int i = 0; i < key.length; ++i) {
                    Comparable val = (Comparable)row.getRaw(query.getDimensions().get(i).getOutputName());
                    key[i] = (Comparable)valueConvertFns[i].apply(val);
                }
                return key;
            }
        };
    }

    public static CloseableGrouperIterator<RowBasedKey, Row> makeGrouperIterator(Grouper<RowBasedKey> grouper, final GroupByQuery query, Closeable closeable) {
        final boolean includeTimestamp = GroupByStrategyV2.getUniversalTimestamp(query) == null;
        return new CloseableGrouperIterator<RowBasedKey, Row>(grouper, true, new Function<Grouper.Entry<RowBasedKey>, Row>(){

            @Override
            public Row apply(Grouper.Entry<RowBasedKey> entry) {
                int i;
                int dimStart;
                DateTime timestamp;
                LinkedHashMap<String, Object> theMap = Maps.newLinkedHashMap();
                if (includeTimestamp) {
                    timestamp = query.getGranularity().toDateTime((Long)entry.getKey().getKey()[0]);
                    dimStart = 1;
                } else {
                    timestamp = null;
                    dimStart = 0;
                }
                for (i = dimStart; i < entry.getKey().getKey().length; ++i) {
                    Object dimVal = entry.getKey().getKey()[i];
                    theMap.put(query.getDimensions().get(i - dimStart).getOutputName(), dimVal instanceof String ? NullHandlingHelper.defaultToNull((String)dimVal) : dimVal);
                }
                for (i = 0; i < entry.getValues().length; ++i) {
                    theMap.put(query.getAggregatorSpecs().get(i).getName(), entry.getValues()[i]);
                }
                return new MapBasedRow(timestamp, theMap);
            }
        }, closeable);
    }

    private static Supplier<Comparable>[] getValueSuppliersForDimensions(ColumnSelectorFactory columnSelectorFactory, List<DimensionSpec> dimensions) {
        Supplier[] inputRawSuppliers = new Supplier[dimensions.size()];
        ColumnSelectorPlus<InputRawSupplierColumnSelectorStrategy>[] selectorPluses = DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, dimensions, columnSelectorFactory);
        for (int i = 0; i < selectorPluses.length; ++i) {
            ColumnSelectorPlus<InputRawSupplierColumnSelectorStrategy> selectorPlus = selectorPluses[i];
            InputRawSupplierColumnSelectorStrategy strategy = selectorPlus.getColumnSelectorStrategy();
            inputRawSuppliers[i] = strategy.makeInputRawSupplier(selectorPlus.getSelector());
        }
        return inputRawSuppliers;
    }

    private static Function<Comparable, Comparable>[] makeValueConvertFunctions(List<ValueType> valueTypes) {
        Function[] functions = new Function[valueTypes.size()];
        block6: for (int i = 0; i < functions.length; ++i) {
            ValueType type = valueTypes.get(i);
            type = type == null ? ValueType.STRING : type;
            switch (type) {
                case STRING: {
                    functions[i] = input -> DimensionHandlerUtils.convertObjectToString(input);
                    continue block6;
                }
                case LONG: {
                    functions[i] = input -> DimensionHandlerUtils.convertObjectToLong(input);
                    continue block6;
                }
                case FLOAT: {
                    functions[i] = input -> DimensionHandlerUtils.convertObjectToFloat(input);
                    continue block6;
                }
                case DOUBLE: {
                    functions[i] = input -> DimensionHandlerUtils.convertObjectToDouble(input);
                    continue block6;
                }
                default: {
                    throw new IAE("invalid type: [%s]", new Object[]{type});
                }
            }
        }
        return functions;
    }

    private static class RowBasedKeySerde
    implements Grouper.KeySerde<RowBasedKey> {
        private static final int ROUGH_OVERHEAD_PER_DICTIONARY_ENTRY = 44;
        private final boolean includeTimestamp;
        private final boolean sortByDimsFirst;
        private final List<DimensionSpec> dimensions;
        private final int dimCount;
        private final int keySize;
        private final ByteBuffer keyBuffer;
        private final List<String> dictionary = Lists.newArrayList();
        private final Map<String, Integer> reverseDictionary = Maps.newHashMap();
        private final List<RowBasedKeySerdeHelper> serdeHelpers;
        private final DefaultLimitSpec limitSpec;
        private final List<ValueType> valueTypes;
        private final long maxDictionarySize;
        private long currentEstimatedSize = 0L;
        private int[] sortableIds = null;

        RowBasedKeySerde(boolean includeTimestamp, boolean sortByDimsFirst, List<DimensionSpec> dimensions, long maxDictionarySize, DefaultLimitSpec limitSpec, List<ValueType> valueTypes) {
            this.includeTimestamp = includeTimestamp;
            this.sortByDimsFirst = sortByDimsFirst;
            this.dimensions = dimensions;
            this.dimCount = dimensions.size();
            this.maxDictionarySize = maxDictionarySize;
            this.valueTypes = valueTypes;
            this.limitSpec = limitSpec;
            this.serdeHelpers = this.makeSerdeHelpers();
            this.keySize = (includeTimestamp ? 8 : 0) + this.getTotalKeySize();
            this.keyBuffer = ByteBuffer.allocate(this.keySize);
        }

        @Override
        public int keySize() {
            return this.keySize;
        }

        @Override
        public Class<RowBasedKey> keyClazz() {
            return RowBasedKey.class;
        }

        @Override
        public ByteBuffer toByteBuffer(RowBasedKey key) {
            int dimStart;
            this.keyBuffer.rewind();
            if (this.includeTimestamp) {
                this.keyBuffer.putLong((Long)key.getKey()[0]);
                dimStart = 1;
            } else {
                dimStart = 0;
            }
            for (int i = dimStart; i < key.getKey().length; ++i) {
                if (this.serdeHelpers.get(i - dimStart).putToKeyBuffer(key, i)) continue;
                return null;
            }
            this.keyBuffer.flip();
            return this.keyBuffer;
        }

        @Override
        public RowBasedKey fromByteBuffer(ByteBuffer buffer, int position) {
            int dimStart;
            int dimsPosition;
            Object[] key;
            if (this.includeTimestamp) {
                key = new Comparable[this.dimCount + 1];
                key[0] = Long.valueOf(buffer.getLong(position));
                dimsPosition = position + 8;
                dimStart = 1;
            } else {
                key = new Comparable[this.dimCount];
                dimsPosition = position;
                dimStart = 0;
            }
            for (int i = dimStart; i < key.length; ++i) {
                this.serdeHelpers.get(i - dimStart).getFromByteBuffer(buffer, dimsPosition, i, (Comparable[])key);
            }
            return new RowBasedKey(key);
        }

        @Override
        public Grouper.BufferComparator bufferComparator() {
            if (this.sortableIds == null) {
                TreeMap<String, Integer> sortedMap = Maps.newTreeMap(Comparators.naturalNullsFirst());
                for (int id = 0; id < this.dictionary.size(); ++id) {
                    sortedMap.put(this.dictionary.get(id), id);
                }
                this.sortableIds = new int[this.dictionary.size()];
                int index = 0;
                for (Integer id : sortedMap.values()) {
                    this.sortableIds[id.intValue()] = index++;
                }
            }
            if (this.includeTimestamp) {
                if (this.sortByDimsFirst) {
                    return new Grouper.BufferComparator(){

                        @Override
                        public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                            int cmp = RowBasedKeySerde.compareDimsInBuffersForNullFudgeTimestamp(serdeHelpers, sortableIds, dimCount, lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return Longs.compare(lhsBuffer.getLong(lhsPosition), rhsBuffer.getLong(rhsPosition));
                        }
                    };
                }
                return new Grouper.BufferComparator(){

                    @Override
                    public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                        int timeCompare = Longs.compare(lhsBuffer.getLong(lhsPosition), rhsBuffer.getLong(rhsPosition));
                        if (timeCompare != 0) {
                            return timeCompare;
                        }
                        return RowBasedKeySerde.compareDimsInBuffersForNullFudgeTimestamp(serdeHelpers, sortableIds, dimCount, lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                    }
                };
            }
            return new Grouper.BufferComparator(){

                @Override
                public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                    for (int i = 0; i < dimCount; ++i) {
                        int cmp = ((RowBasedKeySerdeHelper)serdeHelpers.get(i)).compare(lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
            };
        }

        @Override
        public Grouper.BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] aggregatorFactories, int[] aggregatorOffsets) {
            final ArrayList<Boolean> needsReverses = Lists.newArrayList();
            ArrayList<RowBasedKeySerdeHelper> orderByHelpers = new ArrayList<RowBasedKeySerdeHelper>();
            ArrayList<RowBasedKeySerdeHelper> otherDimHelpers = new ArrayList<RowBasedKeySerdeHelper>();
            HashSet<Integer> orderByIndices = new HashSet<Integer>();
            int aggCount = 0;
            for (OrderByColumnSpec orderSpec : this.limitSpec.getColumns()) {
                RowBasedKeySerdeHelper serdeHelper;
                boolean needsReverse = orderSpec.getDirection() != OrderByColumnSpec.Direction.ASCENDING;
                int dimIndex = OrderByColumnSpec.getDimIndexForOrderBy(orderSpec, this.dimensions);
                if (dimIndex >= 0) {
                    RowBasedKeySerdeHelper serdeHelper2 = this.serdeHelpers.get(dimIndex);
                    orderByHelpers.add(serdeHelper2);
                    orderByIndices.add(dimIndex);
                    needsReverses.add(needsReverse);
                    continue;
                }
                int aggIndex = OrderByColumnSpec.getAggIndexForOrderBy(orderSpec, Arrays.asList(aggregatorFactories));
                if (aggIndex < 0) continue;
                StringComparator cmp = orderSpec.getDimensionComparator();
                boolean cmpIsNumeric = cmp == StringComparators.NUMERIC;
                String typeName = aggregatorFactories[aggIndex].getTypeName();
                int aggOffset = aggregatorOffsets[aggIndex] - 4;
                ++aggCount;
                if (typeName.equals("long")) {
                    serdeHelper = cmpIsNumeric ? new LongRowBasedKeySerdeHelper(aggOffset) : new LimitPushDownLongRowBasedKeySerdeHelper(aggOffset, cmp);
                } else if (typeName.equals("float")) {
                    serdeHelper = cmpIsNumeric ? new FloatRowBasedKeySerdeHelper(aggOffset) : new LimitPushDownFloatRowBasedKeySerdeHelper(aggOffset, cmp);
                } else if (typeName.equals("double")) {
                    serdeHelper = cmpIsNumeric ? new DoubleRowBasedKeySerdeHelper(aggOffset) : new LimitPushDownDoubleRowBasedKeySerdeHelper(aggOffset, cmp);
                } else {
                    throw new IAE("Cannot order by a non-numeric aggregator[%s]", orderSpec);
                }
                orderByHelpers.add(serdeHelper);
                needsReverses.add(needsReverse);
            }
            for (int i = 0; i < this.dimCount; ++i) {
                if (orderByIndices.contains(i)) continue;
                otherDimHelpers.add(this.serdeHelpers.get(i));
                needsReverses.add(false);
            }
            final ArrayList<RowBasedKeySerdeHelper> adjustedSerdeHelpers = orderByHelpers;
            adjustedSerdeHelpers.addAll(otherDimHelpers);
            final int fieldCount = this.dimCount + aggCount;
            if (this.includeTimestamp) {
                if (this.sortByDimsFirst) {
                    return new Grouper.BufferComparator(){

                        @Override
                        public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                            int cmp = RowBasedKeySerde.compareDimsInBuffersForNullFudgeTimestampForPushDown(adjustedSerdeHelpers, needsReverses, fieldCount, lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return Longs.compare(lhsBuffer.getLong(lhsPosition), rhsBuffer.getLong(rhsPosition));
                        }
                    };
                }
                return new Grouper.BufferComparator(){

                    @Override
                    public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                        int timeCompare = Longs.compare(lhsBuffer.getLong(lhsPosition), rhsBuffer.getLong(rhsPosition));
                        if (timeCompare != 0) {
                            return timeCompare;
                        }
                        int cmp = RowBasedKeySerde.compareDimsInBuffersForNullFudgeTimestampForPushDown(adjustedSerdeHelpers, needsReverses, fieldCount, lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                        return cmp;
                    }
                };
            }
            return new Grouper.BufferComparator(){

                @Override
                public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                    for (int i = 0; i < fieldCount; ++i) {
                        int cmp = (Boolean)needsReverses.get(i) != false ? ((RowBasedKeySerdeHelper)adjustedSerdeHelpers.get(i)).compare(rhsBuffer, lhsBuffer, rhsPosition, lhsPosition) : ((RowBasedKeySerdeHelper)adjustedSerdeHelpers.get(i)).compare(lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
            };
        }

        private static int compareDimsInBuffersForNullFudgeTimestamp(List<RowBasedKeySerdeHelper> serdeHelpers, int[] sortableIds, int dimCount, ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
            for (int i = 0; i < dimCount; ++i) {
                int cmp = serdeHelpers.get(i).compare(lhsBuffer, rhsBuffer, lhsPosition + 8, rhsPosition + 8);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        private static int compareDimsInBuffersForNullFudgeTimestampForPushDown(List<RowBasedKeySerdeHelper> serdeHelpers, List<Boolean> needsReverses, int dimCount, ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
            for (int i = 0; i < dimCount; ++i) {
                int cmp = needsReverses.get(i) != false ? serdeHelpers.get(i).compare(rhsBuffer, lhsBuffer, rhsPosition + 8, lhsPosition + 8) : serdeHelpers.get(i).compare(lhsBuffer, rhsBuffer, lhsPosition + 8, rhsPosition + 8);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        @Override
        public void reset() {
            this.dictionary.clear();
            this.reverseDictionary.clear();
            this.sortableIds = null;
            this.currentEstimatedSize = 0L;
        }

        private int addToDictionary(String s) {
            Integer idx = this.reverseDictionary.get(s);
            if (idx == null) {
                long additionalEstimatedSize = (long)(s == null ? 0 : s.length()) * 2L + 44L;
                if (this.currentEstimatedSize + additionalEstimatedSize > this.maxDictionarySize) {
                    return -1;
                }
                idx = this.dictionary.size();
                this.reverseDictionary.put(s, idx);
                this.dictionary.add(s);
                this.currentEstimatedSize += additionalEstimatedSize;
            }
            return idx;
        }

        private int getTotalKeySize() {
            int size = 0;
            for (RowBasedKeySerdeHelper helper : this.serdeHelpers) {
                size += helper.getKeyBufferValueSize();
            }
            return size;
        }

        private List<RowBasedKeySerdeHelper> makeSerdeHelpers() {
            if (this.limitSpec != null) {
                return this.makeSerdeHelpersForLimitPushDown();
            }
            ArrayList<RowBasedKeySerdeHelper> helpers = new ArrayList<RowBasedKeySerdeHelper>();
            int keyBufferPosition = 0;
            for (ValueType valType : this.valueTypes) {
                RowBasedKeySerdeHelper helper;
                switch (valType) {
                    case STRING: {
                        helper = new StringRowBasedKeySerdeHelper(keyBufferPosition);
                        break;
                    }
                    case LONG: {
                        helper = new LongRowBasedKeySerdeHelper(keyBufferPosition);
                        break;
                    }
                    case FLOAT: {
                        helper = new FloatRowBasedKeySerdeHelper(keyBufferPosition);
                        break;
                    }
                    case DOUBLE: {
                        helper = new DoubleRowBasedKeySerdeHelper(keyBufferPosition);
                        break;
                    }
                    default: {
                        throw new IAE("invalid type: %s", new Object[]{valType});
                    }
                }
                keyBufferPosition += helper.getKeyBufferValueSize();
                helpers.add(helper);
            }
            return helpers;
        }

        private List<RowBasedKeySerdeHelper> makeSerdeHelpersForLimitPushDown() {
            ArrayList<RowBasedKeySerdeHelper> helpers = new ArrayList<RowBasedKeySerdeHelper>();
            int keyBufferPosition = 0;
            for (int i = 0; i < this.valueTypes.size(); ++i) {
                RowBasedKeySerdeHelper helper;
                ValueType valType = this.valueTypes.get(i);
                String dimName = this.dimensions.get(i).getOutputName();
                StringComparator cmp = DefaultLimitSpec.getComparatorForDimName(this.limitSpec, dimName);
                boolean cmpIsNumeric = cmp == StringComparators.NUMERIC;
                switch (valType) {
                    case STRING: {
                        if (cmp == null) {
                            cmp = StringComparators.LEXICOGRAPHIC;
                        }
                        helper = new LimitPushDownStringRowBasedKeySerdeHelper(keyBufferPosition, cmp);
                        break;
                    }
                    case LONG: {
                        if (cmp == null || cmpIsNumeric) {
                            helper = new LongRowBasedKeySerdeHelper(keyBufferPosition);
                            break;
                        }
                        helper = new LimitPushDownLongRowBasedKeySerdeHelper(keyBufferPosition, cmp);
                        break;
                    }
                    case FLOAT: {
                        if (cmp == null || cmpIsNumeric) {
                            helper = new FloatRowBasedKeySerdeHelper(keyBufferPosition);
                            break;
                        }
                        helper = new LimitPushDownFloatRowBasedKeySerdeHelper(keyBufferPosition, cmp);
                        break;
                    }
                    case DOUBLE: {
                        if (cmp == null || cmpIsNumeric) {
                            helper = new DoubleRowBasedKeySerdeHelper(keyBufferPosition);
                            break;
                        }
                        helper = new LimitPushDownDoubleRowBasedKeySerdeHelper(keyBufferPosition, cmp);
                        break;
                    }
                    default: {
                        throw new IAE("invalid type: %s", new Object[]{valType});
                    }
                }
                keyBufferPosition += helper.getKeyBufferValueSize();
                helpers.add(helper);
            }
            return helpers;
        }

        private class LimitPushDownDoubleRowBasedKeySerdeHelper
        extends DoubleRowBasedKeySerdeHelper {
            final StringComparator cmp;

            public LimitPushDownDoubleRowBasedKeySerdeHelper(int keyBufferPosition, StringComparator cmp) {
                super(keyBufferPosition);
                this.cmp = cmp;
            }

            @Override
            public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                Double lhs = this.readFromBuffer(lhsBuffer, lhsPosition);
                Double rhs = this.readFromBuffer(rhsBuffer, rhsPosition);
                return this.cmp.compare(String.valueOf(lhs), String.valueOf(rhs));
            }
        }

        private class DoubleRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;

            public DoubleRowBasedKeySerdeHelper(int keyBufferPosition) {
                this.keyBufferPosition = keyBufferPosition;
            }

            @Override
            public int getKeyBufferValueSize() {
                return 9;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                Double aDouble = (Double)key.getKey()[idx];
                RowBasedKeySerde.this.keyBuffer.put(aDouble == null ? (byte)1 : 0);
                RowBasedKeySerde.this.keyBuffer.putDouble(DimensionHandlerUtils.nullToZero(aDouble));
                return true;
            }

            protected Double readFromBuffer(ByteBuffer buffer, int initialOffset) {
                if (buffer.get(initialOffset + this.keyBufferPosition) == 1) {
                    return NullHandlingHelper.nullToDefault((Double)null);
                }
                return buffer.getDouble(initialOffset + this.keyBufferPosition + 1);
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Comparable[] dimValues) {
                dimValues[dimValIdx] = this.readFromBuffer(buffer, initialOffset);
            }

            @Override
            public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                return Objects.compare(this.readFromBuffer(lhsBuffer, lhsPosition), this.readFromBuffer(rhsBuffer, rhsPosition), Comparators.naturalNullsFirst());
            }
        }

        private class LimitPushDownFloatRowBasedKeySerdeHelper
        extends FloatRowBasedKeySerdeHelper {
            final StringComparator cmp;

            public LimitPushDownFloatRowBasedKeySerdeHelper(int keyBufferPosition, StringComparator cmp) {
                super(keyBufferPosition);
                this.cmp = cmp;
            }

            @Override
            public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                Float lhs = this.readFromBuffer(lhsBuffer, lhsPosition);
                Float rhs = this.readFromBuffer(rhsBuffer, rhsPosition);
                return this.cmp.compare(String.valueOf(lhs), String.valueOf(rhs));
            }
        }

        private class FloatRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;

            public FloatRowBasedKeySerdeHelper(int keyBufferPosition) {
                this.keyBufferPosition = keyBufferPosition;
            }

            @Override
            public int getKeyBufferValueSize() {
                return 5;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                Float aFloat = (Float)key.getKey()[idx];
                RowBasedKeySerde.this.keyBuffer.put(aFloat == null ? (byte)1 : 0);
                RowBasedKeySerde.this.keyBuffer.putFloat(DimensionHandlerUtils.nullToZero(aFloat).floatValue());
                return true;
            }

            protected Float readFromBuffer(ByteBuffer buffer, int initialOffset) {
                if (buffer.get(initialOffset + this.keyBufferPosition) == 1) {
                    return NullHandlingHelper.nullToDefault((Float)null);
                }
                return Float.valueOf(buffer.getFloat(initialOffset + this.keyBufferPosition + 1));
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Comparable[] dimValues) {
                dimValues[dimValIdx] = this.readFromBuffer(buffer, initialOffset);
            }

            @Override
            public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                return Objects.compare(this.readFromBuffer(lhsBuffer, lhsPosition), this.readFromBuffer(rhsBuffer, rhsPosition), Comparators.naturalNullsFirst());
            }
        }

        private class LimitPushDownLongRowBasedKeySerdeHelper
        extends LongRowBasedKeySerdeHelper {
            final StringComparator cmp;

            public LimitPushDownLongRowBasedKeySerdeHelper(int keyBufferPosition, StringComparator cmp) {
                super(keyBufferPosition);
                this.cmp = cmp;
            }

            @Override
            public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                Long lhs = this.readFromBuffer(lhsBuffer, lhsPosition);
                Long rhs = this.readFromBuffer(rhsBuffer, rhsPosition);
                return this.cmp.compare(String.valueOf(lhs), String.valueOf(rhs));
            }
        }

        private class LongRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;

            public LongRowBasedKeySerdeHelper(int keyBufferPosition) {
                this.keyBufferPosition = keyBufferPosition;
            }

            @Override
            public int getKeyBufferValueSize() {
                return 9;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                Long aLong = (Long)key.getKey()[idx];
                RowBasedKeySerde.this.keyBuffer.put(aLong == null ? (byte)1 : 0);
                RowBasedKeySerde.this.keyBuffer.putLong(DimensionHandlerUtils.nullToZero(aLong));
                return true;
            }

            protected Long readFromBuffer(ByteBuffer buffer, int initialOffset) {
                if (buffer.get(initialOffset + this.keyBufferPosition) == 1) {
                    return NullHandlingHelper.nullToDefault((Long)null);
                }
                return buffer.getLong(initialOffset + this.keyBufferPosition + 1);
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Comparable[] dimValues) {
                dimValues[dimValIdx] = this.readFromBuffer(buffer, initialOffset);
            }

            @Override
            public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                return Objects.compare(this.readFromBuffer(lhsBuffer, lhsPosition), this.readFromBuffer(rhsBuffer, rhsPosition), Comparators.naturalNullsFirst());
            }
        }

        private class LimitPushDownStringRowBasedKeySerdeHelper
        extends StringRowBasedKeySerdeHelper {
            final StringComparator cmp;

            public LimitPushDownStringRowBasedKeySerdeHelper(int keyBufferPosition, StringComparator cmp) {
                super(keyBufferPosition);
                this.cmp = cmp;
            }

            @Override
            public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                String lhsStr = (String)RowBasedKeySerde.this.dictionary.get(lhsBuffer.getInt(lhsPosition + this.keyBufferPosition));
                String rhsStr = (String)RowBasedKeySerde.this.dictionary.get(rhsBuffer.getInt(rhsPosition + this.keyBufferPosition));
                return this.cmp.compare(lhsStr, rhsStr);
            }
        }

        private class StringRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;

            public StringRowBasedKeySerdeHelper(int keyBufferPosition) {
                this.keyBufferPosition = keyBufferPosition;
            }

            @Override
            public int getKeyBufferValueSize() {
                return 4;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                int id = RowBasedKeySerde.this.addToDictionary((String)key.getKey()[idx]);
                if (id < 0) {
                    return false;
                }
                RowBasedKeySerde.this.keyBuffer.putInt(id);
                return true;
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Comparable[] dimValues) {
                int index = buffer.getInt(initialOffset + this.keyBufferPosition);
                String str = (String)RowBasedKeySerde.this.dictionary.get(index);
                dimValues[dimValIdx] = (Comparable)RowBasedKeySerde.this.dictionary.get(buffer.getInt(initialOffset + this.keyBufferPosition));
            }

            @Override
            public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                return Ints.compare(RowBasedKeySerde.this.sortableIds[lhsBuffer.getInt(lhsPosition + this.keyBufferPosition)], RowBasedKeySerde.this.sortableIds[rhsBuffer.getInt(rhsPosition + this.keyBufferPosition)]);
            }
        }

        private static interface RowBasedKeySerdeHelper {
            public int getKeyBufferValueSize();

            public boolean putToKeyBuffer(RowBasedKey var1, int var2);

            public void getFromByteBuffer(ByteBuffer var1, int var2, int var3, Comparable[] var4);

            public int compare(ByteBuffer var1, ByteBuffer var2, int var3, int var4);
        }
    }

    private static class RowBasedKeySerdeFactory
    implements Grouper.KeySerdeFactory<RowBasedKey> {
        private final boolean includeTimestamp;
        private final boolean sortByDimsFirst;
        private final int dimCount;
        private final long maxDictionarySize;
        private final DefaultLimitSpec limitSpec;
        private final List<DimensionSpec> dimensions;
        final AggregatorFactory[] aggregatorFactories;
        private final List<ValueType> valueTypes;

        RowBasedKeySerdeFactory(boolean includeTimestamp, boolean sortByDimsFirst, List<DimensionSpec> dimensions, long maxDictionarySize, List<ValueType> valueTypes, AggregatorFactory[] aggregatorFactories, DefaultLimitSpec limitSpec) {
            this.includeTimestamp = includeTimestamp;
            this.sortByDimsFirst = sortByDimsFirst;
            this.dimensions = dimensions;
            this.dimCount = dimensions.size();
            this.maxDictionarySize = maxDictionarySize;
            this.limitSpec = limitSpec;
            this.aggregatorFactories = aggregatorFactories;
            this.valueTypes = valueTypes;
        }

        @Override
        public Grouper.KeySerde<RowBasedKey> factorize() {
            return new RowBasedKeySerde(this.includeTimestamp, this.sortByDimsFirst, this.dimensions, this.maxDictionarySize, this.limitSpec, this.valueTypes);
        }

        @Override
        public Comparator<Grouper.Entry<RowBasedKey>> objectComparator(boolean forceDefaultOrder) {
            if (this.limitSpec != null && !forceDefaultOrder) {
                return this.objectComparatorWithAggs();
            }
            if (this.includeTimestamp) {
                if (this.sortByDimsFirst) {
                    return new Comparator<Grouper.Entry<RowBasedKey>>(){

                        @Override
                        public int compare(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2) {
                            int cmp = RowBasedKeySerdeFactory.compareDimsInRows(entry1.getKey(), entry2.getKey(), 1);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return Longs.compare((Long)entry1.getKey().getKey()[0], (Long)entry2.getKey().getKey()[0]);
                        }
                    };
                }
                return new Comparator<Grouper.Entry<RowBasedKey>>(){

                    @Override
                    public int compare(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2) {
                        int timeCompare = Longs.compare((Long)entry1.getKey().getKey()[0], (Long)entry2.getKey().getKey()[0]);
                        if (timeCompare != 0) {
                            return timeCompare;
                        }
                        return RowBasedKeySerdeFactory.compareDimsInRows(entry1.getKey(), entry2.getKey(), 1);
                    }
                };
            }
            return new Comparator<Grouper.Entry<RowBasedKey>>(){

                @Override
                public int compare(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2) {
                    return RowBasedKeySerdeFactory.compareDimsInRows(entry1.getKey(), entry2.getKey(), 0);
                }
            };
        }

        private Comparator<Grouper.Entry<RowBasedKey>> objectComparatorWithAggs() {
            final ArrayList<Boolean> needsReverses = Lists.newArrayList();
            final ArrayList<Boolean> aggFlags = Lists.newArrayList();
            final ArrayList<Boolean> isNumericField = Lists.newArrayList();
            final ArrayList<StringComparator> comparators = Lists.newArrayList();
            final ArrayList<Integer> fieldIndices = Lists.newArrayList();
            HashSet<Integer> orderByIndices = new HashSet<Integer>();
            for (OrderByColumnSpec orderSpec : this.limitSpec.getColumns()) {
                boolean needsReverse = orderSpec.getDirection() != OrderByColumnSpec.Direction.ASCENDING;
                int dimIndex = OrderByColumnSpec.getDimIndexForOrderBy(orderSpec, this.dimensions);
                if (dimIndex >= 0) {
                    fieldIndices.add(dimIndex);
                    orderByIndices.add(dimIndex);
                    needsReverses.add(needsReverse);
                    aggFlags.add(false);
                    ValueType type = this.dimensions.get(dimIndex).getOutputType();
                    isNumericField.add(ValueType.isNumeric(type));
                    comparators.add(orderSpec.getDimensionComparator());
                    continue;
                }
                int aggIndex = OrderByColumnSpec.getAggIndexForOrderBy(orderSpec, Arrays.asList(this.aggregatorFactories));
                if (aggIndex < 0) continue;
                fieldIndices.add(aggIndex);
                needsReverses.add(needsReverse);
                aggFlags.add(true);
                String typeName = this.aggregatorFactories[aggIndex].getTypeName();
                isNumericField.add(ValueType.isNumeric(ValueType.fromString(typeName)));
                comparators.add(orderSpec.getDimensionComparator());
            }
            for (int i = 0; i < this.dimCount; ++i) {
                if (orderByIndices.contains(i)) continue;
                fieldIndices.add(i);
                aggFlags.add(false);
                needsReverses.add(false);
                ValueType type = this.dimensions.get(i).getOutputType();
                isNumericField.add(ValueType.isNumeric(type));
                comparators.add(StringComparators.LEXICOGRAPHIC);
            }
            if (this.includeTimestamp) {
                if (this.sortByDimsFirst) {
                    return new Comparator<Grouper.Entry<RowBasedKey>>(){

                        @Override
                        public int compare(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2) {
                            int cmp = RowBasedKeySerdeFactory.compareDimsInRowsWithAggs(entry1, entry2, 1, needsReverses, aggFlags, fieldIndices, isNumericField, comparators);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return Longs.compare((Long)entry1.getKey().getKey()[0], (Long)entry2.getKey().getKey()[0]);
                        }
                    };
                }
                return new Comparator<Grouper.Entry<RowBasedKey>>(){

                    @Override
                    public int compare(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2) {
                        int timeCompare = Longs.compare((Long)entry1.getKey().getKey()[0], (Long)entry2.getKey().getKey()[0]);
                        if (timeCompare != 0) {
                            return timeCompare;
                        }
                        return RowBasedKeySerdeFactory.compareDimsInRowsWithAggs(entry1, entry2, 1, needsReverses, aggFlags, fieldIndices, isNumericField, comparators);
                    }
                };
            }
            return new Comparator<Grouper.Entry<RowBasedKey>>(){

                @Override
                public int compare(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2) {
                    return RowBasedKeySerdeFactory.compareDimsInRowsWithAggs(entry1, entry2, 0, needsReverses, aggFlags, fieldIndices, isNumericField, comparators);
                }
            };
        }

        private static int compareDimsInRows(RowBasedKey key1, RowBasedKey key2, int dimStart) {
            for (int i = dimStart; i < key1.getKey().length; ++i) {
                int cmp = Comparators.naturalNullsFirst().compare((Comparable)key1.getKey()[i], (Comparable)key2.getKey()[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        private static int compareDimsInRowsWithAggs(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2, int dimStart, List<Boolean> needsReverses, List<Boolean> aggFlags, List<Integer> fieldIndices, List<Boolean> isNumericField, List<StringComparator> comparators) {
            for (int i = 0; i < fieldIndices.size(); ++i) {
                Comparable rhs;
                Comparable lhs;
                int fieldIndex = fieldIndices.get(i);
                boolean needsReverse = needsReverses.get(i);
                if (aggFlags.get(i).booleanValue()) {
                    if (needsReverse) {
                        lhs = (Comparable)entry2.getValues()[fieldIndex];
                        rhs = (Comparable)entry1.getValues()[fieldIndex];
                    } else {
                        lhs = (Comparable)entry1.getValues()[fieldIndex];
                        rhs = (Comparable)entry2.getValues()[fieldIndex];
                    }
                } else if (needsReverse) {
                    lhs = (Comparable)entry2.getKey().getKey()[fieldIndex + dimStart];
                    rhs = (Comparable)entry1.getKey().getKey()[fieldIndex + dimStart];
                } else {
                    lhs = (Comparable)entry1.getKey().getKey()[fieldIndex + dimStart];
                    rhs = (Comparable)entry2.getKey().getKey()[fieldIndex + dimStart];
                }
                StringComparator comparator = comparators.get(i);
                int cmp = isNumericField.get(i) != false && comparator == StringComparators.NUMERIC ? Comparators.naturalNullsFirst().compare(lhs, rhs) : comparator.compare(DimensionHandlerUtils.convertObjectToString(lhs), DimensionHandlerUtils.convertObjectToString(rhs));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }

    private static class InputRawSupplierColumnSelectorStrategyFactory
    implements ColumnSelectorStrategyFactory<InputRawSupplierColumnSelectorStrategy> {
        private InputRawSupplierColumnSelectorStrategyFactory() {
        }

        @Override
        public InputRawSupplierColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
            ValueType type = capabilities.getType();
            switch (type) {
                case STRING: {
                    return new StringInputRawSupplierColumnSelectorStrategy();
                }
                case LONG: {
                    return columnSelector -> columnSelector::getLong;
                }
                case FLOAT: {
                    return columnSelector -> columnSelector::getFloat;
                }
                case DOUBLE: {
                    return columnSelector -> columnSelector::getDouble;
                }
            }
            throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
        }
    }

    private static class StringInputRawSupplierColumnSelectorStrategy
    implements InputRawSupplierColumnSelectorStrategy<DimensionSelector> {
        private StringInputRawSupplierColumnSelectorStrategy() {
        }

        @Override
        public Supplier<Comparable> makeInputRawSupplier(DimensionSelector selector) {
            return () -> {
                IndexedInts index = selector.getRow();
                return index.size() == 0 ? null : selector.lookupName(index.get(0));
            };
        }
    }

    private static interface InputRawSupplierColumnSelectorStrategy<ValueSelectorType>
    extends ColumnSelectorStrategy {
        public Supplier<Comparable> makeInputRawSupplier(ValueSelectorType var1);
    }

    static class RowBasedKey {
        private final Object[] key;

        RowBasedKey(Object[] key) {
            this.key = key;
        }

        @JsonCreator
        public static RowBasedKey fromJsonArray(Object[] key) {
            for (int i = 0; i < key.length; ++i) {
                if (key[i] instanceof Integer) {
                    key[i] = ((Integer)key[i]).longValue();
                    continue;
                }
                if (!(key[i] instanceof Double)) continue;
                key[i] = Float.valueOf(((Double)key[i]).floatValue());
            }
            return new RowBasedKey(key);
        }

        @JsonValue
        public Object[] getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowBasedKey that = (RowBasedKey)o;
            return Arrays.equals(this.key, that.key);
        }

        public int hashCode() {
            return Arrays.hashCode(this.key);
        }

        public String toString() {
            return Arrays.toString(this.key);
        }
    }

    private static interface ValueExtractFunction {
        public Comparable[] apply(Row var1, Comparable[] var2);
    }

    private static interface TimestampExtractFunction {
        public long apply(Row var1);
    }
}

