/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.guava.BaseSequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.BufferArrayGrouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.BufferHashGrouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column.DictionaryBuildingStringGroupByColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column.DoubleGroupByColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column.FloatGroupByColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column.LongGroupByColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.column.StringGroupByColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class GroupByQueryEngineV2 {
    private static final GroupByStrategyFactory STRATEGY_FACTORY = new GroupByStrategyFactory();

    private static GroupByColumnSelectorPlus[] createGroupBySelectorPlus(ColumnSelectorPlus<GroupByColumnSelectorStrategy>[] baseSelectorPlus) {
        GroupByColumnSelectorPlus[] retInfo = new GroupByColumnSelectorPlus[baseSelectorPlus.length];
        int curPos = 0;
        for (int i = 0; i < retInfo.length; ++i) {
            retInfo[i] = new GroupByColumnSelectorPlus(baseSelectorPlus[i], curPos);
            curPos += ((GroupByColumnSelectorStrategy)retInfo[i].getColumnSelectorStrategy()).getGroupingKeySize();
        }
        return retInfo;
    }

    private GroupByQueryEngineV2() {
    }

    public static Sequence<Row> process(final GroupByQuery query, StorageAdapter storageAdapter, NonBlockingPool<ByteBuffer> intermediateResultsBufferPool, GroupByQueryConfig config) {
        if (storageAdapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        if (intervals.size() != 1) {
            throw new IAE("Should only have one interval, got[%s]", intervals);
        }
        Sequence<Cursor> cursors = storageAdapter.makeCursors(Filters.toFilter(query.getDimFilter()), intervals.get(0), query.getVirtualColumns(), query.getGranularity(), false, null);
        boolean allSingleValueDims = query.getDimensions().stream().allMatch(dimension -> {
            ColumnCapabilities columnCapabilities = storageAdapter.getColumnCapabilities(dimension.getDimension());
            return columnCapabilities != null && !columnCapabilities.hasMultipleValues();
        });
        ResourceHolder<ByteBuffer> bufferHolder = intermediateResultsBufferPool.take();
        String fudgeTimestampString = Strings.emptyToNull(query.getContextValue("fudgeTimestamp", ""));
        DateTime fudgeTimestamp = fudgeTimestampString == null ? null : new DateTime(Long.parseLong(fudgeTimestampString));
        return cursors.flatMap(cursor -> new BaseSequence(new BaseSequence.IteratorMaker<Row, GroupByEngineIterator<?>>((Cursor)cursor, bufferHolder, config, storageAdapter, fudgeTimestamp, allSingleValueDims){
            final /* synthetic */ Cursor val$cursor;
            final /* synthetic */ ResourceHolder val$bufferHolder;
            final /* synthetic */ GroupByQueryConfig val$config;
            final /* synthetic */ StorageAdapter val$storageAdapter;
            final /* synthetic */ DateTime val$fudgeTimestamp;
            final /* synthetic */ boolean val$allSingleValueDims;
            {
                this.val$cursor = cursor;
                this.val$bufferHolder = resourceHolder;
                this.val$config = groupByQueryConfig;
                this.val$storageAdapter = storageAdapter;
                this.val$fudgeTimestamp = dateTime;
                this.val$allSingleValueDims = bl;
            }

            @Override
            public GroupByEngineIterator make() {
                ByteBuffer buffer;
                ColumnSelectorPlus[] selectorPlus = DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, query.getDimensions(), this.val$cursor.getColumnSelectorFactory());
                GroupByColumnSelectorPlus[] dims = GroupByQueryEngineV2.createGroupBySelectorPlus(selectorPlus);
                if (GroupByQueryEngineV2.isArrayAggregateApplicable(this.val$config, query, dims, this.val$storageAdapter, buffer = (ByteBuffer)this.val$bufferHolder.get())) {
                    return new ArrayAggregateIterator(query, this.val$config, this.val$cursor, buffer, this.val$fudgeTimestamp, dims, this.val$allSingleValueDims, dims.length == 0 ? 1 : this.val$storageAdapter.getDimensionCardinality(dims[0].getName()));
                }
                return new HashAggregateIterator(query, this.val$config, this.val$cursor, buffer, this.val$fudgeTimestamp, dims, this.val$allSingleValueDims);
            }

            @Override
            public void cleanup(GroupByEngineIterator iterFromMake) {
                iterFromMake.close();
            }
        })).withBaggage(bufferHolder);
    }

    private static boolean isArrayAggregateApplicable(GroupByQueryConfig config, GroupByQuery query, GroupByColumnSelectorPlus[] dims, StorageAdapter storageAdapter, ByteBuffer buffer) {
        AggregatorFactory[] aggregatorFactories;
        int requiredBufferCapacity;
        int cardinality;
        ColumnCapabilities columnCapabilities;
        if (config.isForceHashAggregation()) {
            return false;
        }
        if (dims.length == 0) {
            columnCapabilities = null;
            cardinality = 1;
        } else if (dims.length == 1) {
            columnCapabilities = storageAdapter.getColumnCapabilities(dims[0].getName());
            cardinality = storageAdapter.getDimensionCardinality(dims[0].getName());
        } else {
            columnCapabilities = null;
            cardinality = -1;
        }
        return (columnCapabilities == null || columnCapabilities.getType().equals((Object)ValueType.STRING)) && cardinality > 0 && (requiredBufferCapacity = BufferArrayGrouper.requiredBufferCapacity(cardinality, aggregatorFactories = query.getAggregatorSpecs().toArray(new AggregatorFactory[query.getAggregatorSpecs().size()]))) <= buffer.capacity();
    }

    private static void convertRowTypesToOutputTypes(List<DimensionSpec> dimensionSpecs, Map<String, Object> rowMap) {
        for (DimensionSpec dimSpec : dimensionSpecs) {
            ValueType outputType = dimSpec.getOutputType();
            rowMap.compute(dimSpec.getOutputName(), (dimName, baseVal) -> {
                switch (outputType) {
                    case STRING: {
                        baseVal = DimensionHandlerUtils.convertObjectToString(baseVal);
                        break;
                    }
                    case LONG: {
                        baseVal = DimensionHandlerUtils.convertObjectToLong(baseVal);
                        break;
                    }
                    case FLOAT: {
                        baseVal = DimensionHandlerUtils.convertObjectToFloat(baseVal);
                        break;
                    }
                    case DOUBLE: {
                        baseVal = DimensionHandlerUtils.convertObjectToDouble(baseVal);
                        break;
                    }
                    default: {
                        throw new IAE("Unsupported type: " + (Object)((Object)outputType), new Object[0]);
                    }
                }
                return baseVal;
            });
        }
    }

    private static class GroupByEngineKeySerde
    implements Grouper.KeySerde<ByteBuffer> {
        private final int keySize;

        public GroupByEngineKeySerde(GroupByColumnSelectorPlus[] dims) {
            int keySize = 0;
            for (GroupByColumnSelectorPlus selectorPlus : dims) {
                keySize += ((GroupByColumnSelectorStrategy)selectorPlus.getColumnSelectorStrategy()).getGroupingKeySize();
            }
            this.keySize = keySize;
        }

        @Override
        public int keySize() {
            return this.keySize;
        }

        @Override
        public Class<ByteBuffer> keyClazz() {
            return ByteBuffer.class;
        }

        @Override
        public ByteBuffer toByteBuffer(ByteBuffer key) {
            return key;
        }

        @Override
        public ByteBuffer fromByteBuffer(ByteBuffer buffer, int position) {
            ByteBuffer dup = buffer.duplicate();
            dup.position(position).limit(position + this.keySize);
            return dup.slice();
        }

        @Override
        public Grouper.BufferComparator bufferComparator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Grouper.BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] aggregatorFactories, int[] aggregatorOffsets) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
        }
    }

    private static class ArrayAggregateIterator
    extends GroupByEngineIterator<Integer> {
        private final int cardinality;
        @Nullable
        private final GroupByColumnSelectorPlus dim;
        private IndexedInts multiValues;
        private int nextValIndex;

        public ArrayAggregateIterator(GroupByQuery query, GroupByQueryConfig config, Cursor cursor, ByteBuffer buffer, DateTime fudgeTimestamp, GroupByColumnSelectorPlus[] dims, boolean allSingleValueDims, int cardinality) {
            super(query, config, cursor, buffer, fudgeTimestamp, dims, allSingleValueDims);
            this.cardinality = cardinality;
            if (dims.length == 1) {
                this.dim = dims[0];
            } else if (dims.length == 0) {
                this.dim = null;
            } else {
                throw new IAE("Group key should be a single dimension", new Object[0]);
            }
        }

        @Override
        protected Grouper<Integer> newGrouper() {
            return new BufferArrayGrouper(Suppliers.ofInstance(this.buffer), this.cursor.getColumnSelectorFactory(), this.query.getAggregatorSpecs().toArray(new AggregatorFactory[this.query.getAggregatorSpecs().size()]), this.cardinality);
        }

        @Override
        protected void aggregateSingleValueDims(Grouper<Integer> grouper) {
            while (!this.cursor.isDone()) {
                int key;
                if (this.dim != null) {
                    IndexedInts indexedInts = ((DimensionSelector)this.dim.getSelector()).getRow();
                    key = this.getSingleValue(indexedInts);
                } else {
                    key = 0;
                }
                if (!grouper.aggregate(key).isOk()) {
                    return;
                }
                this.cursor.advance();
            }
        }

        @Override
        protected void aggregateMultiValueDims(Grouper<Integer> grouper) {
            if (this.dim == null) {
                throw new ISE("dim must exist", new Object[0]);
            }
            if (this.multiValues == null) {
                this.multiValues = ((DimensionSelector)this.dim.getSelector()).getRow();
                this.nextValIndex = 0;
            }
            while (!this.cursor.isDone()) {
                if (this.multiValues.size() == 0) {
                    if (!grouper.aggregate(-1).isOk()) {
                        return;
                    }
                } else {
                    while (this.nextValIndex < this.multiValues.size()) {
                        if (!grouper.aggregate(this.multiValues.get(this.nextValIndex)).isOk()) {
                            return;
                        }
                        ++this.nextValIndex;
                    }
                }
                this.cursor.advance();
                if (this.cursor.isDone()) continue;
                this.multiValues = ((DimensionSelector)this.dim.getSelector()).getRow();
                this.nextValIndex = this.multiValues.size() == 0 ? -1 : 0;
            }
        }

        @Override
        protected void putToMap(Integer key, Map<String, Object> map) {
            if (this.dim != null) {
                if (key != -1) {
                    map.put(this.dim.getOutputName(), ((DimensionSelector)this.dim.getSelector()).lookupName(key));
                } else {
                    map.put(this.dim.getOutputName(), "");
                }
            }
        }
    }

    private static class HashAggregateIterator
    extends GroupByEngineIterator<ByteBuffer> {
        private final int[] stack;
        private final Object[] valuess;
        private final ByteBuffer keyBuffer;
        private int stackPointer = Integer.MIN_VALUE;
        protected boolean currentRowWasPartiallyAggregated = false;

        public HashAggregateIterator(GroupByQuery query, GroupByQueryConfig config, Cursor cursor, ByteBuffer buffer, DateTime fudgeTimestamp, GroupByColumnSelectorPlus[] dims, boolean allSingleValueDims) {
            super(query, config, cursor, buffer, fudgeTimestamp, dims, allSingleValueDims);
            int dimCount = query.getDimensions().size();
            this.stack = new int[dimCount];
            this.valuess = new Object[dimCount];
            this.keyBuffer = ByteBuffer.allocate(this.keySerde.keySize());
        }

        @Override
        protected Grouper<ByteBuffer> newGrouper() {
            return new BufferHashGrouper<ByteBuffer>(Suppliers.ofInstance(this.buffer), this.keySerde, this.cursor.getColumnSelectorFactory(), this.query.getAggregatorSpecs().toArray(new AggregatorFactory[this.query.getAggregatorSpecs().size()]), this.querySpecificConfig.getBufferGrouperMaxSize(), this.querySpecificConfig.getBufferGrouperMaxLoadFactor(), this.querySpecificConfig.getBufferGrouperInitialBuckets());
        }

        @Override
        protected void aggregateSingleValueDims(Grouper<ByteBuffer> grouper) {
            while (!this.cursor.isDone()) {
                for (int i = 0; i < this.dims.length; ++i) {
                    GroupByColumnSelectorStrategy strategy = (GroupByColumnSelectorStrategy)this.dims[i].getColumnSelectorStrategy();
                    strategy.writeToKeyBuffer(this.dims[i].getKeyBufferPosition(), strategy.getOnlyValue(this.dims[i].getSelector()), this.keyBuffer);
                }
                this.keyBuffer.rewind();
                if (!grouper.aggregate(this.keyBuffer).isOk()) {
                    return;
                }
                this.cursor.advance();
            }
        }

        @Override
        protected void aggregateMultiValueDims(Grouper<ByteBuffer> grouper) {
            while (!this.cursor.isDone()) {
                if (!this.currentRowWasPartiallyAggregated) {
                    this.stackPointer = this.stack.length - 1;
                    for (int i = 0; i < this.dims.length; ++i) {
                        GroupByColumnSelectorStrategy strategy = (GroupByColumnSelectorStrategy)this.dims[i].getColumnSelectorStrategy();
                        strategy.initColumnValues(this.dims[i].getSelector(), i, this.valuess);
                        strategy.initGroupingKeyColumnValue(this.dims[i].getKeyBufferPosition(), i, this.valuess[i], this.keyBuffer, this.stack);
                    }
                }
                boolean doAggregate = true;
                while (this.stackPointer >= -1) {
                    if (doAggregate) {
                        this.keyBuffer.rewind();
                        if (!grouper.aggregate(this.keyBuffer).isOk()) {
                            this.currentRowWasPartiallyAggregated = true;
                            return;
                        }
                        doAggregate = false;
                    }
                    if (this.stackPointer >= 0) {
                        doAggregate = ((GroupByColumnSelectorStrategy)this.dims[this.stackPointer].getColumnSelectorStrategy()).checkRowIndexAndAddValueToGroupingKey(this.dims[this.stackPointer].getKeyBufferPosition(), this.valuess[this.stackPointer], this.stack[this.stackPointer], this.keyBuffer);
                        if (doAggregate) {
                            int n = this.stackPointer;
                            this.stack[n] = this.stack[n] + 1;
                            for (int i = this.stackPointer + 1; i < this.stack.length; ++i) {
                                ((GroupByColumnSelectorStrategy)this.dims[i].getColumnSelectorStrategy()).initGroupingKeyColumnValue(this.dims[i].getKeyBufferPosition(), i, this.valuess[i], this.keyBuffer, this.stack);
                            }
                            this.stackPointer = this.stack.length - 1;
                            continue;
                        }
                        --this.stackPointer;
                        continue;
                    }
                    --this.stackPointer;
                }
                this.cursor.advance();
                this.currentRowWasPartiallyAggregated = false;
            }
        }

        @Override
        protected void putToMap(ByteBuffer key, Map<String, Object> map) {
            for (GroupByColumnSelectorPlus selectorPlus : this.dims) {
                ((GroupByColumnSelectorStrategy)selectorPlus.getColumnSelectorStrategy()).processValueFromGroupingKey(selectorPlus, key, map);
            }
        }
    }

    private static abstract class GroupByEngineIterator<KeyType>
    implements Iterator<Row>,
    Closeable {
        protected final GroupByQuery query;
        protected final GroupByQueryConfig querySpecificConfig;
        protected final Cursor cursor;
        protected final ByteBuffer buffer;
        protected final Grouper.KeySerde<ByteBuffer> keySerde;
        protected final GroupByColumnSelectorPlus[] dims;
        protected final DateTime timestamp;
        protected CloseableGrouperIterator<KeyType, Row> delegate = null;
        protected final boolean allSingleValueDims;

        public GroupByEngineIterator(GroupByQuery query, GroupByQueryConfig config, Cursor cursor, ByteBuffer buffer, DateTime fudgeTimestamp, GroupByColumnSelectorPlus[] dims, boolean allSingleValueDims) {
            this.query = query;
            this.querySpecificConfig = config.withOverrides(query);
            this.cursor = cursor;
            this.buffer = buffer;
            this.keySerde = new GroupByEngineKeySerde(dims);
            this.dims = dims;
            this.timestamp = fudgeTimestamp != null ? fudgeTimestamp : cursor.getTime();
            this.allSingleValueDims = allSingleValueDims;
        }

        private CloseableGrouperIterator<KeyType, Row> initNewDelegate() {
            Grouper<KeyType> grouper = this.newGrouper();
            grouper.init();
            if (this.allSingleValueDims) {
                this.aggregateSingleValueDims(grouper);
            } else {
                this.aggregateMultiValueDims(grouper);
            }
            return new CloseableGrouperIterator(grouper, false, entry -> {
                LinkedHashMap<String, Object> theMap = Maps.newLinkedHashMap();
                this.putToMap(entry.getKey(), theMap);
                GroupByQueryEngineV2.convertRowTypesToOutputTypes(this.query.getDimensions(), theMap);
                for (int i = 0; i < entry.getValues().length; ++i) {
                    theMap.put(this.query.getAggregatorSpecs().get(i).getName(), entry.getValues()[i]);
                }
                return new MapBasedRow(this.timestamp, theMap);
            }, grouper);
        }

        @Override
        public Row next() {
            if (this.delegate == null || !this.delegate.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.delegate.next();
        }

        @Override
        public boolean hasNext() {
            if (this.delegate != null && this.delegate.hasNext()) {
                return true;
            }
            if (!this.cursor.isDone()) {
                if (this.delegate != null) {
                    this.delegate.close();
                }
                this.delegate = this.initNewDelegate();
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        protected abstract Grouper<KeyType> newGrouper();

        protected abstract void aggregateSingleValueDims(Grouper<KeyType> var1);

        protected abstract void aggregateMultiValueDims(Grouper<KeyType> var1);

        protected abstract void putToMap(KeyType var1, Map<String, Object> var2);

        protected int getSingleValue(IndexedInts indexedInts) {
            Preconditions.checkArgument(indexedInts.size() < 2, "should be single value");
            return indexedInts.size() == 1 ? indexedInts.get(0) : -1;
        }
    }

    private static class GroupByStrategyFactory
    implements ColumnSelectorStrategyFactory<GroupByColumnSelectorStrategy> {
        private GroupByStrategyFactory() {
        }

        @Override
        public GroupByColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
            ValueType type = capabilities.getType();
            switch (type) {
                case STRING: {
                    DimensionSelector dimSelector = (DimensionSelector)selector;
                    if (dimSelector.getValueCardinality() >= 0) {
                        return new StringGroupByColumnSelectorStrategy();
                    }
                    return new DictionaryBuildingStringGroupByColumnSelectorStrategy();
                }
                case LONG: {
                    return new LongGroupByColumnSelectorStrategy();
                }
                case FLOAT: {
                    return new FloatGroupByColumnSelectorStrategy();
                }
                case DOUBLE: {
                    return new DoubleGroupByColumnSelectorStrategy();
                }
            }
            throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
        }
    }
}

