/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.ByteBufferHashTable;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Groupers;

public abstract class AbstractBufferHashGrouper<KeyType>
implements Grouper<KeyType> {
    protected static final int HASH_SIZE = 4;
    protected static final Logger log = new Logger(AbstractBufferHashGrouper.class);
    protected final Supplier<ByteBuffer> bufferSupplier;
    protected final Grouper.KeySerde<KeyType> keySerde;
    protected final int keySize;
    protected final BufferAggregator[] aggregators;
    protected final int[] aggregatorOffsets;
    protected final int bufferGrouperMaxSize;
    protected float maxLoadFactor;
    protected int initialBuckets;
    protected int bucketSize;
    protected ByteBufferHashTable hashTable;
    protected ByteBuffer hashTableBuffer;

    public AbstractBufferHashGrouper(Supplier<ByteBuffer> bufferSupplier, Grouper.KeySerde<KeyType> keySerde, AggregatorFactory[] aggregatorFactories, int bufferGrouperMaxSize) {
        this.bufferSupplier = bufferSupplier;
        this.keySerde = keySerde;
        this.keySize = keySerde.keySize();
        this.aggregators = new BufferAggregator[aggregatorFactories.length];
        this.aggregatorOffsets = new int[aggregatorFactories.length];
        this.bufferGrouperMaxSize = bufferGrouperMaxSize;
    }

    public abstract void newBucketHook(int var1);

    public abstract boolean canSkipAggregate(boolean var1, int var2);

    public abstract void afterAggregateHook(int var1);

    public int getGrowthCount() {
        return this.hashTable.getGrowthCount();
    }

    public int getSize() {
        return this.hashTable.getSize();
    }

    public int getBuckets() {
        return this.hashTable.getMaxBuckets();
    }

    public int getMaxSize() {
        return this.hashTable.getRegrowthThreshold();
    }

    @Override
    public AggregateResult aggregate(KeyType key, int keyHash) {
        int i;
        ByteBuffer keyBuffer = this.keySerde.toByteBuffer(key);
        if (keyBuffer == null) {
            return Groupers.DICTIONARY_FULL;
        }
        if (keyBuffer.remaining() != this.keySize) {
            throw new IAE("keySerde.toByteBuffer(key).remaining[%s] != keySerde.keySize[%s], buffer was the wrong size?!", keyBuffer.remaining(), this.keySize);
        }
        int bucket = this.hashTable.findBucketWithAutoGrowth(keyBuffer, keyHash);
        if (bucket < 0) {
            return Groupers.HASH_TABLE_FULL;
        }
        int bucketStartOffset = this.hashTable.getOffsetForBucket(bucket);
        boolean bucketWasUsed = this.hashTable.isBucketUsed(bucket);
        ByteBuffer tableBuffer = this.hashTable.getTableBuffer();
        if (!bucketWasUsed) {
            this.hashTable.initializeNewBucketKey(bucket, keyBuffer, keyHash);
            for (i = 0; i < this.aggregators.length; ++i) {
                this.aggregators[i].init(tableBuffer, bucketStartOffset + this.aggregatorOffsets[i]);
            }
            this.newBucketHook(bucketStartOffset);
        }
        if (this.canSkipAggregate(bucketWasUsed, bucketStartOffset)) {
            return AggregateResult.ok();
        }
        for (i = 0; i < this.aggregators.length; ++i) {
            this.aggregators[i].aggregate(tableBuffer, bucketStartOffset + this.aggregatorOffsets[i]);
        }
        this.afterAggregateHook(bucketStartOffset);
        return AggregateResult.ok();
    }

    @Override
    public void close() {
        for (BufferAggregator aggregator : this.aggregators) {
            try {
                aggregator.close();
            }
            catch (Exception e) {
                log.warn(e, "Could not close aggregator, skipping.", aggregator);
            }
        }
    }

    protected Grouper.Entry<KeyType> bucketEntryForOffset(int bucketOffset) {
        ByteBuffer tableBuffer = this.hashTable.getTableBuffer();
        KeyType key = this.keySerde.fromByteBuffer(tableBuffer, bucketOffset + 4);
        Object[] values = new Object[this.aggregators.length];
        for (int i = 0; i < this.aggregators.length; ++i) {
            values[i] = this.aggregators[i].get(tableBuffer, bucketOffset + this.aggregatorOffsets[i]);
        }
        return new Grouper.Entry<KeyType>(key, values);
    }
}

