/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.IdLookup;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.io.druid.segment.SingleValueDimensionSelector;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.RangeIndexedInts;
import org.apache.hive.druid.io.druid.segment.data.ZeroIndexedInts;

public class RowBasedColumnSelectorFactory
implements ColumnSelectorFactory {
    private final Supplier<? extends Row> row;
    private final Map<String, ValueType> rowSignature;

    private RowBasedColumnSelectorFactory(Supplier<? extends Row> row, @Nullable Map<String, ValueType> rowSignature) {
        this.row = row;
        this.rowSignature = rowSignature != null ? rowSignature : ImmutableMap.of();
    }

    public static RowBasedColumnSelectorFactory create(Supplier<? extends Row> row, @Nullable Map<String, ValueType> rowSignature) {
        return new RowBasedColumnSelectorFactory(row, rowSignature);
    }

    public static RowBasedColumnSelectorFactory create(final ThreadLocal<? extends Row> row, @Nullable Map<String, ValueType> rowSignature) {
        return new RowBasedColumnSelectorFactory((Supplier<? extends Row>)new Supplier<Row>(){

            @Override
            public Row get() {
                return (Row)row.get();
            }
        }, rowSignature);
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        final String dimension = dimensionSpec.getDimension();
        final ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        if ("__time".equals(dimensionSpec.getDimension())) {
            if (extractionFn == null) {
                throw new UnsupportedOperationException("time dimension must provide an extraction function");
            }
            return new SingleValueDimensionSelector(){

                @Override
                public IndexedInts getRow() {
                    return ZeroIndexedInts.instance();
                }

                @Override
                public int getRowValue() {
                    return 0;
                }

                @Override
                public ValueMatcher makeValueMatcher(final String value) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            String rowValue = extractionFn.apply(((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch());
                            return Objects.equals(rowValue, value);
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                            inspector.visit("extractionFn", extractionFn);
                        }
                    };
                }

                @Override
                public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            String rowValue = extractionFn.apply(((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch());
                            return predicate.apply(rowValue);
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                            inspector.visit("extractionFn", extractionFn);
                            inspector.visit("predicate", predicate);
                        }
                    };
                }

                @Override
                public int getValueCardinality() {
                    return -1;
                }

                @Override
                public String lookupName(int id) {
                    return extractionFn.apply(((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch());
                }

                @Override
                public boolean nameLookupPossibleInAdvance() {
                    return false;
                }

                @Override
                @Nullable
                public IdLookup idLookup() {
                    return null;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                    inspector.visit("extractionFn", extractionFn);
                }
            };
        }
        return new DimensionSelector(){

            @Override
            public IndexedInts getRow() {
                List<String> dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                return RangeIndexedInts.create(dimensionValues != null ? dimensionValues.size() : 0);
            }

            @Override
            public ValueMatcher makeValueMatcher(final String value) {
                if (extractionFn == null) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            Row row = (Row)RowBasedColumnSelectorFactory.this.row.get();
                            List<String> dimensionValues = row.getDimension(dimension);
                            if (dimensionValues == null || dimensionValues.isEmpty()) {
                                return value == null;
                            }
                            for (String dimensionValue : dimensionValues) {
                                if (!Objects.equals(NullHandlingHelper.defaultToNull(dimensionValue), value)) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                        }
                    };
                }
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        List<String> dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                        if (dimensionValues == null || dimensionValues.isEmpty()) {
                            return value == null;
                        }
                        for (String dimensionValue : dimensionValues) {
                            if (!Objects.equals(extractionFn.apply(NullHandlingHelper.defaultToNull(dimensionValue)), value)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                        inspector.visit("extractionFn", extractionFn);
                    }
                };
            }

            @Override
            public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                final boolean matchNull = predicate.apply(null);
                if (extractionFn == null) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            List<String> dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                            if (dimensionValues == null || dimensionValues.isEmpty()) {
                                return matchNull;
                            }
                            for (String dimensionValue : dimensionValues) {
                                if (!predicate.apply(NullHandlingHelper.defaultToNull(dimensionValue))) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                            inspector.visit("predicate", predicate);
                        }
                    };
                }
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        List<String> dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                        if (dimensionValues == null || dimensionValues.isEmpty()) {
                            return matchNull;
                        }
                        for (String dimensionValue : dimensionValues) {
                            if (!predicate.apply(extractionFn.apply(NullHandlingHelper.defaultToNull(dimensionValue)))) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                        inspector.visit("predicate", predicate);
                    }
                };
            }

            @Override
            public int getValueCardinality() {
                return -1;
            }

            @Override
            public String lookupName(int id) {
                String value = NullHandlingHelper.defaultToNull(((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension).get(id));
                return extractionFn == null ? value : extractionFn.apply(value);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return false;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                inspector.visit("extractionFn", extractionFn);
            }
        };
    }

    @Override
    public FloatColumnSelector makeFloatColumnSelector(final String columnName) {
        if (columnName.equals("__time")) {
            class TimeFloatColumnSelector
            extends RowBasedFloatColumnSelector {
                TimeFloatColumnSelector() {
                    abstract class RowBasedFloatColumnSelector
                    implements FloatColumnSelector {
                        RowBasedFloatColumnSelector() {
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                        }
                    }
                }

                @Override
                public float getFloat() {
                    return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch();
                }

                @Override
                public boolean isNull() {
                    return false;
                }
            }
            return new TimeFloatColumnSelector();
        }
        return new RowBasedFloatColumnSelector(){
            {
            }

            @Override
            public float getFloat() {
                return DimensionHandlerUtils.nullToZero(((Row)RowBasedColumnSelectorFactory.this.row.get()).getFloatMetric(columnName)).floatValue();
            }

            @Override
            public boolean isNull() {
                return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getFloatMetric(columnName) == null;
            }
        };
    }

    @Override
    public LongColumnSelector makeLongColumnSelector(final String columnName) {
        if (columnName.equals("__time")) {
            class TimeLongColumnSelector
            extends RowBasedLongColumnSelector {
                TimeLongColumnSelector() {
                    abstract class RowBasedLongColumnSelector
                    implements LongColumnSelector {
                        RowBasedLongColumnSelector() {
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                        }
                    }
                }

                @Override
                public long getLong() {
                    return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch();
                }

                @Override
                public boolean isNull() {
                    return false;
                }
            }
            return new TimeLongColumnSelector();
        }
        return new RowBasedLongColumnSelector(){
            {
            }

            @Override
            public long getLong() {
                return DimensionHandlerUtils.nullToZero(((Row)RowBasedColumnSelectorFactory.this.row.get()).getLongMetric(columnName));
            }

            @Override
            public boolean isNull() {
                return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getLongMetric(columnName) == null;
            }
        };
    }

    @Override
    public ObjectColumnSelector makeObjectColumnSelector(final String columnName) {
        if (columnName.equals("__time")) {
            return new ObjectColumnSelector(){

                public Class classOfObject() {
                    return Long.class;
                }

                public Object get() {
                    return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch();
                }
            };
        }
        return new ObjectColumnSelector(){

            public Class classOfObject() {
                return Object.class;
            }

            public Object get() {
                return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getRaw(columnName);
            }
        };
    }

    @Override
    public DoubleColumnSelector makeDoubleColumnSelector(final String columnName) {
        if (columnName.equals("__time")) {
            class TimeDoubleColumnSelector
            extends RowBasedDoubleColumnSelector {
                TimeDoubleColumnSelector() {
                    abstract class RowBasedDoubleColumnSelector
                    implements DoubleColumnSelector {
                        RowBasedDoubleColumnSelector() {
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                        }
                    }
                }

                @Override
                public double getDouble() {
                    return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch();
                }

                @Override
                public boolean isNull() {
                    return false;
                }
            }
            return new TimeDoubleColumnSelector();
        }
        return new RowBasedDoubleColumnSelector(){
            {
            }

            @Override
            public double getDouble() {
                return DimensionHandlerUtils.nullToZero(((Row)RowBasedColumnSelectorFactory.this.row.get()).getDoubleMetric(columnName));
            }

            @Override
            public boolean isNull() {
                return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDoubleMetric(columnName) == null;
            }
        };
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if ("__time".equals(columnName)) {
            return new ColumnCapabilitiesImpl().setType(ValueType.LONG);
        }
        ValueType valueType = this.rowSignature.get(columnName);
        return valueType != null ? new ColumnCapabilitiesImpl().setType(valueType) : null;
    }
}

