/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Functions;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Queries;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryDataSource;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryHelper;
import org.apache.hive.druid.io.druid.query.groupby.having.HavingSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.LimitSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.hive.druid.io.druid.query.ordering.StringComparator;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.query.spec.LegacySegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.VirtualColumn;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.joda.time.Interval;

public class GroupByQuery
extends BaseQuery<Row> {
    public static final String CTX_KEY_SORT_BY_DIMS_FIRST = "sortByDimsFirst";
    private static final Comparator<Row> NON_GRANULAR_TIME_COMP = (lhs, rhs) -> Longs.compare(lhs.getTimestampFromEpoch(), rhs.getTimestampFromEpoch());
    private final VirtualColumns virtualColumns;
    private final LimitSpec limitSpec;
    private final HavingSpec havingSpec;
    private final DimFilter dimFilter;
    private final Granularity granularity;
    private final List<DimensionSpec> dimensions;
    private final List<AggregatorFactory> aggregatorSpecs;
    private final List<PostAggregator> postAggregatorSpecs;
    private final Function<Sequence<Row>, Sequence<Row>> limitFn;
    private final boolean applyLimitPushDown;
    private final Function<Sequence<Row>, Sequence<Row>> postProcessingFn;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public GroupByQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") Granularity granularity, @JsonProperty(value="dimensions") List<DimensionSpec> dimensions, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregatorSpecs, @JsonProperty(value="postAggregations") List<PostAggregator> postAggregatorSpecs, @JsonProperty(value="having") HavingSpec havingSpec, @JsonProperty(value="limitSpec") LimitSpec limitSpec, @JsonProperty(value="context") Map<String, Object> context) {
        this(dataSource, querySegmentSpec, virtualColumns, dimFilter, granularity, dimensions, aggregatorSpecs, postAggregatorSpecs, havingSpec, limitSpec, null, context);
    }

    private Function<Sequence<Row>, Sequence<Row>> makePostProcessingFn() {
        Function<Sequence<Row>, Sequence<Row>> postProcessingFn = this.limitSpec.build(this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs);
        if (this.havingSpec != null) {
            postProcessingFn = Functions.compose(postProcessingFn, input -> {
                this.havingSpec.setRowSignature(GroupByQueryHelper.rowSignatureFor(this));
                return Sequences.filter(input, this.havingSpec::eval);
            });
        }
        return postProcessingFn;
    }

    private GroupByQuery(DataSource dataSource, QuerySegmentSpec querySegmentSpec, VirtualColumns virtualColumns, DimFilter dimFilter, Granularity granularity, List<DimensionSpec> dimensions, List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs, HavingSpec havingSpec, LimitSpec limitSpec, @Nullable Function<Sequence<Row>, Sequence<Row>> postProcessingFn, Map<String, Object> context) {
        super(dataSource, querySegmentSpec, false, context);
        this.virtualColumns = VirtualColumns.nullToEmpty(virtualColumns);
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.dimensions = dimensions == null ? ImmutableList.of() : dimensions;
        for (DimensionSpec spec : this.dimensions) {
            Preconditions.checkArgument(spec != null, "dimensions has null DimensionSpec");
        }
        this.aggregatorSpecs = aggregatorSpecs == null ? ImmutableList.of() : aggregatorSpecs;
        this.postAggregatorSpecs = Queries.prepareAggregations(this.dimensions.stream().map(DimensionSpec::getOutputName).collect(Collectors.toList()), this.aggregatorSpecs, postAggregatorSpecs == null ? ImmutableList.of() : postAggregatorSpecs);
        this.havingSpec = havingSpec;
        this.limitSpec = LimitSpec.nullToNoopLimitSpec(limitSpec);
        Preconditions.checkNotNull(this.granularity, "Must specify a granularity");
        GroupByQuery.verifyOutputNames(this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs);
        this.postProcessingFn = postProcessingFn != null ? postProcessingFn : this.makePostProcessingFn();
        this.applyLimitPushDown = this.determineApplyLimitPushDown();
        Function<Sequence<Row>, Sequence<Row>> postProcFn = this.getContextBoolean("groupByOutermost", true) ? this.limitSpec.build(this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs) : NoopLimitSpec.INSTANCE.build(this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs);
        if (havingSpec != null) {
            postProcFn = Functions.compose(postProcFn, new Function<Sequence<Row>, Sequence<Row>>(){

                @Override
                public Sequence<Row> apply(Sequence<Row> input) {
                    GroupByQuery.this.havingSpec.setRowSignature(GroupByQueryHelper.rowSignatureFor(GroupByQuery.this));
                    return Sequences.filter(input, new Predicate<Row>(){

                        @Override
                        public boolean apply(Row input) {
                            return GroupByQuery.this.havingSpec.eval(input);
                        }
                    });
                }
            });
        }
        this.limitFn = postProcFn;
    }

    @JsonProperty
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public Granularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty
    public List<DimensionSpec> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    @JsonProperty(value="postAggregations")
    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    @JsonProperty(value="having")
    public HavingSpec getHavingSpec() {
        return this.havingSpec;
    }

    @JsonProperty
    public LimitSpec getLimitSpec() {
        return this.limitSpec;
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return "groupBy";
    }

    @JsonIgnore
    public boolean getContextSortByDimsFirst() {
        return this.getContextBoolean(CTX_KEY_SORT_BY_DIMS_FIRST, false);
    }

    @JsonIgnore
    public boolean isApplyLimitPushDown() {
        return this.applyLimitPushDown;
    }

    @JsonIgnore
    public boolean getApplyLimitPushDownFromContext() {
        return this.getContextBoolean("applyLimitPushDown", true);
    }

    @Override
    public Ordering getResultOrdering() {
        Ordering<Row> rowOrdering = this.getRowOrdering(false);
        return Ordering.from((lhs, rhs) -> {
            if (lhs instanceof Row) {
                return rowOrdering.compare((Row)lhs, (Row)rhs);
            }
            return Comparators.naturalNullsFirst().compare(lhs, rhs);
        });
    }

    private boolean validateAndGetForceLimitPushDown() {
        boolean forcePushDown = this.getContextBoolean("forceLimitPushDown", false);
        if (forcePushDown) {
            if (!(this.limitSpec instanceof DefaultLimitSpec)) {
                throw new IAE("When forcing limit push down, a limit spec must be provided.", new Object[0]);
            }
            if (!((DefaultLimitSpec)this.limitSpec).isLimited()) {
                throw new IAE("When forcing limit push down, the provided limit spec must have a limit.", new Object[0]);
            }
            if (this.havingSpec != null) {
                throw new IAE("Cannot force limit push down when a having spec is present.", new Object[0]);
            }
            for (OrderByColumnSpec orderBySpec : ((DefaultLimitSpec)this.limitSpec).getColumns()) {
                if (OrderByColumnSpec.getPostAggIndexForOrderBy(orderBySpec, this.postAggregatorSpecs) <= -1) continue;
                throw new UnsupportedOperationException("Limit push down when sorting by a post aggregator is not supported.");
            }
        }
        return forcePushDown;
    }

    public boolean determineApplyLimitPushDown() {
        boolean forceLimitPushDown = this.validateAndGetForceLimitPushDown();
        if (this.limitSpec instanceof DefaultLimitSpec) {
            DefaultLimitSpec defaultLimitSpec = (DefaultLimitSpec)this.limitSpec;
            if (!defaultLimitSpec.isLimited()) {
                return false;
            }
            if (forceLimitPushDown) {
                return true;
            }
            if (!this.getApplyLimitPushDownFromContext()) {
                return false;
            }
            if (this.havingSpec != null) {
                return false;
            }
            boolean sortHasNonGroupingFields = DefaultLimitSpec.sortingOrderHasNonGroupingFields((DefaultLimitSpec)this.limitSpec, this.getDimensions());
            return !sortHasNonGroupingFields;
        }
        return false;
    }

    private Ordering<Row> getRowOrderingForPushDown(boolean granular, DefaultLimitSpec limitSpec) {
        boolean sortByDimsFirst = this.getContextSortByDimsFirst();
        final ArrayList<String> orderedFieldNames = new ArrayList<String>();
        HashSet<Integer> dimsInOrderBy = new HashSet<Integer>();
        final ArrayList<Boolean> needsReverseList = new ArrayList<Boolean>();
        final ArrayList<Boolean> isNumericField = new ArrayList<Boolean>();
        final ArrayList<StringComparator> comparators = new ArrayList<StringComparator>();
        for (OrderByColumnSpec orderSpec : limitSpec.getColumns()) {
            boolean needsReverse;
            boolean bl = needsReverse = orderSpec.getDirection() != OrderByColumnSpec.Direction.ASCENDING;
            int dimIndex = OrderByColumnSpec.getDimIndexForOrderBy(orderSpec, this.dimensions);
            if (dimIndex < 0) continue;
            DimensionSpec dim = this.dimensions.get(dimIndex);
            orderedFieldNames.add(dim.getOutputName());
            dimsInOrderBy.add(dimIndex);
            needsReverseList.add(needsReverse);
            ValueType type = this.dimensions.get(dimIndex).getOutputType();
            isNumericField.add(ValueType.isNumeric(type));
            comparators.add(orderSpec.getDimensionComparator());
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            if (dimsInOrderBy.contains(i)) continue;
            orderedFieldNames.add(this.dimensions.get(i).getOutputName());
            needsReverseList.add(false);
            ValueType type = this.dimensions.get(i).getOutputType();
            isNumericField.add(ValueType.isNumeric(type));
            comparators.add(StringComparators.LEXICOGRAPHIC);
        }
        final Comparator<Row> timeComparator = this.getTimeComparator(granular);
        if (timeComparator == null) {
            return Ordering.from(new Comparator<Row>(){

                @Override
                public int compare(Row lhs, Row rhs) {
                    return GroupByQuery.compareDimsForLimitPushDown(orderedFieldNames, needsReverseList, isNumericField, comparators, lhs, rhs);
                }
            });
        }
        if (sortByDimsFirst) {
            return Ordering.from(new Comparator<Row>(){

                @Override
                public int compare(Row lhs, Row rhs) {
                    int cmp = GroupByQuery.compareDimsForLimitPushDown(orderedFieldNames, needsReverseList, isNumericField, comparators, lhs, rhs);
                    if (cmp != 0) {
                        return cmp;
                    }
                    return timeComparator.compare(lhs, rhs);
                }
            });
        }
        return Ordering.from(new Comparator<Row>(){

            @Override
            public int compare(Row lhs, Row rhs) {
                int timeCompare = timeComparator.compare(lhs, rhs);
                if (timeCompare != 0) {
                    return timeCompare;
                }
                return GroupByQuery.compareDimsForLimitPushDown(orderedFieldNames, needsReverseList, isNumericField, comparators, lhs, rhs);
            }
        });
    }

    public Ordering<Row> getRowOrdering(boolean granular) {
        if (this.applyLimitPushDown && !DefaultLimitSpec.sortingOrderHasNonGroupingFields((DefaultLimitSpec)this.limitSpec, this.dimensions)) {
            return this.getRowOrderingForPushDown(granular, (DefaultLimitSpec)this.limitSpec);
        }
        boolean sortByDimsFirst = this.getContextSortByDimsFirst();
        Comparator<Row> timeComparator = this.getTimeComparator(granular);
        if (timeComparator == null) {
            return Ordering.from((lhs, rhs) -> GroupByQuery.compareDims(this.dimensions, lhs, rhs));
        }
        if (sortByDimsFirst) {
            return Ordering.from((lhs, rhs) -> {
                int cmp = GroupByQuery.compareDims(this.dimensions, lhs, rhs);
                if (cmp != 0) {
                    return cmp;
                }
                return timeComparator.compare((Row)lhs, (Row)rhs);
            });
        }
        return Ordering.from((lhs, rhs) -> {
            int timeCompare = timeComparator.compare((Row)lhs, (Row)rhs);
            if (timeCompare != 0) {
                return timeCompare;
            }
            return GroupByQuery.compareDims(this.dimensions, lhs, rhs);
        });
    }

    private Comparator<Row> getTimeComparator(boolean granular) {
        if (Granularities.ALL.equals(this.granularity)) {
            return null;
        }
        if (granular) {
            return (lhs, rhs) -> Longs.compare(this.granularity.bucketStart(lhs.getTimestamp()).getMillis(), this.granularity.bucketStart(rhs.getTimestamp()).getMillis());
        }
        return NON_GRANULAR_TIME_COMP;
    }

    private static int compareDims(List<DimensionSpec> dimensions, Row lhs, Row rhs) {
        for (DimensionSpec dimension : dimensions) {
            int dimCompare = dimension.getOutputType() == ValueType.LONG ? Comparators.naturalNullsFirst().compare(DimensionHandlerUtils.convertObjectToLong(lhs.getRaw(dimension.getOutputName())), DimensionHandlerUtils.convertObjectToLong(rhs.getRaw(dimension.getOutputName()))) : (dimension.getOutputType() == ValueType.FLOAT ? Comparators.naturalNullsFirst().compare(DimensionHandlerUtils.convertObjectToFloat(lhs.getRaw(dimension.getOutputName())), DimensionHandlerUtils.convertObjectToFloat(rhs.getRaw(dimension.getOutputName()))) : (dimension.getOutputType() == ValueType.DOUBLE ? Comparators.naturalNullsFirst().compare(DimensionHandlerUtils.convertObjectToDouble(lhs.getRaw(dimension.getOutputName())), DimensionHandlerUtils.convertObjectToDouble(rhs.getRaw(dimension.getOutputName()))) : Comparators.naturalNullsFirst().compare(lhs.getRaw(dimension.getOutputName()), rhs.getRaw(dimension.getOutputName()))));
            if (dimCompare == 0) continue;
            return dimCompare;
        }
        return 0;
    }

    private static int compareDimsForLimitPushDown(List<String> fields, List<Boolean> needsReverseList, List<Boolean> isNumericField, List<StringComparator> comparators, Row lhs, Row rhs) {
        for (int i = 0; i < fields.size(); ++i) {
            Object rhsObj;
            Object lhsObj;
            String fieldName = fields.get(i);
            StringComparator comparator = comparators.get(i);
            if (needsReverseList.get(i).booleanValue()) {
                lhsObj = rhs.getRaw(fieldName);
                rhsObj = lhs.getRaw(fieldName);
            } else {
                lhsObj = lhs.getRaw(fieldName);
                rhsObj = rhs.getRaw(fieldName);
            }
            int dimCompare = isNumericField.get(i).booleanValue() ? (comparator == StringComparators.NUMERIC ? Comparators.naturalNullsFirst().compare(rhs.getRaw(fieldName), lhs.getRaw(fieldName)) : comparator.compare(String.valueOf(lhsObj), String.valueOf(rhsObj))) : comparator.compare((String)lhsObj, (String)rhsObj);
            if (dimCompare == 0) continue;
            return dimCompare;
        }
        return 0;
    }

    public Sequence<Row> postProcess(Sequence<Row> results) {
        return this.postProcessingFn.apply(results);
    }

    public GroupByQuery withOverriddenContext(Map<String, Object> contextOverride) {
        return new Builder(this).overrideContext(contextOverride).build();
    }

    public GroupByQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new Builder(this).setQuerySegmentSpec(spec).build();
    }

    public GroupByQuery withDimFilter(DimFilter dimFilter) {
        return new Builder(this).setDimFilter(dimFilter).build();
    }

    @Override
    public Query<Row> withDataSource(DataSource dataSource) {
        return new Builder(this).setDataSource(dataSource).build();
    }

    public GroupByQuery withDimensionSpecs(List<DimensionSpec> dimensionSpecs) {
        return new Builder(this).setDimensions(dimensionSpecs).build();
    }

    public GroupByQuery withLimitSpec(LimitSpec limitSpec) {
        return new Builder(this).setLimitSpec(limitSpec).build();
    }

    public GroupByQuery withAggregatorSpecs(List<AggregatorFactory> aggregatorSpecs) {
        return new Builder(this).setAggregatorSpecs(aggregatorSpecs).build();
    }

    public GroupByQuery withPostAggregatorSpecs(List<PostAggregator> postAggregatorSpecs) {
        return new Builder(this).setPostAggregatorSpecs(postAggregatorSpecs).build();
    }

    private static void verifyOutputNames(List<DimensionSpec> dimensions, List<AggregatorFactory> aggregators, List<PostAggregator> postAggregators) {
        HashSet<String> outputNames = Sets.newHashSet();
        for (DimensionSpec dimension : dimensions) {
            if (outputNames.add(dimension.getOutputName())) continue;
            throw new IAE("Duplicate output name[%s]", dimension.getOutputName());
        }
        for (AggregatorFactory aggregator : aggregators) {
            if (outputNames.add(aggregator.getName())) continue;
            throw new IAE("Duplicate output name[%s]", aggregator.getName());
        }
        for (PostAggregator postAggregator : postAggregators) {
            if (outputNames.add(postAggregator.getName())) continue;
            throw new IAE("Duplicate output name[%s]", postAggregator.getName());
        }
        if (outputNames.contains("__time")) {
            throw new IAE("'%s' cannot be used as an output name for dimensions, aggregators, or post-aggregators.", "__time");
        }
    }

    public String toString() {
        return "GroupByQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", virtualColumns=" + this.virtualColumns + ", limitSpec=" + this.limitSpec + ", dimFilter=" + this.dimFilter + ", granularity=" + this.granularity + ", dimensions=" + this.dimensions + ", aggregatorSpecs=" + this.aggregatorSpecs + ", postAggregatorSpecs=" + this.postAggregatorSpecs + ", havingSpec=" + this.havingSpec + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupByQuery that = (GroupByQuery)o;
        return Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.equals(this.limitSpec, that.limitSpec) && Objects.equals(this.havingSpec, that.havingSpec) && Objects.equals(this.dimFilter, that.dimFilter) && Objects.equals(this.granularity, that.granularity) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.aggregatorSpecs, that.aggregatorSpecs) && Objects.equals(this.postAggregatorSpecs, that.postAggregatorSpecs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.virtualColumns, this.limitSpec, this.havingSpec, this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs);
    }

    public static class Builder {
        private DataSource dataSource;
        private QuerySegmentSpec querySegmentSpec;
        private VirtualColumns virtualColumns;
        private DimFilter dimFilter;
        private Granularity granularity;
        private List<DimensionSpec> dimensions;
        private List<AggregatorFactory> aggregatorSpecs;
        private List<PostAggregator> postAggregatorSpecs;
        private HavingSpec havingSpec;
        private Map<String, Object> context;
        private LimitSpec limitSpec = null;
        private Function<Sequence<Row>, Sequence<Row>> postProcessingFn;
        private List<OrderByColumnSpec> orderByColumnSpecs = Lists.newArrayList();
        private int limit = Integer.MAX_VALUE;

        public Builder() {
        }

        public Builder(GroupByQuery query) {
            this.dataSource = query.getDataSource();
            this.querySegmentSpec = query.getQuerySegmentSpec();
            this.virtualColumns = query.getVirtualColumns();
            this.dimFilter = query.getDimFilter();
            this.granularity = query.getGranularity();
            this.dimensions = query.getDimensions();
            this.aggregatorSpecs = query.getAggregatorSpecs();
            this.postAggregatorSpecs = query.getPostAggregatorSpecs();
            this.havingSpec = query.getHavingSpec();
            this.limitSpec = query.getLimitSpec();
            this.postProcessingFn = query.postProcessingFn;
            this.context = query.getContext();
        }

        public Builder(Builder builder) {
            this.dataSource = builder.dataSource;
            this.querySegmentSpec = builder.querySegmentSpec;
            this.virtualColumns = builder.virtualColumns;
            this.dimFilter = builder.dimFilter;
            this.granularity = builder.granularity;
            this.dimensions = builder.dimensions;
            this.aggregatorSpecs = builder.aggregatorSpecs;
            this.postAggregatorSpecs = builder.postAggregatorSpecs;
            this.havingSpec = builder.havingSpec;
            this.limitSpec = builder.limitSpec;
            this.postProcessingFn = builder.postProcessingFn;
            this.limit = builder.limit;
            this.orderByColumnSpecs = new ArrayList<OrderByColumnSpec>(builder.orderByColumnSpecs);
            this.context = builder.context;
        }

        public Builder setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder setDataSource(String dataSource) {
            this.dataSource = new TableDataSource(dataSource);
            return this;
        }

        public Builder setDataSource(Query query) {
            this.dataSource = new QueryDataSource(query);
            return this;
        }

        public Builder setInterval(QuerySegmentSpec interval) {
            return this.setQuerySegmentSpec(interval);
        }

        public Builder setInterval(List<Interval> intervals) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec((Object)intervals));
        }

        public Builder setInterval(Interval interval) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec(interval));
        }

        public Builder setInterval(String interval) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec(interval));
        }

        public Builder setVirtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = Preconditions.checkNotNull(virtualColumns, "virtualColumns");
            return this;
        }

        public Builder setVirtualColumns(List<VirtualColumn> virtualColumns) {
            this.virtualColumns = VirtualColumns.create(virtualColumns);
            return this;
        }

        public Builder setVirtualColumns(VirtualColumn ... virtualColumns) {
            this.virtualColumns = VirtualColumns.create(Arrays.asList(virtualColumns));
            return this;
        }

        public Builder setLimit(int limit) {
            this.ensureExplicitLimitSpecNotSet();
            this.limit = limit;
            this.postProcessingFn = null;
            return this;
        }

        public Builder addOrderByColumn(String dimension) {
            return this.addOrderByColumn(dimension, null);
        }

        public Builder addOrderByColumn(String dimension, OrderByColumnSpec.Direction direction) {
            return this.addOrderByColumn(new OrderByColumnSpec(dimension, direction));
        }

        public Builder addOrderByColumn(OrderByColumnSpec columnSpec) {
            this.ensureExplicitLimitSpecNotSet();
            this.orderByColumnSpecs.add(columnSpec);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setLimitSpec(LimitSpec limitSpec) {
            Preconditions.checkNotNull(limitSpec);
            this.ensureFluentLimitsNotSet();
            this.limitSpec = limitSpec;
            this.postProcessingFn = null;
            return this;
        }

        private void ensureExplicitLimitSpecNotSet() {
            if (this.limitSpec != null) {
                throw new ISE("Ambiguous build, limitSpec[%s] already set", this.limitSpec);
            }
        }

        private void ensureFluentLimitsNotSet() {
            if (this.limit != Integer.MAX_VALUE || !this.orderByColumnSpecs.isEmpty()) {
                throw new ISE("Ambiguous build, limit[%s] or columnSpecs[%s] already set.", this.limit, this.orderByColumnSpecs);
            }
        }

        public Builder setQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
            this.querySegmentSpec = querySegmentSpec;
            return this;
        }

        public Builder setDimFilter(DimFilter dimFilter) {
            this.dimFilter = dimFilter;
            return this;
        }

        public Builder setGranularity(Granularity granularity) {
            this.granularity = granularity;
            return this;
        }

        public Builder addDimension(String column) {
            return this.addDimension(column, column);
        }

        public Builder addDimension(String column, String outputName) {
            return this.addDimension(new DefaultDimensionSpec(column, outputName));
        }

        public Builder addDimension(DimensionSpec dimension) {
            if (this.dimensions == null) {
                this.dimensions = Lists.newArrayList();
            }
            this.dimensions.add(dimension);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setDimensions(List<DimensionSpec> dimensions) {
            this.dimensions = Lists.newArrayList(dimensions);
            this.postProcessingFn = null;
            return this;
        }

        public Builder addAggregator(AggregatorFactory aggregator) {
            if (this.aggregatorSpecs == null) {
                this.aggregatorSpecs = Lists.newArrayList();
            }
            this.aggregatorSpecs.add(aggregator);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setAggregatorSpecs(List<AggregatorFactory> aggregatorSpecs) {
            this.aggregatorSpecs = Lists.newArrayList(aggregatorSpecs);
            this.postProcessingFn = null;
            return this;
        }

        public Builder addPostAggregator(PostAggregator postAgg) {
            if (this.postAggregatorSpecs == null) {
                this.postAggregatorSpecs = Lists.newArrayList();
            }
            this.postAggregatorSpecs.add(postAgg);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setPostAggregatorSpecs(List<PostAggregator> postAggregatorSpecs) {
            this.postAggregatorSpecs = Lists.newArrayList(postAggregatorSpecs);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setContext(Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public Builder overrideContext(Map<String, Object> contextOverride) {
            this.context = GroupByQuery.computeOverriddenContext(this.context, contextOverride);
            return this;
        }

        public Builder setHavingSpec(HavingSpec havingSpec) {
            this.havingSpec = havingSpec;
            this.postProcessingFn = null;
            return this;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public GroupByQuery build() {
            LimitSpec theLimitSpec = this.limitSpec == null ? (this.orderByColumnSpecs.isEmpty() && this.limit == Integer.MAX_VALUE ? NoopLimitSpec.instance() : new DefaultLimitSpec(this.orderByColumnSpecs, this.limit)) : this.limitSpec;
            return new GroupByQuery(this.dataSource, this.querySegmentSpec, this.virtualColumns, this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs, this.havingSpec, theLimitSpec, this.postProcessingFn, this.context);
        }
    }
}

