/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.extraction;

import java.nio.ByteBuffer;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.query.extraction.DimExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.search.search.SearchQuerySpec;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;

public class SearchQuerySpecDimExtractionFn
extends DimExtractionFn {
    private final SearchQuerySpec searchQuerySpec;

    @JsonCreator
    public SearchQuerySpecDimExtractionFn(@JsonProperty(value="query") SearchQuerySpec searchQuerySpec) {
        Preconditions.checkNotNull(searchQuerySpec, "search query must not be null");
        this.searchQuerySpec = searchQuerySpec;
    }

    @JsonProperty(value="query")
    public SearchQuerySpec getSearchQuerySpec() {
        return this.searchQuerySpec;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] specBytes = this.searchQuerySpec.getCacheKey();
        return ByteBuffer.allocate(1 + specBytes.length).put((byte)3).put(specBytes).array();
    }

    @Override
    public String apply(String dimValue) {
        return this.searchQuerySpec.accept(dimValue) ? NullHandlingHelper.defaultToNull(dimValue) : null;
    }

    @Override
    public boolean preservesOrdering() {
        return true;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public String toString() {
        return "SearchQuerySpecDimExtractionFn{searchQuerySpec=" + this.searchQuerySpec + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchQuerySpecDimExtractionFn that = (SearchQuerySpecDimExtractionFn)o;
        return this.searchQuerySpec.equals(that.searchQuerySpec);
    }

    public int hashCode() {
        return this.searchQuerySpec.hashCode();
    }
}

