/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.extraction;

import java.util.Arrays;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.primitives.Bytes;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;

public class CascadeExtractionFn
implements ExtractionFn {
    private final ExtractionFn[] extractionFns;
    private final ChainedExtractionFn chainedExtractionFn;
    private final ChainedExtractionFn DEFAULT_CHAINED_EXTRACTION_FN = new ChainedExtractionFn(new ExtractionFn(){

        @Override
        public byte[] getCacheKey() {
            return new byte[0];
        }

        @Override
        public String apply(Object value) {
            return null;
        }

        @Override
        public String apply(String value) {
            return null;
        }

        @Override
        public String apply(long value) {
            return null;
        }

        @Override
        public boolean preservesOrdering() {
            return false;
        }

        @Override
        public ExtractionFn.ExtractionType getExtractionType() {
            return ExtractionFn.ExtractionType.MANY_TO_ONE;
        }

        public String toString() {
            return "nullExtractionFn{}";
        }
    }, null);

    @JsonCreator
    public CascadeExtractionFn(@JsonProperty(value="extractionFns") ExtractionFn[] extractionFn) {
        Preconditions.checkArgument(extractionFn != null, "extractionFns should not be null");
        this.extractionFns = extractionFn;
        if (this.extractionFns.length == 0) {
            this.chainedExtractionFn = this.DEFAULT_CHAINED_EXTRACTION_FN;
        } else {
            ChainedExtractionFn root = null;
            for (ExtractionFn fn : extractionFn) {
                Preconditions.checkArgument(fn != null, "empty function is not allowed");
                root = new ChainedExtractionFn(fn, root);
            }
            this.chainedExtractionFn = root;
        }
    }

    @JsonProperty
    public ExtractionFn[] getExtractionFns() {
        return this.extractionFns;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] cacheKey = new byte[]{9};
        return Bytes.concat(cacheKey, this.chainedExtractionFn.getCacheKey());
    }

    @Override
    public String apply(Object value) {
        return this.chainedExtractionFn.apply(value);
    }

    @Override
    public String apply(String value) {
        return this.chainedExtractionFn.apply(value);
    }

    @Override
    public String apply(long value) {
        return this.chainedExtractionFn.apply(value);
    }

    @Override
    public boolean preservesOrdering() {
        return this.chainedExtractionFn.preservesOrdering();
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return this.chainedExtractionFn.getExtractionType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CascadeExtractionFn that = (CascadeExtractionFn)o;
        if (!Arrays.equals(this.extractionFns, that.extractionFns)) {
            return false;
        }
        return this.chainedExtractionFn.equals(that.chainedExtractionFn);
    }

    public int hashCode() {
        return this.chainedExtractionFn.hashCode();
    }

    public String toString() {
        return "CascadeExtractionFn{extractionFns=[" + this.chainedExtractionFn.toString() + "]}";
    }

    private static class ChainedExtractionFn {
        private final ExtractionFn fn;
        private final ChainedExtractionFn child;

        public ChainedExtractionFn(ExtractionFn fn, ChainedExtractionFn child) {
            this.fn = fn;
            this.child = child;
        }

        public byte[] getCacheKey() {
            byte[] fnCacheKey = this.fn.getCacheKey();
            return this.child != null ? Bytes.concat(fnCacheKey, this.child.getCacheKey()) : fnCacheKey;
        }

        public String apply(Object value) {
            return this.fn.apply(this.child != null ? this.child.apply(value) : value);
        }

        public String apply(String value) {
            return this.fn.apply(this.child != null ? this.child.apply(value) : value);
        }

        public String apply(long value) {
            return this.fn.apply(this.child != null ? this.child.apply(value) : Long.valueOf(value));
        }

        public boolean preservesOrdering() {
            boolean childPreservesOrdering = this.child == null || this.child.preservesOrdering();
            return this.fn.preservesOrdering() && childPreservesOrdering;
        }

        public ExtractionFn.ExtractionType getExtractionType() {
            if (this.child != null && this.child.getExtractionType() == ExtractionFn.ExtractionType.MANY_TO_ONE) {
                return ExtractionFn.ExtractionType.MANY_TO_ONE;
            }
            return this.fn.getExtractionType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChainedExtractionFn that = (ChainedExtractionFn)o;
            if (!this.fn.equals(that.fn)) {
                return false;
            }
            return this.child == null || this.child.equals(that.child);
        }

        public int hashCode() {
            int result = this.fn.hashCode();
            if (this.child != null) {
                result = 31 * result + this.child.hashCode();
            }
            return result;
        }

        public String toString() {
            return this.child != null ? Joiner.on(",").join(this.child.toString(), this.fn.toString(), new Object[0]) : this.fn.toString();
        }
    }
}

