/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.dimension;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.IdLookup;
import org.apache.hive.druid.io.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;

final class PredicateFilteredDimensionSelector
implements DimensionSelector {
    private final DimensionSelector selector;
    private final Predicate<String> predicate;

    PredicateFilteredDimensionSelector(DimensionSelector selector, Predicate<String> predicate) {
        this.selector = selector;
        this.predicate = predicate;
    }

    @Override
    public IndexedInts getRow() {
        IndexedInts baseRow = this.selector.getRow();
        int baseRowSize = baseRow.size();
        int[] result = new int[baseRowSize];
        int resultSize = 0;
        for (int i = 0; i < baseRowSize; ++i) {
            if (!this.predicate.apply(this.selector.lookupName(baseRow.get(i)))) continue;
            result[resultSize++] = i;
        }
        return ArrayBasedIndexedInts.of(result, resultSize);
    }

    @Override
    public ValueMatcher makeValueMatcher(final String value) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                IndexedInts baseRow = PredicateFilteredDimensionSelector.this.selector.getRow();
                int baseRowSize = baseRow.size();
                boolean nullRow = true;
                for (int i = 0; i < baseRowSize; ++i) {
                    String rowValue = PredicateFilteredDimensionSelector.this.lookupName(baseRow.get(i));
                    if (!PredicateFilteredDimensionSelector.this.predicate.apply(rowValue)) continue;
                    if (Objects.equals(rowValue, value)) {
                        return true;
                    }
                    nullRow = false;
                }
                return nullRow && value == null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", PredicateFilteredDimensionSelector.this);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final Predicate<String> matcherPredicate) {
        final boolean matchNull = this.predicate.apply(null);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                IndexedInts baseRow = PredicateFilteredDimensionSelector.this.selector.getRow();
                int baseRowSize = baseRow.size();
                boolean nullRow = true;
                for (int i = 0; i < baseRowSize; ++i) {
                    String rowValue = PredicateFilteredDimensionSelector.this.lookupName(baseRow.get(i));
                    if (!PredicateFilteredDimensionSelector.this.predicate.apply(rowValue)) continue;
                    if (matcherPredicate.apply(rowValue)) {
                        return true;
                    }
                    nullRow = false;
                }
                return nullRow && matchNull;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", PredicateFilteredDimensionSelector.this);
                inspector.visit("matcherPredicate", matcherPredicate);
            }
        };
    }

    @Override
    public int getValueCardinality() {
        return this.selector.getValueCardinality();
    }

    @Override
    public String lookupName(int id) {
        return this.selector.lookupName(id);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return this.selector.nameLookupPossibleInAdvance();
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this.selector.idLookup();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("predicate", this.predicate);
    }
}

