/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.dimension;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.query.dimension.BaseFilteredDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.ForwardingFilteredDimensionSelector;
import org.apache.hive.druid.io.druid.query.dimension.PredicateFilteredDimensionSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.IdLookup;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;

public class ListFilteredDimensionSpec
extends BaseFilteredDimensionSpec {
    private static final byte CACHE_TYPE_ID = 3;
    private final Set<String> values;
    private final boolean isWhitelist;

    public ListFilteredDimensionSpec(@JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="values") Set<String> values, @JsonProperty(value="isWhitelist") Boolean isWhitelist) {
        super(delegate);
        Preconditions.checkArgument(values != null && values.size() > 0, "values list must be non-empty");
        this.values = values;
        this.isWhitelist = isWhitelist == null ? true : isWhitelist;
    }

    @JsonProperty
    public Set<String> getValues() {
        return this.values;
    }

    @JsonProperty(value="isWhitelist")
    public boolean isWhitelist() {
        return this.isWhitelist;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        if (selector == null) {
            return null;
        }
        if (this.isWhitelist) {
            return this.filterWhiteList(selector);
        }
        return this.filterBlackList(selector);
    }

    private DimensionSelector filterWhiteList(DimensionSelector selector) {
        int selectorCardinality = selector.getValueCardinality();
        if (selectorCardinality < 0 || selector.idLookup() == null && !selector.nameLookupPossibleInAdvance()) {
            return new PredicateFilteredDimensionSelector(selector, Predicates.in(this.values));
        }
        int maxPossibleFilteredCardinality = this.values.size();
        int count = 0;
        Int2IntOpenHashMap forwardMapping = new Int2IntOpenHashMap(maxPossibleFilteredCardinality);
        forwardMapping.defaultReturnValue(-1);
        int[] reverseMapping = new int[maxPossibleFilteredCardinality];
        IdLookup idLookup = selector.idLookup();
        if (idLookup != null) {
            for (String value : this.values) {
                int i = idLookup.lookupId(value);
                if (i < 0) continue;
                forwardMapping.put(i, count);
                reverseMapping[count++] = i;
            }
        } else {
            for (int i = 0; i < selectorCardinality; ++i) {
                if (!this.values.contains(NullHandlingHelper.nullToDefault(selector.lookupName(i)))) continue;
                forwardMapping.put(i, count);
                reverseMapping[count++] = i;
            }
        }
        return new ForwardingFilteredDimensionSelector(selector, forwardMapping, reverseMapping);
    }

    private DimensionSelector filterBlackList(DimensionSelector selector) {
        int selectorCardinality = selector.getValueCardinality();
        if (selectorCardinality < 0 || !selector.nameLookupPossibleInAdvance()) {
            return new PredicateFilteredDimensionSelector(selector, new Predicate<String>(){

                @Override
                public boolean apply(@Nullable String input) {
                    return !ListFilteredDimensionSpec.this.values.contains(input);
                }
            });
        }
        int maxPossibleFilteredCardinality = selectorCardinality;
        int count = 0;
        Int2IntOpenHashMap forwardMapping = new Int2IntOpenHashMap(maxPossibleFilteredCardinality);
        forwardMapping.defaultReturnValue(-1);
        int[] reverseMapping = new int[maxPossibleFilteredCardinality];
        for (int i = 0; i < selectorCardinality; ++i) {
            if (this.values.contains(NullHandlingHelper.nullToDefault(selector.lookupName(i)))) continue;
            forwardMapping.put(i, count);
            reverseMapping[count++] = i;
        }
        return new ForwardingFilteredDimensionSelector(selector, forwardMapping, reverseMapping);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] delegateCacheKey = this.delegate.getCacheKey();
        byte[][] valuesBytes = new byte[this.values.size()][];
        int valuesBytesSize = 0;
        int index = 0;
        for (String value : this.values) {
            valuesBytes[index] = StringUtils.toUtf8(value);
            valuesBytesSize += valuesBytes[index].length + 1;
            ++index;
        }
        ByteBuffer filterCacheKey = ByteBuffer.allocate(3 + delegateCacheKey.length + valuesBytesSize).put((byte)3).put(delegateCacheKey).put((byte)(this.isWhitelist ? 1 : 0)).put((byte)-1);
        for (byte[] bytes : valuesBytes) {
            filterCacheKey.put(bytes).put((byte)-1);
        }
        return filterCacheKey.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListFilteredDimensionSpec that = (ListFilteredDimensionSpec)o;
        if (this.isWhitelist != that.isWhitelist) {
            return false;
        }
        return this.values.equals(that.values);
    }

    public int hashCode() {
        int result = this.values.hashCode();
        result = 31 * result + (this.isWhitelist ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ListFilteredDimensionSpec{values=" + this.values + ", isWhitelist=" + this.isWhitelist + '}';
    }
}

